@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.inputs

import com.pulumi.aws.gamelift.inputs.GameServerGroupLaunchTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id A unique identifier for an existing EC2 launch template.
 * @property name A readable identifier for an existing EC2 launch template.
 * @property version The version of the EC2 launch template to use. If none is set, the default is the first version created.
 */
public data class GameServerGroupLaunchTemplateArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.gamelift.inputs.GameServerGroupLaunchTemplateArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.inputs.GameServerGroupLaunchTemplateArgs =
        com.pulumi.aws.gamelift.inputs.GameServerGroupLaunchTemplateArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GameServerGroupLaunchTemplateArgs].
 */
@PulumiTagMarker
public class GameServerGroupLaunchTemplateArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value A unique identifier for an existing EC2 launch template.
     */
    @JvmName("gwejxgthgqkabrhf")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value A readable identifier for an existing EC2 launch template.
     */
    @JvmName("oxyqejydbleltpim")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The version of the EC2 launch template to use. If none is set, the default is the first version created.
     */
    @JvmName("ugvwivgmujbbnwdc")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value A unique identifier for an existing EC2 launch template.
     */
    @JvmName("svnfarkgtlpwxqgu")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value A readable identifier for an existing EC2 launch template.
     */
    @JvmName("jvmampxmbrcdqdoi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The version of the EC2 launch template to use. If none is set, the default is the first version created.
     */
    @JvmName("ktdjnayawewxgbed")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): GameServerGroupLaunchTemplateArgs = GameServerGroupLaunchTemplateArgs(
        id = id,
        name = name,
        version = version,
    )
}
