@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.inputs

import com.pulumi.aws.gamelift.inputs.MatchmakingConfigurationGamePropertyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key A game property key
 * @property value A game property value.
 */
public data class MatchmakingConfigurationGamePropertyArgs(
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.gamelift.inputs.MatchmakingConfigurationGamePropertyArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.inputs.MatchmakingConfigurationGamePropertyArgs =
        com.pulumi.aws.gamelift.inputs.MatchmakingConfigurationGamePropertyArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MatchmakingConfigurationGamePropertyArgs].
 */
@PulumiTagMarker
public class MatchmakingConfigurationGamePropertyArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value A game property key
     */
    @JvmName("oxocxokkktqjabxq")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value A game property value.
     */
    @JvmName("cqckthfvxxckertm")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value A game property key
     */
    @JvmName("dbuyeoxghdjjfuov")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value A game property value.
     */
    @JvmName("enbcfkcwuxgqmlof")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): MatchmakingConfigurationGamePropertyArgs =
        MatchmakingConfigurationGamePropertyArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
