@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property fleetId ID of the GameLift Fleet to point the alias to.
 * @property message Message text to be used with the `TERMINAL` routing strategy.
 * @property type Type of routing strategyE.g., `SIMPLE` or `TERMINAL`
 */
public data class AliasRoutingStrategy(
    public val fleetId: String? = null,
    public val message: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.gamelift.outputs.AliasRoutingStrategy):
            AliasRoutingStrategy = AliasRoutingStrategy(
            fleetId = javaType.fleetId().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
