@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property certificateType Indicates whether a TLS/SSL certificate is generated for a fleet. Valid values are `DISABLED` and `GENERATED`. Default value is `DISABLED`.
 */
public data class FleetCertificateConfiguration(
    public val certificateType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.gamelift.outputs.FleetCertificateConfiguration):
            FleetCertificateConfiguration = FleetCertificateConfiguration(
            certificateType = javaType.certificateType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
