@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property fromPort Starting value for a range of allowed port numbers.
 * @property ipRange Range of allowed IP addresses expressed in CIDR notationE.g., `000.000.000.000/[subnet mask]` or `0&#46;0&#46;0&#46;0/[subnet mask]`.
 * @property protocol Network communication protocol used by the fleetE.g., `TCP` or `UDP`
 * @property toPort Ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than `from_port`.
 */
public data class FleetEc2InboundPermission(
    public val fromPort: Int,
    public val ipRange: String,
    public val protocol: String,
    public val toPort: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.gamelift.outputs.FleetEc2InboundPermission):
            FleetEc2InboundPermission = FleetEc2InboundPermission(
            fromPort = javaType.fromPort(),
            ipRange = javaType.ipRange(),
            protocol = javaType.protocol(),
            toPort = javaType.toPort(),
        )
    }
}
