@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property newGameSessionsPerCreator Maximum number of game sessions that an individual can create during the policy period.
 * @property policyPeriodInMinutes Time span used in evaluating the resource creation limit policy.
 */
public data class FleetResourceCreationLimitPolicy(
    public val newGameSessionsPerCreator: Int? = null,
    public val policyPeriodInMinutes: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.gamelift.outputs.FleetResourceCreationLimitPolicy):
            FleetResourceCreationLimitPolicy = FleetResourceCreationLimitPolicy(
            newGameSessionsPerCreator = javaType.newGameSessionsPerCreator().map({ args0 ->
                args0
            }).orElse(null),
            policyPeriodInMinutes = javaType.policyPeriodInMinutes().map({ args0 -> args0 }).orElse(null),
        )
    }
}
