@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property gameSessionActivationTimeoutSeconds Maximum amount of time (in seconds) that a game session can remain in status `ACTIVATING`.
 * @property maxConcurrentGameSessionActivations Maximum number of game sessions with status `ACTIVATING` to allow on an instance simultaneously.
 * @property serverProcesses Collection of server process configurations that describe which server processes to run on each instance in a fleet. See below.
 */
public data class FleetRuntimeConfiguration(
    public val gameSessionActivationTimeoutSeconds: Int? = null,
    public val maxConcurrentGameSessionActivations: Int? = null,
    public val serverProcesses: List<FleetRuntimeConfigurationServerProcess>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.gamelift.outputs.FleetRuntimeConfiguration):
            FleetRuntimeConfiguration = FleetRuntimeConfiguration(
            gameSessionActivationTimeoutSeconds = javaType.gameSessionActivationTimeoutSeconds().map({ args0 ->
                args0
            }).orElse(null),
            maxConcurrentGameSessionActivations = javaType.maxConcurrentGameSessionActivations().map({ args0 ->
                args0
            }).orElse(null),
            serverProcesses = javaType.serverProcesses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.gamelift.kotlin.outputs.FleetRuntimeConfigurationServerProcess.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
