@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property estimatedInstanceWarmup Length of time, in seconds, it takes for a new instance to start
 * new game server processes and register with GameLift FleetIQ.
 * Specifying a warm-up time can be useful, particularly with game servers that take a long time to start up,
 * because it avoids prematurely starting new instances. Defaults to `60`.
 * @property targetTrackingConfiguration
 */
public data class GameServerGroupAutoScalingPolicy(
    public val estimatedInstanceWarmup: Int? = null,
    public val targetTrackingConfiguration:
    GameServerGroupAutoScalingPolicyTargetTrackingConfiguration,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.gamelift.outputs.GameServerGroupAutoScalingPolicy):
            GameServerGroupAutoScalingPolicy = GameServerGroupAutoScalingPolicy(
            estimatedInstanceWarmup = javaType.estimatedInstanceWarmup().map({ args0 -> args0 }).orElse(null),
            targetTrackingConfiguration = javaType.targetTrackingConfiguration().let({ args0 ->
                com.pulumi.aws.gamelift.kotlin.outputs.GameServerGroupAutoScalingPolicyTargetTrackingConfiguration.Companion.toKotlin(args0)
            }),
        )
    }
}
