@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property instanceType An EC2 instance type.
 * @property weightedCapacity Instance weighting that indicates how much this instance type contributes
 * to the total capacity of a game server group.
 * Instance weights are used by GameLift FleetIQ to calculate the instance type's cost per unit hour and better identify
 * the most cost-effective options.
 */
public data class GameServerGroupInstanceDefinition(
    public val instanceType: String,
    public val weightedCapacity: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.gamelift.outputs.GameServerGroupInstanceDefinition):
            GameServerGroupInstanceDefinition = GameServerGroupInstanceDefinition(
            instanceType = javaType.instanceType(),
            weightedCapacity = javaType.weightedCapacity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
