@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glacier.kotlin

import com.pulumi.aws.glacier.kotlin.outputs.VaultNotification
import com.pulumi.aws.glacier.kotlin.outputs.VaultNotification.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Vault].
 */
@PulumiTagMarker
public class VaultResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VaultArgs = VaultArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VaultArgsBuilder.() -> Unit) {
        val builder = VaultArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Vault {
        val builtJavaResource = com.pulumi.aws.glacier.Vault(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Vault(builtJavaResource)
    }
}

/**
 * Provides a Glacier Vault Resource. You can refer to the [Glacier Developer Guide](https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-vaults.html) for a full explanation of the Glacier Vault functionality
 * > **NOTE:** When removing a Glacier Vault, the Vault must be empty.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.glacier.Vault;
 * import com.pulumi.aws.glacier.VaultArgs;
 * import com.pulumi.aws.glacier.inputs.VaultNotificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awsSnsTopic = new Topic("awsSnsTopic");
 *         final var myArchivePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("add-read-only-perm")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("*")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions(
 *                     "glacier:InitiateJob",
 *                     "glacier:GetJobOutput")
 *                 .resources("arn:aws:glacier:eu-west-1:432981146916:vaults/MyArchive")
 *                 .build())
 *             .build());
 *         var myArchiveVault = new Vault("myArchiveVault", VaultArgs.builder()
 *             .notification(VaultNotificationArgs.builder()
 *                 .snsTopic(awsSnsTopic.arn())
 *                 .events(
 *                     "ArchiveRetrievalCompleted",
 *                     "InventoryRetrievalCompleted")
 *                 .build())
 *             .accessPolicy(myArchivePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .tags(Map.of("Test", "MyArchive"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glacier Vaults using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:glacier/vault:Vault archive my_archive
 * ```
 *
 */
public class Vault internal constructor(
    override val javaResource: com.pulumi.aws.glacier.Vault,
) : KotlinCustomResource(javaResource, VaultMapper) {
    /**
     * The policy document. This is a JSON formatted string.
     * The heredoc syntax or `file` function is helpful here. Use the [Glacier Developer Guide](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html) for more information on Glacier Vault Policy
     */
    public val accessPolicy: Output<String>?
        get() = javaResource.accessPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the vault.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The URI of the vault that was created.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the Vault. Names can be between 1 and 255 characters long and the valid characters are a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen), and '.' (period).
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The notifications for the Vault. Fields documented below.
     */
    public val notification: Output<VaultNotification>?
        get() = javaResource.notification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object VaultMapper : ResourceMapper<Vault> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glacier.Vault::class == javaResource::class

    override fun map(javaResource: Resource): Vault = Vault(
        javaResource as
            com.pulumi.aws.glacier.Vault,
    )
}

/**
 * @see [Vault].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Vault].
 */
public suspend fun vault(name: String, block: suspend VaultResourceBuilder.() -> Unit): Vault {
    val builder = VaultResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Vault].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vault(name: String): Vault {
    val builder = VaultResourceBuilder()
    builder.name(name)
    return builder.build()
}
