@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glacier.kotlin

import com.pulumi.aws.glacier.VaultArgs.builder
import com.pulumi.aws.glacier.kotlin.inputs.VaultNotificationArgs
import com.pulumi.aws.glacier.kotlin.inputs.VaultNotificationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Glacier Vault Resource. You can refer to the [Glacier Developer Guide](https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-vaults.html) for a full explanation of the Glacier Vault functionality
 * > **NOTE:** When removing a Glacier Vault, the Vault must be empty.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.glacier.Vault;
 * import com.pulumi.aws.glacier.VaultArgs;
 * import com.pulumi.aws.glacier.inputs.VaultNotificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awsSnsTopic = new Topic("awsSnsTopic");
 *         final var myArchivePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("add-read-only-perm")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("*")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions(
 *                     "glacier:InitiateJob",
 *                     "glacier:GetJobOutput")
 *                 .resources("arn:aws:glacier:eu-west-1:432981146916:vaults/MyArchive")
 *                 .build())
 *             .build());
 *         var myArchiveVault = new Vault("myArchiveVault", VaultArgs.builder()
 *             .notification(VaultNotificationArgs.builder()
 *                 .snsTopic(awsSnsTopic.arn())
 *                 .events(
 *                     "ArchiveRetrievalCompleted",
 *                     "InventoryRetrievalCompleted")
 *                 .build())
 *             .accessPolicy(myArchivePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .tags(Map.of("Test", "MyArchive"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glacier Vaults using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:glacier/vault:Vault archive my_archive
 * ```
 * @property accessPolicy The policy document. This is a JSON formatted string.
 * The heredoc syntax or `file` function is helpful here. Use the [Glacier Developer Guide](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html) for more information on Glacier Vault Policy
 * @property name The name of the Vault. Names can be between 1 and 255 characters long and the valid characters are a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen), and '.' (period).
 * @property notification The notifications for the Vault. Fields documented below.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class VaultArgs(
    public val accessPolicy: Output<String>? = null,
    public val name: Output<String>? = null,
    public val notification: Output<VaultNotificationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.glacier.VaultArgs> {
    override fun toJava(): com.pulumi.aws.glacier.VaultArgs =
        com.pulumi.aws.glacier.VaultArgs.builder()
            .accessPolicy(accessPolicy?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .notification(notification?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VaultArgs].
 */
@PulumiTagMarker
public class VaultArgsBuilder internal constructor() {
    private var accessPolicy: Output<String>? = null

    private var name: Output<String>? = null

    private var notification: Output<VaultNotificationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The policy document. This is a JSON formatted string.
     * The heredoc syntax or `file` function is helpful here. Use the [Glacier Developer Guide](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html) for more information on Glacier Vault Policy
     */
    @JvmName("mrnpoaotcarelect")
    public suspend fun accessPolicy(`value`: Output<String>) {
        this.accessPolicy = value
    }

    /**
     * @param value The name of the Vault. Names can be between 1 and 255 characters long and the valid characters are a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen), and '.' (period).
     */
    @JvmName("rdvftgwlnlrxblwi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The notifications for the Vault. Fields documented below.
     */
    @JvmName("xgepirlodekpkweb")
    public suspend fun notification(`value`: Output<VaultNotificationArgs>) {
        this.notification = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ijmovrrtqujvjoth")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The policy document. This is a JSON formatted string.
     * The heredoc syntax or `file` function is helpful here. Use the [Glacier Developer Guide](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html) for more information on Glacier Vault Policy
     */
    @JvmName("hfqwuveiqfwjgpji")
    public suspend fun accessPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPolicy = mapped
    }

    /**
     * @param value The name of the Vault. Names can be between 1 and 255 characters long and the valid characters are a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen), and '.' (period).
     */
    @JvmName("euacidgkauactlrs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The notifications for the Vault. Fields documented below.
     */
    @JvmName("ipjckvgfghlrnjle")
    public suspend fun notification(`value`: VaultNotificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notification = mapped
    }

    /**
     * @param argument The notifications for the Vault. Fields documented below.
     */
    @JvmName("lpdqcfaleueeuksw")
    public suspend fun notification(argument: suspend VaultNotificationArgsBuilder.() -> Unit) {
        val toBeMapped = VaultNotificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.notification = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rcixdhocscjwdvkw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yiuefwqrmjamrvwo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VaultArgs = VaultArgs(
        accessPolicy = accessPolicy,
        name = name,
        notification = notification,
        tags = tags,
    )
}
