@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glacier.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VaultLock].
 */
@PulumiTagMarker
public class VaultLockResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VaultLockArgs = VaultLockArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VaultLockArgsBuilder.() -> Unit) {
        val builder = VaultLockArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VaultLock {
        val builtJavaResource = com.pulumi.aws.glacier.VaultLock(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VaultLock(builtJavaResource)
    }
}

/**
 * Manages a Glacier Vault Lock. You can refer to the [Glacier Developer Guide](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html) for a full explanation of the Glacier Vault Lock functionality.
 * > **NOTE:** This resource allows you to test Glacier Vault Lock policies by setting the `complete_lock` argument to `false`. When testing policies in this manner, the Glacier Vault Lock automatically expires after 24 hours and this provider will show this resource as needing recreation after that time. To permanently apply the policy, set the `complete_lock` argument to `true`. When changing `complete_lock` to `true`, it is expected the resource will show as recreating.
 * !> **WARNING:** Once a Glacier Vault Lock is completed, it is immutable. The deletion of the Glacier Vault Lock is not be possible and attempting to remove it from this provider will return an error. Set the `ignore_deletion_error` argument to `true` and apply this configuration before attempting to delete this resource via this provider or remove this resource from this provider's management.
 * ## Example Usage
 * ### Testing Glacier Vault Lock Policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glacier.Vault;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.glacier.VaultLock;
 * import com.pulumi.aws.glacier.VaultLockArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleVault = new Vault("exampleVault");
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("glacier:DeleteArchive")
 *                 .effect("Deny")
 *                 .resources(exampleVault.arn())
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("NumericLessThanEquals")
 *                     .variable("glacier:ArchiveAgeinDays")
 *                     .values("365")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleVaultLock = new VaultLock("exampleVaultLock", VaultLockArgs.builder()
 *             .completeLock(false)
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(examplePolicyDocument -> examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .vaultName(exampleVault.name())
 *             .build());
 *     }
 * }
 * ```
 * ### Permanently Applying Glacier Vault Lock Policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glacier.VaultLock;
 * import com.pulumi.aws.glacier.VaultLockArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VaultLock("example", VaultLockArgs.builder()
 *             .completeLock(true)
 *             .policy(data.aws_iam_policy_document().example().json())
 *             .vaultName(aws_glacier_vault.example().name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glacier Vault Locks using the Glacier Vault name. For example:
 * ```sh
 *  $ pulumi import aws:glacier/vaultLock:VaultLock example example-vault
 * ```
 *
 */
public class VaultLock internal constructor(
    override val javaResource: com.pulumi.aws.glacier.VaultLock,
) : KotlinCustomResource(javaResource, VaultLockMapper) {
    /**
     * Boolean whether to permanently apply this Glacier Lock Policy. Once completed, this cannot be undone. If set to `false`, the Glacier Lock Policy remains in a testing mode for 24 hours. After that time, the Glacier Lock Policy is automatically removed by Glacier and the this provider resource will show as needing recreation. Changing this from `false` to `true` will show as resource recreation, which is expected. Changing this from `true` to `false` is not possible unless the Glacier Vault is recreated at the same time.
     */
    public val completeLock: Output<Boolean>
        get() = javaResource.completeLock().applyValue({ args0 -> args0 })

    /**
     * Allow this provider to ignore the error returned when attempting to delete the Glacier Lock Policy. This can be used to delete or recreate the Glacier Vault via this provider, for example, if the Glacier Vault Lock policy permits that action. This should only be used in conjunction with `complete_lock` being set to `true`.
     */
    public val ignoreDeletionError: Output<Boolean>?
        get() = javaResource.ignoreDeletionError().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * JSON string containing the IAM policy to apply as the Glacier Vault Lock policy.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The name of the Glacier Vault.
     */
    public val vaultName: Output<String>
        get() = javaResource.vaultName().applyValue({ args0 -> args0 })
}

public object VaultLockMapper : ResourceMapper<VaultLock> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glacier.VaultLock::class == javaResource::class

    override fun map(javaResource: Resource): VaultLock = VaultLock(
        javaResource as
            com.pulumi.aws.glacier.VaultLock,
    )
}

/**
 * @see [VaultLock].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VaultLock].
 */
public suspend fun vaultLock(name: String, block: suspend VaultLockResourceBuilder.() -> Unit):
    VaultLock {
    val builder = VaultLockResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VaultLock].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vaultLock(name: String): VaultLock {
    val builder = VaultLockResourceBuilder()
    builder.name(name)
    return builder.build()
}
