@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glacier.kotlin

import com.pulumi.aws.glacier.VaultLockArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Glacier Vault Lock. You can refer to the [Glacier Developer Guide](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html) for a full explanation of the Glacier Vault Lock functionality.
 * > **NOTE:** This resource allows you to test Glacier Vault Lock policies by setting the `complete_lock` argument to `false`. When testing policies in this manner, the Glacier Vault Lock automatically expires after 24 hours and this provider will show this resource as needing recreation after that time. To permanently apply the policy, set the `complete_lock` argument to `true`. When changing `complete_lock` to `true`, it is expected the resource will show as recreating.
 * !> **WARNING:** Once a Glacier Vault Lock is completed, it is immutable. The deletion of the Glacier Vault Lock is not be possible and attempting to remove it from this provider will return an error. Set the `ignore_deletion_error` argument to `true` and apply this configuration before attempting to delete this resource via this provider or remove this resource from this provider's management.
 * ## Example Usage
 * ### Testing Glacier Vault Lock Policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glacier.Vault;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.glacier.VaultLock;
 * import com.pulumi.aws.glacier.VaultLockArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleVault = new Vault("exampleVault");
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("glacier:DeleteArchive")
 *                 .effect("Deny")
 *                 .resources(exampleVault.arn())
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("NumericLessThanEquals")
 *                     .variable("glacier:ArchiveAgeinDays")
 *                     .values("365")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleVaultLock = new VaultLock("exampleVaultLock", VaultLockArgs.builder()
 *             .completeLock(false)
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(examplePolicyDocument -> examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .vaultName(exampleVault.name())
 *             .build());
 *     }
 * }
 * ```
 * ### Permanently Applying Glacier Vault Lock Policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glacier.VaultLock;
 * import com.pulumi.aws.glacier.VaultLockArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VaultLock("example", VaultLockArgs.builder()
 *             .completeLock(true)
 *             .policy(data.aws_iam_policy_document().example().json())
 *             .vaultName(aws_glacier_vault.example().name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glacier Vault Locks using the Glacier Vault name. For example:
 * ```sh
 *  $ pulumi import aws:glacier/vaultLock:VaultLock example example-vault
 * ```
 * @property completeLock Boolean whether to permanently apply this Glacier Lock Policy. Once completed, this cannot be undone. If set to `false`, the Glacier Lock Policy remains in a testing mode for 24 hours. After that time, the Glacier Lock Policy is automatically removed by Glacier and the this provider resource will show as needing recreation. Changing this from `false` to `true` will show as resource recreation, which is expected. Changing this from `true` to `false` is not possible unless the Glacier Vault is recreated at the same time.
 * @property ignoreDeletionError Allow this provider to ignore the error returned when attempting to delete the Glacier Lock Policy. This can be used to delete or recreate the Glacier Vault via this provider, for example, if the Glacier Vault Lock policy permits that action. This should only be used in conjunction with `complete_lock` being set to `true`.
 * @property policy JSON string containing the IAM policy to apply as the Glacier Vault Lock policy.
 * @property vaultName The name of the Glacier Vault.
 */
public data class VaultLockArgs(
    public val completeLock: Output<Boolean>? = null,
    public val ignoreDeletionError: Output<Boolean>? = null,
    public val policy: Output<String>? = null,
    public val vaultName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glacier.VaultLockArgs> {
    override fun toJava(): com.pulumi.aws.glacier.VaultLockArgs =
        com.pulumi.aws.glacier.VaultLockArgs.builder()
            .completeLock(completeLock?.applyValue({ args0 -> args0 }))
            .ignoreDeletionError(ignoreDeletionError?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VaultLockArgs].
 */
@PulumiTagMarker
public class VaultLockArgsBuilder internal constructor() {
    private var completeLock: Output<Boolean>? = null

    private var ignoreDeletionError: Output<Boolean>? = null

    private var policy: Output<String>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value Boolean whether to permanently apply this Glacier Lock Policy. Once completed, this cannot be undone. If set to `false`, the Glacier Lock Policy remains in a testing mode for 24 hours. After that time, the Glacier Lock Policy is automatically removed by Glacier and the this provider resource will show as needing recreation. Changing this from `false` to `true` will show as resource recreation, which is expected. Changing this from `true` to `false` is not possible unless the Glacier Vault is recreated at the same time.
     */
    @JvmName("ugkxgalkikmscyul")
    public suspend fun completeLock(`value`: Output<Boolean>) {
        this.completeLock = value
    }

    /**
     * @param value Allow this provider to ignore the error returned when attempting to delete the Glacier Lock Policy. This can be used to delete or recreate the Glacier Vault via this provider, for example, if the Glacier Vault Lock policy permits that action. This should only be used in conjunction with `complete_lock` being set to `true`.
     */
    @JvmName("ouamaeudsqxwkqxa")
    public suspend fun ignoreDeletionError(`value`: Output<Boolean>) {
        this.ignoreDeletionError = value
    }

    /**
     * @param value JSON string containing the IAM policy to apply as the Glacier Vault Lock policy.
     */
    @JvmName("brchbldljlnihejl")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The name of the Glacier Vault.
     */
    @JvmName("ssnqpusgpkdepagu")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value Boolean whether to permanently apply this Glacier Lock Policy. Once completed, this cannot be undone. If set to `false`, the Glacier Lock Policy remains in a testing mode for 24 hours. After that time, the Glacier Lock Policy is automatically removed by Glacier and the this provider resource will show as needing recreation. Changing this from `false` to `true` will show as resource recreation, which is expected. Changing this from `true` to `false` is not possible unless the Glacier Vault is recreated at the same time.
     */
    @JvmName("wncqqpqjinvrjdxm")
    public suspend fun completeLock(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.completeLock = mapped
    }

    /**
     * @param value Allow this provider to ignore the error returned when attempting to delete the Glacier Lock Policy. This can be used to delete or recreate the Glacier Vault via this provider, for example, if the Glacier Vault Lock policy permits that action. This should only be used in conjunction with `complete_lock` being set to `true`.
     */
    @JvmName("mxuavxwhxcmblrjv")
    public suspend fun ignoreDeletionError(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreDeletionError = mapped
    }

    /**
     * @param value JSON string containing the IAM policy to apply as the Glacier Vault Lock policy.
     */
    @JvmName("wxhygbxsgauhgviw")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The name of the Glacier Vault.
     */
    @JvmName("btqsjucvsagbfobg")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): VaultLockArgs = VaultLockArgs(
        completeLock = completeLock,
        ignoreDeletionError = ignoreDeletionError,
        policy = policy,
        vaultName = vaultName,
    )
}
