@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glacier.kotlin.inputs

import com.pulumi.aws.glacier.inputs.VaultNotificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property events You can configure a vault to publish a notification for `ArchiveRetrievalCompleted` and `InventoryRetrievalCompleted` events.
 * @property snsTopic The SNS Topic ARN.
 */
public data class VaultNotificationArgs(
    public val events: Output<List<String>>,
    public val snsTopic: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.glacier.inputs.VaultNotificationArgs> {
    override fun toJava(): com.pulumi.aws.glacier.inputs.VaultNotificationArgs =
        com.pulumi.aws.glacier.inputs.VaultNotificationArgs.builder()
            .events(events.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .snsTopic(snsTopic.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VaultNotificationArgs].
 */
@PulumiTagMarker
public class VaultNotificationArgsBuilder internal constructor() {
    private var events: Output<List<String>>? = null

    private var snsTopic: Output<String>? = null

    /**
     * @param value You can configure a vault to publish a notification for `ArchiveRetrievalCompleted` and `InventoryRetrievalCompleted` events.
     */
    @JvmName("ppkiebpnlcbjkmra")
    public suspend fun events(`value`: Output<List<String>>) {
        this.events = value
    }

    @JvmName("doyetwkptpvlthlh")
    public suspend fun events(vararg values: Output<String>) {
        this.events = Output.all(values.asList())
    }

    /**
     * @param values You can configure a vault to publish a notification for `ArchiveRetrievalCompleted` and `InventoryRetrievalCompleted` events.
     */
    @JvmName("rcbenwvvsnpcotpm")
    public suspend fun events(values: List<Output<String>>) {
        this.events = Output.all(values)
    }

    /**
     * @param value The SNS Topic ARN.
     */
    @JvmName("paxlsqpnwvwkxvbi")
    public suspend fun snsTopic(`value`: Output<String>) {
        this.snsTopic = value
    }

    /**
     * @param value You can configure a vault to publish a notification for `ArchiveRetrievalCompleted` and `InventoryRetrievalCompleted` events.
     */
    @JvmName("spqvqmudyjmhmmqo")
    public suspend fun events(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param values You can configure a vault to publish a notification for `ArchiveRetrievalCompleted` and `InventoryRetrievalCompleted` events.
     */
    @JvmName("xlnnlhnferjqmtvo")
    public suspend fun events(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param value The SNS Topic ARN.
     */
    @JvmName("uixpwhfthkwfsirg")
    public suspend fun snsTopic(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snsTopic = mapped
    }

    internal fun build(): VaultNotificationArgs = VaultNotificationArgs(
        events = events ?: throw PulumiNullFieldException("events"),
        snsTopic = snsTopic ?: throw PulumiNullFieldException("snsTopic"),
    )
}
