@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glacier.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property events You can configure a vault to publish a notification for `ArchiveRetrievalCompleted` and `InventoryRetrievalCompleted` events.
 * @property snsTopic The SNS Topic ARN.
 */
public data class VaultNotification(
    public val events: List<String>,
    public val snsTopic: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.glacier.outputs.VaultNotification):
            VaultNotification = VaultNotification(
            events = javaType.events().map({ args0 -> args0 }),
            snsTopic = javaType.snsTopic(),
        )
    }
}
