@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin

import com.pulumi.aws.globalaccelerator.kotlin.outputs.AcceleratorAttributes
import com.pulumi.aws.globalaccelerator.kotlin.outputs.AcceleratorIpSet
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.globalaccelerator.kotlin.outputs.AcceleratorAttributes.Companion.toKotlin as acceleratorAttributesToKotlin
import com.pulumi.aws.globalaccelerator.kotlin.outputs.AcceleratorIpSet.Companion.toKotlin as acceleratorIpSetToKotlin

/**
 * Builder for [Accelerator].
 */
@PulumiTagMarker
public class AcceleratorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AcceleratorArgs = AcceleratorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AcceleratorArgsBuilder.() -> Unit) {
        val builder = AcceleratorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Accelerator {
        val builtJavaResource = com.pulumi.aws.globalaccelerator.Accelerator(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Accelerator(builtJavaResource)
    }
}

/**
 * Creates a Global Accelerator accelerator.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.globalaccelerator.Accelerator;
 * import com.pulumi.aws.globalaccelerator.AcceleratorArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.AcceleratorAttributesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Accelerator("example", AcceleratorArgs.builder()
 *             .attributes(AcceleratorAttributesArgs.builder()
 *                 .flowLogsEnabled(true)
 *                 .flowLogsS3Bucket("example-bucket")
 *                 .flowLogsS3Prefix("flow-logs/")
 *                 .build())
 *             .enabled(true)
 *             .ipAddressType("IPV4")
 *             .ipAddresses("1.2.3.4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Global Accelerator accelerators using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:globalaccelerator/accelerator:Accelerator example arn:aws:globalaccelerator::111111111111:accelerator/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
 * ```
 *
 */
public class Accelerator internal constructor(
    override val javaResource: com.pulumi.aws.globalaccelerator.Accelerator,
) : KotlinCustomResource(javaResource, AcceleratorMapper) {
    /**
     * The attributes of the accelerator. Fields documented below.
     */
    public val attributes: Output<AcceleratorAttributes>?
        get() = javaResource.attributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    acceleratorAttributesToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The DNS name of the accelerator. For example, `a5d53ff5ee6bca4ce.awsglobalaccelerator.com`.
     */
    public val dnsName: Output<String>
        get() = javaResource.dnsName().applyValue({ args0 -> args0 })

    /**
     * The Domain Name System (DNS) name that Global Accelerator creates that points to a dual-stack accelerator's four static IP addresses: two IPv4 addresses and two IPv6 addresses. For example, `a1234567890abcdef.dualstack.awsglobalaccelerator.com`.
     */
    public val dualStackDnsName: Output<String>
        get() = javaResource.dualStackDnsName().applyValue({ args0 -> args0 })

    /**
     * Indicates whether the accelerator is enabled. Defaults to `true`. Valid values: `true`, `false`.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * -  The Global Accelerator Route 53 zone ID that can be used to
     * route an [Alias Resource Record Set](https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html) to the Global Accelerator. This attribute
     * is simply an alias for the zone ID `Z2BJ6XQ5FK7U4H`.
     */
    public val hostedZoneId: Output<String>
        get() = javaResource.hostedZoneId().applyValue({ args0 -> args0 })

    /**
     * The value for the address type. Defaults to `IPV4`. Valid values: `IPV4`, `DUAL_STACK`.
     */
    public val ipAddressType: Output<String>?
        get() = javaResource.ipAddressType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IP addresses to use for BYOIP accelerators. If not specified, the service assigns IP addresses. Valid values: 1 or 2 IPv4 addresses.
     */
    public val ipAddresses: Output<List<String>>?
        get() = javaResource.ipAddresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * IP address set associated with the accelerator.
     */
    public val ipSets: Output<List<AcceleratorIpSet>>
        get() = javaResource.ipSets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    acceleratorIpSetToKotlin(args0)
                })
            })
        })

    /**
     * The name of the accelerator.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object AcceleratorMapper : ResourceMapper<Accelerator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.globalaccelerator.Accelerator::class == javaResource::class

    override fun map(javaResource: Resource): Accelerator = Accelerator(
        javaResource as
            com.pulumi.aws.globalaccelerator.Accelerator,
    )
}

/**
 * @see [Accelerator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Accelerator].
 */
public suspend fun accelerator(name: String, block: suspend AcceleratorResourceBuilder.() -> Unit):
    Accelerator {
    val builder = AcceleratorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Accelerator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accelerator(name: String): Accelerator {
    val builder = AcceleratorResourceBuilder()
    builder.name(name)
    return builder.build()
}
