@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin

import com.pulumi.aws.globalaccelerator.kotlin.outputs.CustomRoutingAcceleratorAttributes
import com.pulumi.aws.globalaccelerator.kotlin.outputs.CustomRoutingAcceleratorIpSet
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.globalaccelerator.kotlin.outputs.CustomRoutingAcceleratorAttributes.Companion.toKotlin as customRoutingAcceleratorAttributesToKotlin
import com.pulumi.aws.globalaccelerator.kotlin.outputs.CustomRoutingAcceleratorIpSet.Companion.toKotlin as customRoutingAcceleratorIpSetToKotlin

/**
 * Builder for [CustomRoutingAccelerator].
 */
@PulumiTagMarker
public class CustomRoutingAcceleratorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomRoutingAcceleratorArgs = CustomRoutingAcceleratorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomRoutingAcceleratorArgsBuilder.() -> Unit) {
        val builder = CustomRoutingAcceleratorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CustomRoutingAccelerator {
        val builtJavaResource =
            com.pulumi.aws.globalaccelerator.CustomRoutingAccelerator(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CustomRoutingAccelerator(builtJavaResource)
    }
}

/**
 * Creates a Global Accelerator custom routing accelerator.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingAccelerator;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingAcceleratorArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.CustomRoutingAcceleratorAttributesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CustomRoutingAccelerator("example", CustomRoutingAcceleratorArgs.builder()
 *             .attributes(CustomRoutingAcceleratorAttributesArgs.builder()
 *                 .flowLogsEnabled(true)
 *                 .flowLogsS3Bucket("example-bucket")
 *                 .flowLogsS3Prefix("flow-logs/")
 *                 .build())
 *             .enabled(true)
 *             .ipAddressType("IPV4")
 *             .ipAddresses("1.2.3.4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Global Accelerator custom routing accelerators using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:globalaccelerator/customRoutingAccelerator:CustomRoutingAccelerator example arn:aws:globalaccelerator::111111111111:accelerator/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
 * ```
 *
 */
public class CustomRoutingAccelerator internal constructor(
    override val javaResource: com.pulumi.aws.globalaccelerator.CustomRoutingAccelerator,
) : KotlinCustomResource(javaResource, CustomRoutingAcceleratorMapper) {
    /**
     * The attributes of the accelerator. Fields documented below.
     */
    public val attributes: Output<CustomRoutingAcceleratorAttributes>?
        get() = javaResource.attributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    customRoutingAcceleratorAttributesToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The DNS name of the accelerator. For example, `a5d53ff5ee6bca4ce.awsglobalaccelerator.com`.
     */
    public val dnsName: Output<String>
        get() = javaResource.dnsName().applyValue({ args0 -> args0 })

    /**
     * Indicates whether the accelerator is enabled. Defaults to `true`. Valid values: `true`, `false`.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * -  The Global Accelerator Route 53 zone ID that can be used to
     * route an [Alias Resource Record Set](https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html) to the Global Accelerator. This attribute
     * is simply an alias for the zone ID `Z2BJ6XQ5FK7U4H`.
     */
    public val hostedZoneId: Output<String>
        get() = javaResource.hostedZoneId().applyValue({ args0 -> args0 })

    /**
     * The IP address type that an accelerator supports. For a custom routing accelerator, the value must be `"IPV4"`.
     */
    public val ipAddressType: Output<String>?
        get() = javaResource.ipAddressType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IP addresses to use for BYOIP accelerators. If not specified, the service assigns IP addresses. Valid values: 1 or 2 IPv4 addresses.
     */
    public val ipAddresses: Output<List<String>>?
        get() = javaResource.ipAddresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * IP address set associated with the accelerator.
     */
    public val ipSets: Output<List<CustomRoutingAcceleratorIpSet>>
        get() = javaResource.ipSets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    customRoutingAcceleratorIpSetToKotlin(args0)
                })
            })
        })

    /**
     * The name of a custom routing accelerator.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object CustomRoutingAcceleratorMapper : ResourceMapper<CustomRoutingAccelerator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.globalaccelerator.CustomRoutingAccelerator::class == javaResource::class

    override fun map(javaResource: Resource): CustomRoutingAccelerator =
        CustomRoutingAccelerator(
            javaResource as
                com.pulumi.aws.globalaccelerator.CustomRoutingAccelerator,
        )
}

/**
 * @see [CustomRoutingAccelerator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomRoutingAccelerator].
 */
public suspend fun customRoutingAccelerator(
    name: String,
    block: suspend CustomRoutingAcceleratorResourceBuilder.() -> Unit,
): CustomRoutingAccelerator {
    val builder = CustomRoutingAcceleratorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomRoutingAccelerator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customRoutingAccelerator(name: String): CustomRoutingAccelerator {
    val builder = CustomRoutingAcceleratorResourceBuilder()
    builder.name(name)
    return builder.build()
}
