@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin

import com.pulumi.aws.globalaccelerator.CustomRoutingAcceleratorArgs.builder
import com.pulumi.aws.globalaccelerator.kotlin.inputs.CustomRoutingAcceleratorAttributesArgs
import com.pulumi.aws.globalaccelerator.kotlin.inputs.CustomRoutingAcceleratorAttributesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a Global Accelerator custom routing accelerator.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingAccelerator;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingAcceleratorArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.CustomRoutingAcceleratorAttributesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CustomRoutingAccelerator("example", CustomRoutingAcceleratorArgs.builder()
 *             .attributes(CustomRoutingAcceleratorAttributesArgs.builder()
 *                 .flowLogsEnabled(true)
 *                 .flowLogsS3Bucket("example-bucket")
 *                 .flowLogsS3Prefix("flow-logs/")
 *                 .build())
 *             .enabled(true)
 *             .ipAddressType("IPV4")
 *             .ipAddresses("1.2.3.4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Global Accelerator custom routing accelerators using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:globalaccelerator/customRoutingAccelerator:CustomRoutingAccelerator example arn:aws:globalaccelerator::111111111111:accelerator/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
 * ```
 * @property attributes The attributes of the accelerator. Fields documented below.
 * @property enabled Indicates whether the accelerator is enabled. Defaults to `true`. Valid values: `true`, `false`.
 * @property ipAddressType The IP address type that an accelerator supports. For a custom routing accelerator, the value must be `"IPV4"`.
 * @property ipAddresses The IP addresses to use for BYOIP accelerators. If not specified, the service assigns IP addresses. Valid values: 1 or 2 IPv4 addresses.
 * @property name The name of a custom routing accelerator.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CustomRoutingAcceleratorArgs(
    public val attributes: Output<CustomRoutingAcceleratorAttributesArgs>? = null,
    public val enabled: Output<Boolean>? = null,
    public val ipAddressType: Output<String>? = null,
    public val ipAddresses: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.globalaccelerator.CustomRoutingAcceleratorArgs> {
    override fun toJava(): com.pulumi.aws.globalaccelerator.CustomRoutingAcceleratorArgs =
        com.pulumi.aws.globalaccelerator.CustomRoutingAcceleratorArgs.builder()
            .attributes(attributes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .ipAddressType(ipAddressType?.applyValue({ args0 -> args0 }))
            .ipAddresses(ipAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CustomRoutingAcceleratorArgs].
 */
@PulumiTagMarker
public class CustomRoutingAcceleratorArgsBuilder internal constructor() {
    private var attributes: Output<CustomRoutingAcceleratorAttributesArgs>? = null

    private var enabled: Output<Boolean>? = null

    private var ipAddressType: Output<String>? = null

    private var ipAddresses: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The attributes of the accelerator. Fields documented below.
     */
    @JvmName("qflaeodnxilqorxl")
    public suspend fun attributes(`value`: Output<CustomRoutingAcceleratorAttributesArgs>) {
        this.attributes = value
    }

    /**
     * @param value Indicates whether the accelerator is enabled. Defaults to `true`. Valid values: `true`, `false`.
     */
    @JvmName("lnupqfhdnmuuokow")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The IP address type that an accelerator supports. For a custom routing accelerator, the value must be `"IPV4"`.
     */
    @JvmName("snkqxxbhuyknjpog")
    public suspend fun ipAddressType(`value`: Output<String>) {
        this.ipAddressType = value
    }

    /**
     * @param value The IP addresses to use for BYOIP accelerators. If not specified, the service assigns IP addresses. Valid values: 1 or 2 IPv4 addresses.
     */
    @JvmName("jmwwlcwplkokuupr")
    public suspend fun ipAddresses(`value`: Output<List<String>>) {
        this.ipAddresses = value
    }

    @JvmName("inppeuvhlbhtmsdi")
    public suspend fun ipAddresses(vararg values: Output<String>) {
        this.ipAddresses = Output.all(values.asList())
    }

    /**
     * @param values The IP addresses to use for BYOIP accelerators. If not specified, the service assigns IP addresses. Valid values: 1 or 2 IPv4 addresses.
     */
    @JvmName("kgjeieaeudeslype")
    public suspend fun ipAddresses(values: List<Output<String>>) {
        this.ipAddresses = Output.all(values)
    }

    /**
     * @param value The name of a custom routing accelerator.
     */
    @JvmName("ykuiackerscddmmf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dbxkwmlsvnseunpe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The attributes of the accelerator. Fields documented below.
     */
    @JvmName("mivlpyhxogaqhnvl")
    public suspend fun attributes(`value`: CustomRoutingAcceleratorAttributesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param argument The attributes of the accelerator. Fields documented below.
     */
    @JvmName("lyfqqsgrdkkkdasg")
    public suspend
    fun attributes(argument: suspend CustomRoutingAcceleratorAttributesArgsBuilder.() -> Unit) {
        val toBeMapped = CustomRoutingAcceleratorAttributesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param value Indicates whether the accelerator is enabled. Defaults to `true`. Valid values: `true`, `false`.
     */
    @JvmName("xcysouurlrppbfuq")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The IP address type that an accelerator supports. For a custom routing accelerator, the value must be `"IPV4"`.
     */
    @JvmName("yxdowdsphudtafao")
    public suspend fun ipAddressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value The IP addresses to use for BYOIP accelerators. If not specified, the service assigns IP addresses. Valid values: 1 or 2 IPv4 addresses.
     */
    @JvmName("popmaaayctjyrjmt")
    public suspend fun ipAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    /**
     * @param values The IP addresses to use for BYOIP accelerators. If not specified, the service assigns IP addresses. Valid values: 1 or 2 IPv4 addresses.
     */
    @JvmName("iwedebnjdimubdte")
    public suspend fun ipAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    /**
     * @param value The name of a custom routing accelerator.
     */
    @JvmName("dxyaussxmgkasbbn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rbhtokxwnljbdmbc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hkhusugoobbntwds")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CustomRoutingAcceleratorArgs = CustomRoutingAcceleratorArgs(
        attributes = attributes,
        enabled = enabled,
        ipAddressType = ipAddressType,
        ipAddresses = ipAddresses,
        name = name,
        tags = tags,
    )
}
