@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin

import com.pulumi.aws.globalaccelerator.kotlin.outputs.CustomRoutingEndpointGroupDestinationConfiguration
import com.pulumi.aws.globalaccelerator.kotlin.outputs.CustomRoutingEndpointGroupEndpointConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.globalaccelerator.kotlin.outputs.CustomRoutingEndpointGroupDestinationConfiguration.Companion.toKotlin as customRoutingEndpointGroupDestinationConfigurationToKotlin
import com.pulumi.aws.globalaccelerator.kotlin.outputs.CustomRoutingEndpointGroupEndpointConfiguration.Companion.toKotlin as customRoutingEndpointGroupEndpointConfigurationToKotlin

/**
 * Builder for [CustomRoutingEndpointGroup].
 */
@PulumiTagMarker
public class CustomRoutingEndpointGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomRoutingEndpointGroupArgs = CustomRoutingEndpointGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomRoutingEndpointGroupArgsBuilder.() -> Unit) {
        val builder = CustomRoutingEndpointGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CustomRoutingEndpointGroup {
        val builtJavaResource =
            com.pulumi.aws.globalaccelerator.CustomRoutingEndpointGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CustomRoutingEndpointGroup(builtJavaResource)
    }
}

/**
 * Provides a Global Accelerator custom routing endpoint group.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingEndpointGroup;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingEndpointGroupArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.CustomRoutingEndpointGroupDestinationConfigurationArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.CustomRoutingEndpointGroupEndpointConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CustomRoutingEndpointGroup("example", CustomRoutingEndpointGroupArgs.builder()
 *             .listenerArn(aws_globalaccelerator_custom_routing_listener.example().id())
 *             .destinationConfigurations(CustomRoutingEndpointGroupDestinationConfigurationArgs.builder()
 *                 .fromPort(80)
 *                 .toPort(8080)
 *                 .protocols("TCP")
 *                 .build())
 *             .endpointConfigurations(CustomRoutingEndpointGroupEndpointConfigurationArgs.builder()
 *                 .endpointId(aws_subnet.example().id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Global Accelerator custom routing endpoint groups using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:globalaccelerator/customRoutingEndpointGroup:CustomRoutingEndpointGroup example arn:aws:globalaccelerator::111111111111:accelerator/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/listener/xxxxxxx/endpoint-group/xxxxxxxx
 * ```
 *
 */
public class CustomRoutingEndpointGroup internal constructor(
    override val javaResource: com.pulumi.aws.globalaccelerator.CustomRoutingEndpointGroup,
) : KotlinCustomResource(javaResource, CustomRoutingEndpointGroupMapper) {
    /**
     * The Amazon Resource Name (ARN) of the custom routing endpoint group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The port ranges and protocols for all endpoints in a custom routing endpoint group to accept client traffic on. Fields documented below.
     */
    public val destinationConfigurations:
        Output<List<CustomRoutingEndpointGroupDestinationConfiguration>>
        get() = javaResource.destinationConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> customRoutingEndpointGroupDestinationConfigurationToKotlin(args0) })
            })
        })

    /**
     * The list of endpoint objects. Fields documented below.
     */
    public val endpointConfigurations: Output<List<CustomRoutingEndpointGroupEndpointConfiguration>>?
        get() = javaResource.endpointConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        customRoutingEndpointGroupEndpointConfigurationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The name of the AWS Region where the custom routing endpoint group is located.
     */
    public val endpointGroupRegion: Output<String>
        get() = javaResource.endpointGroupRegion().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the custom routing listener.
     */
    public val listenerArn: Output<String>
        get() = javaResource.listenerArn().applyValue({ args0 -> args0 })
}

public object CustomRoutingEndpointGroupMapper : ResourceMapper<CustomRoutingEndpointGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.globalaccelerator.CustomRoutingEndpointGroup::class == javaResource::class

    override fun map(javaResource: Resource): CustomRoutingEndpointGroup =
        CustomRoutingEndpointGroup(
            javaResource as
                com.pulumi.aws.globalaccelerator.CustomRoutingEndpointGroup,
        )
}

/**
 * @see [CustomRoutingEndpointGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomRoutingEndpointGroup].
 */
public suspend fun customRoutingEndpointGroup(
    name: String,
    block: suspend CustomRoutingEndpointGroupResourceBuilder.() -> Unit,
):
    CustomRoutingEndpointGroup {
    val builder = CustomRoutingEndpointGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomRoutingEndpointGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customRoutingEndpointGroup(name: String): CustomRoutingEndpointGroup {
    val builder = CustomRoutingEndpointGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
