@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin

import com.pulumi.aws.globalaccelerator.CustomRoutingEndpointGroupArgs.builder
import com.pulumi.aws.globalaccelerator.kotlin.inputs.CustomRoutingEndpointGroupDestinationConfigurationArgs
import com.pulumi.aws.globalaccelerator.kotlin.inputs.CustomRoutingEndpointGroupDestinationConfigurationArgsBuilder
import com.pulumi.aws.globalaccelerator.kotlin.inputs.CustomRoutingEndpointGroupEndpointConfigurationArgs
import com.pulumi.aws.globalaccelerator.kotlin.inputs.CustomRoutingEndpointGroupEndpointConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Global Accelerator custom routing endpoint group.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingEndpointGroup;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingEndpointGroupArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.CustomRoutingEndpointGroupDestinationConfigurationArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.CustomRoutingEndpointGroupEndpointConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CustomRoutingEndpointGroup("example", CustomRoutingEndpointGroupArgs.builder()
 *             .listenerArn(aws_globalaccelerator_custom_routing_listener.example().id())
 *             .destinationConfigurations(CustomRoutingEndpointGroupDestinationConfigurationArgs.builder()
 *                 .fromPort(80)
 *                 .toPort(8080)
 *                 .protocols("TCP")
 *                 .build())
 *             .endpointConfigurations(CustomRoutingEndpointGroupEndpointConfigurationArgs.builder()
 *                 .endpointId(aws_subnet.example().id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Global Accelerator custom routing endpoint groups using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:globalaccelerator/customRoutingEndpointGroup:CustomRoutingEndpointGroup example arn:aws:globalaccelerator::111111111111:accelerator/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/listener/xxxxxxx/endpoint-group/xxxxxxxx
 * ```
 * @property destinationConfigurations The port ranges and protocols for all endpoints in a custom routing endpoint group to accept client traffic on. Fields documented below.
 * @property endpointConfigurations The list of endpoint objects. Fields documented below.
 * @property endpointGroupRegion The name of the AWS Region where the custom routing endpoint group is located.
 * @property listenerArn The Amazon Resource Name (ARN) of the custom routing listener.
 */
public data class CustomRoutingEndpointGroupArgs(
    public val destinationConfigurations:
    Output<List<CustomRoutingEndpointGroupDestinationConfigurationArgs>>? = null,
    public val endpointConfigurations:
    Output<List<CustomRoutingEndpointGroupEndpointConfigurationArgs>>? = null,
    public val endpointGroupRegion: Output<String>? = null,
    public val listenerArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.globalaccelerator.CustomRoutingEndpointGroupArgs> {
    override fun toJava(): com.pulumi.aws.globalaccelerator.CustomRoutingEndpointGroupArgs =
        com.pulumi.aws.globalaccelerator.CustomRoutingEndpointGroupArgs.builder()
            .destinationConfigurations(
                destinationConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .endpointConfigurations(
                endpointConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .endpointGroupRegion(endpointGroupRegion?.applyValue({ args0 -> args0 }))
            .listenerArn(listenerArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomRoutingEndpointGroupArgs].
 */
@PulumiTagMarker
public class CustomRoutingEndpointGroupArgsBuilder internal constructor() {
    private var destinationConfigurations:
        Output<List<CustomRoutingEndpointGroupDestinationConfigurationArgs>>? = null

    private var endpointConfigurations:
        Output<List<CustomRoutingEndpointGroupEndpointConfigurationArgs>>? = null

    private var endpointGroupRegion: Output<String>? = null

    private var listenerArn: Output<String>? = null

    /**
     * @param value The port ranges and protocols for all endpoints in a custom routing endpoint group to accept client traffic on. Fields documented below.
     */
    @JvmName("tftbuilavpslvnua")
    public suspend
    fun destinationConfigurations(`value`: Output<List<CustomRoutingEndpointGroupDestinationConfigurationArgs>>) {
        this.destinationConfigurations = value
    }

    @JvmName("cmbdxbbmejlvnnis")
    public suspend fun destinationConfigurations(
        vararg
        values: Output<CustomRoutingEndpointGroupDestinationConfigurationArgs>,
    ) {
        this.destinationConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The port ranges and protocols for all endpoints in a custom routing endpoint group to accept client traffic on. Fields documented below.
     */
    @JvmName("cewfcqrrdkabendl")
    public suspend
    fun destinationConfigurations(values: List<Output<CustomRoutingEndpointGroupDestinationConfigurationArgs>>) {
        this.destinationConfigurations = Output.all(values)
    }

    /**
     * @param value The list of endpoint objects. Fields documented below.
     */
    @JvmName("yuuawcansdbbkotj")
    public suspend
    fun endpointConfigurations(`value`: Output<List<CustomRoutingEndpointGroupEndpointConfigurationArgs>>) {
        this.endpointConfigurations = value
    }

    @JvmName("qosytxlulofrsoav")
    public suspend fun endpointConfigurations(
        vararg
        values: Output<CustomRoutingEndpointGroupEndpointConfigurationArgs>,
    ) {
        this.endpointConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The list of endpoint objects. Fields documented below.
     */
    @JvmName("fvliijgegoxxihrx")
    public suspend
    fun endpointConfigurations(values: List<Output<CustomRoutingEndpointGroupEndpointConfigurationArgs>>) {
        this.endpointConfigurations = Output.all(values)
    }

    /**
     * @param value The name of the AWS Region where the custom routing endpoint group is located.
     */
    @JvmName("nllxalxpeehaghdj")
    public suspend fun endpointGroupRegion(`value`: Output<String>) {
        this.endpointGroupRegion = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the custom routing listener.
     */
    @JvmName("rqwqwbttoumjugas")
    public suspend fun listenerArn(`value`: Output<String>) {
        this.listenerArn = value
    }

    /**
     * @param value The port ranges and protocols for all endpoints in a custom routing endpoint group to accept client traffic on. Fields documented below.
     */
    @JvmName("ubqvmcmjsmgsujeh")
    public suspend
    fun destinationConfigurations(`value`: List<CustomRoutingEndpointGroupDestinationConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationConfigurations = mapped
    }

    /**
     * @param argument The port ranges and protocols for all endpoints in a custom routing endpoint group to accept client traffic on. Fields documented below.
     */
    @JvmName("vauuohonisxspbvq")
    public suspend
    fun destinationConfigurations(argument: List<suspend CustomRoutingEndpointGroupDestinationConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomRoutingEndpointGroupDestinationConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationConfigurations = mapped
    }

    /**
     * @param argument The port ranges and protocols for all endpoints in a custom routing endpoint group to accept client traffic on. Fields documented below.
     */
    @JvmName("dthmyvyeyftudsat")
    public suspend fun destinationConfigurations(
        vararg
        argument: suspend CustomRoutingEndpointGroupDestinationConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CustomRoutingEndpointGroupDestinationConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationConfigurations = mapped
    }

    /**
     * @param argument The port ranges and protocols for all endpoints in a custom routing endpoint group to accept client traffic on. Fields documented below.
     */
    @JvmName("vsdubyxaoolqedur")
    public suspend
    fun destinationConfigurations(argument: suspend CustomRoutingEndpointGroupDestinationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                CustomRoutingEndpointGroupDestinationConfigurationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.destinationConfigurations = mapped
    }

    /**
     * @param values The port ranges and protocols for all endpoints in a custom routing endpoint group to accept client traffic on. Fields documented below.
     */
    @JvmName("infhqjhttoapgunr")
    public suspend fun destinationConfigurations(
        vararg
        values: CustomRoutingEndpointGroupDestinationConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationConfigurations = mapped
    }

    /**
     * @param value The list of endpoint objects. Fields documented below.
     */
    @JvmName("quyyyggpfohwejxf")
    public suspend
    fun endpointConfigurations(`value`: List<CustomRoutingEndpointGroupEndpointConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointConfigurations = mapped
    }

    /**
     * @param argument The list of endpoint objects. Fields documented below.
     */
    @JvmName("wyjwbqlioruwyppi")
    public suspend
    fun endpointConfigurations(argument: List<suspend CustomRoutingEndpointGroupEndpointConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomRoutingEndpointGroupEndpointConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.endpointConfigurations = mapped
    }

    /**
     * @param argument The list of endpoint objects. Fields documented below.
     */
    @JvmName("ihjrrdrfwngaodxu")
    public suspend fun endpointConfigurations(
        vararg
        argument: suspend CustomRoutingEndpointGroupEndpointConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CustomRoutingEndpointGroupEndpointConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.endpointConfigurations = mapped
    }

    /**
     * @param argument The list of endpoint objects. Fields documented below.
     */
    @JvmName("ydhlqsdmoewscanw")
    public suspend
    fun endpointConfigurations(argument: suspend CustomRoutingEndpointGroupEndpointConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                CustomRoutingEndpointGroupEndpointConfigurationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.endpointConfigurations = mapped
    }

    /**
     * @param values The list of endpoint objects. Fields documented below.
     */
    @JvmName("ycoskdhfjdayuppk")
    public suspend fun endpointConfigurations(
        vararg
        values: CustomRoutingEndpointGroupEndpointConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointConfigurations = mapped
    }

    /**
     * @param value The name of the AWS Region where the custom routing endpoint group is located.
     */
    @JvmName("mclgtrbemvkovqhw")
    public suspend fun endpointGroupRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointGroupRegion = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the custom routing listener.
     */
    @JvmName("vvbkvllohfpsjhvm")
    public suspend fun listenerArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerArn = mapped
    }

    internal fun build(): CustomRoutingEndpointGroupArgs = CustomRoutingEndpointGroupArgs(
        destinationConfigurations = destinationConfigurations,
        endpointConfigurations = endpointConfigurations,
        endpointGroupRegion = endpointGroupRegion,
        listenerArn = listenerArn,
    )
}
