@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin

import com.pulumi.aws.globalaccelerator.CustomRoutingListenerArgs.builder
import com.pulumi.aws.globalaccelerator.kotlin.inputs.CustomRoutingListenerPortRangeArgs
import com.pulumi.aws.globalaccelerator.kotlin.inputs.CustomRoutingListenerPortRangeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Global Accelerator custom routing listener.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingAccelerator;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingAcceleratorArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.CustomRoutingAcceleratorAttributesArgs;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingListener;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingListenerArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.CustomRoutingListenerPortRangeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCustomRoutingAccelerator = new CustomRoutingAccelerator("exampleCustomRoutingAccelerator", CustomRoutingAcceleratorArgs.builder()
 *             .ipAddressType("IPV4")
 *             .enabled(true)
 *             .attributes(CustomRoutingAcceleratorAttributesArgs.builder()
 *                 .flowLogsEnabled(true)
 *                 .flowLogsS3Bucket("example-bucket")
 *                 .flowLogsS3Prefix("flow-logs/")
 *                 .build())
 *             .build());
 *         var exampleCustomRoutingListener = new CustomRoutingListener("exampleCustomRoutingListener", CustomRoutingListenerArgs.builder()
 *             .acceleratorArn(exampleCustomRoutingAccelerator.id())
 *             .portRanges(CustomRoutingListenerPortRangeArgs.builder()
 *                 .fromPort(80)
 *                 .toPort(80)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Global Accelerator custom routing listeners using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:globalaccelerator/customRoutingListener:CustomRoutingListener example arn:aws:globalaccelerator::111111111111:accelerator/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/listener/xxxxxxxx
 * ```
 * @property acceleratorArn The Amazon Resource Name (ARN) of a custom routing accelerator.
 * @property portRanges The list of port ranges for the connections from clients to the accelerator. Fields documented below.
 */
public data class CustomRoutingListenerArgs(
    public val acceleratorArn: Output<String>? = null,
    public val portRanges: Output<List<CustomRoutingListenerPortRangeArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.globalaccelerator.CustomRoutingListenerArgs> {
    override fun toJava(): com.pulumi.aws.globalaccelerator.CustomRoutingListenerArgs =
        com.pulumi.aws.globalaccelerator.CustomRoutingListenerArgs.builder()
            .acceleratorArn(acceleratorArn?.applyValue({ args0 -> args0 }))
            .portRanges(
                portRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CustomRoutingListenerArgs].
 */
@PulumiTagMarker
public class CustomRoutingListenerArgsBuilder internal constructor() {
    private var acceleratorArn: Output<String>? = null

    private var portRanges: Output<List<CustomRoutingListenerPortRangeArgs>>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of a custom routing accelerator.
     */
    @JvmName("spvjtsrmdgoxxuhf")
    public suspend fun acceleratorArn(`value`: Output<String>) {
        this.acceleratorArn = value
    }

    /**
     * @param value The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("qjwksumfjrjknxki")
    public suspend fun portRanges(`value`: Output<List<CustomRoutingListenerPortRangeArgs>>) {
        this.portRanges = value
    }

    @JvmName("silwaedhojpuvugh")
    public suspend fun portRanges(vararg values: Output<CustomRoutingListenerPortRangeArgs>) {
        this.portRanges = Output.all(values.asList())
    }

    /**
     * @param values The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("soibsfjufudqyqei")
    public suspend fun portRanges(values: List<Output<CustomRoutingListenerPortRangeArgs>>) {
        this.portRanges = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a custom routing accelerator.
     */
    @JvmName("pboymyrvhcnsraba")
    public suspend fun acceleratorArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorArn = mapped
    }

    /**
     * @param value The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("bcantwtohqhyunqm")
    public suspend fun portRanges(`value`: List<CustomRoutingListenerPortRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portRanges = mapped
    }

    /**
     * @param argument The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("jbpymdfrpymywtck")
    public suspend
    fun portRanges(argument: List<suspend CustomRoutingListenerPortRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomRoutingListenerPortRangeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.portRanges = mapped
    }

    /**
     * @param argument The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("eupoptpymuxedcda")
    public suspend fun portRanges(
        vararg
        argument: suspend CustomRoutingListenerPortRangeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CustomRoutingListenerPortRangeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.portRanges = mapped
    }

    /**
     * @param argument The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("jwdtcmciutbygyif")
    public suspend
    fun portRanges(argument: suspend CustomRoutingListenerPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CustomRoutingListenerPortRangeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.portRanges = mapped
    }

    /**
     * @param values The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("xkotywanxmlkqtje")
    public suspend fun portRanges(vararg values: CustomRoutingListenerPortRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portRanges = mapped
    }

    internal fun build(): CustomRoutingListenerArgs = CustomRoutingListenerArgs(
        acceleratorArn = acceleratorArn,
        portRanges = portRanges,
    )
}
