@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin

import com.pulumi.aws.globalaccelerator.EndpointGroupArgs.builder
import com.pulumi.aws.globalaccelerator.kotlin.inputs.EndpointGroupEndpointConfigurationArgs
import com.pulumi.aws.globalaccelerator.kotlin.inputs.EndpointGroupEndpointConfigurationArgsBuilder
import com.pulumi.aws.globalaccelerator.kotlin.inputs.EndpointGroupPortOverrideArgs
import com.pulumi.aws.globalaccelerator.kotlin.inputs.EndpointGroupPortOverrideArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Global Accelerator endpoint group.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.globalaccelerator.EndpointGroup;
 * import com.pulumi.aws.globalaccelerator.EndpointGroupArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.EndpointGroupEndpointConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EndpointGroup("example", EndpointGroupArgs.builder()
 *             .listenerArn(aws_globalaccelerator_listener.example().id())
 *             .endpointConfigurations(EndpointGroupEndpointConfigurationArgs.builder()
 *                 .endpointId(aws_lb.example().arn())
 *                 .weight(100)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Global Accelerator endpoint groups using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:globalaccelerator/endpointGroup:EndpointGroup example arn:aws:globalaccelerator::111111111111:accelerator/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/listener/xxxxxxx/endpoint-group/xxxxxxxx
 * ```
 * @property endpointConfigurations The list of endpoint objects. Fields documented below.
 * @property endpointGroupRegion The name of the AWS Region where the endpoint group is located.
 * @property healthCheckIntervalSeconds The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.
 * @property healthCheckPath If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The default value is slash (`/`). the provider will only perform drift detection of its value when present in a configuration.
 * @property healthCheckPort The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port is the listener port that this endpoint group is associated with. If listener port is a list of ports, Global Accelerator uses the first port in the list.
 * the provider will only perform drift detection of its value when present in a configuration.
 * @property healthCheckProtocol The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default value is TCP.
 * @property listenerArn The Amazon Resource Name (ARN) of the listener.
 * @property portOverrides Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. Fields documented below.
 * @property thresholdCount The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default value is 3.
 * @property trafficDialPercentage The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for this listener. The default value is 100.
 */
public data class EndpointGroupArgs(
    public val endpointConfigurations: Output<List<EndpointGroupEndpointConfigurationArgs>>? = null,
    public val endpointGroupRegion: Output<String>? = null,
    public val healthCheckIntervalSeconds: Output<Int>? = null,
    public val healthCheckPath: Output<String>? = null,
    public val healthCheckPort: Output<Int>? = null,
    public val healthCheckProtocol: Output<String>? = null,
    public val listenerArn: Output<String>? = null,
    public val portOverrides: Output<List<EndpointGroupPortOverrideArgs>>? = null,
    public val thresholdCount: Output<Int>? = null,
    public val trafficDialPercentage: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.aws.globalaccelerator.EndpointGroupArgs> {
    override fun toJava(): com.pulumi.aws.globalaccelerator.EndpointGroupArgs =
        com.pulumi.aws.globalaccelerator.EndpointGroupArgs.builder()
            .endpointConfigurations(
                endpointConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .endpointGroupRegion(endpointGroupRegion?.applyValue({ args0 -> args0 }))
            .healthCheckIntervalSeconds(healthCheckIntervalSeconds?.applyValue({ args0 -> args0 }))
            .healthCheckPath(healthCheckPath?.applyValue({ args0 -> args0 }))
            .healthCheckPort(healthCheckPort?.applyValue({ args0 -> args0 }))
            .healthCheckProtocol(healthCheckProtocol?.applyValue({ args0 -> args0 }))
            .listenerArn(listenerArn?.applyValue({ args0 -> args0 }))
            .portOverrides(
                portOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .thresholdCount(thresholdCount?.applyValue({ args0 -> args0 }))
            .trafficDialPercentage(trafficDialPercentage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointGroupArgs].
 */
@PulumiTagMarker
public class EndpointGroupArgsBuilder internal constructor() {
    private var endpointConfigurations: Output<List<EndpointGroupEndpointConfigurationArgs>>? = null

    private var endpointGroupRegion: Output<String>? = null

    private var healthCheckIntervalSeconds: Output<Int>? = null

    private var healthCheckPath: Output<String>? = null

    private var healthCheckPort: Output<Int>? = null

    private var healthCheckProtocol: Output<String>? = null

    private var listenerArn: Output<String>? = null

    private var portOverrides: Output<List<EndpointGroupPortOverrideArgs>>? = null

    private var thresholdCount: Output<Int>? = null

    private var trafficDialPercentage: Output<Double>? = null

    /**
     * @param value The list of endpoint objects. Fields documented below.
     */
    @JvmName("lpiibssrdumknaeo")
    public suspend
    fun endpointConfigurations(`value`: Output<List<EndpointGroupEndpointConfigurationArgs>>) {
        this.endpointConfigurations = value
    }

    @JvmName("imsdvuseqpmcothl")
    public suspend fun endpointConfigurations(
        vararg
        values: Output<EndpointGroupEndpointConfigurationArgs>,
    ) {
        this.endpointConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The list of endpoint objects. Fields documented below.
     */
    @JvmName("itbkeirdpxyndieh")
    public suspend
    fun endpointConfigurations(values: List<Output<EndpointGroupEndpointConfigurationArgs>>) {
        this.endpointConfigurations = Output.all(values)
    }

    /**
     * @param value The name of the AWS Region where the endpoint group is located.
     */
    @JvmName("ydortxuuojihsjyf")
    public suspend fun endpointGroupRegion(`value`: Output<String>) {
        this.endpointGroupRegion = value
    }

    /**
     * @param value The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.
     */
    @JvmName("aagrsxvctrnjxevr")
    public suspend fun healthCheckIntervalSeconds(`value`: Output<Int>) {
        this.healthCheckIntervalSeconds = value
    }

    /**
     * @param value If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The default value is slash (`/`). the provider will only perform drift detection of its value when present in a configuration.
     */
    @JvmName("dsovhorwvptsvedc")
    public suspend fun healthCheckPath(`value`: Output<String>) {
        this.healthCheckPath = value
    }

    /**
     * @param value The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port is the listener port that this endpoint group is associated with. If listener port is a list of ports, Global Accelerator uses the first port in the list.
     * the provider will only perform drift detection of its value when present in a configuration.
     */
    @JvmName("uwrxmvpmuhigllds")
    public suspend fun healthCheckPort(`value`: Output<Int>) {
        this.healthCheckPort = value
    }

    /**
     * @param value The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default value is TCP.
     */
    @JvmName("gbckrxsqdlvpxqnk")
    public suspend fun healthCheckProtocol(`value`: Output<String>) {
        this.healthCheckProtocol = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the listener.
     */
    @JvmName("qvlxgkhtqaverwgo")
    public suspend fun listenerArn(`value`: Output<String>) {
        this.listenerArn = value
    }

    /**
     * @param value Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. Fields documented below.
     */
    @JvmName("updmqmnosrjunhba")
    public suspend fun portOverrides(`value`: Output<List<EndpointGroupPortOverrideArgs>>) {
        this.portOverrides = value
    }

    @JvmName("wxgoerqlrxkjjgyp")
    public suspend fun portOverrides(vararg values: Output<EndpointGroupPortOverrideArgs>) {
        this.portOverrides = Output.all(values.asList())
    }

    /**
     * @param values Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. Fields documented below.
     */
    @JvmName("rxmqjfwjctowgykc")
    public suspend fun portOverrides(values: List<Output<EndpointGroupPortOverrideArgs>>) {
        this.portOverrides = Output.all(values)
    }

    /**
     * @param value The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default value is 3.
     */
    @JvmName("mkffumqfyqngqmel")
    public suspend fun thresholdCount(`value`: Output<Int>) {
        this.thresholdCount = value
    }

    /**
     * @param value The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for this listener. The default value is 100.
     */
    @JvmName("wdrmqkjibpokmnqm")
    public suspend fun trafficDialPercentage(`value`: Output<Double>) {
        this.trafficDialPercentage = value
    }

    /**
     * @param value The list of endpoint objects. Fields documented below.
     */
    @JvmName("hpejbfvhohaeuoya")
    public suspend
    fun endpointConfigurations(`value`: List<EndpointGroupEndpointConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointConfigurations = mapped
    }

    /**
     * @param argument The list of endpoint objects. Fields documented below.
     */
    @JvmName("yiieqwkwepyiswqq")
    public suspend
    fun endpointConfigurations(argument: List<suspend EndpointGroupEndpointConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EndpointGroupEndpointConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.endpointConfigurations = mapped
    }

    /**
     * @param argument The list of endpoint objects. Fields documented below.
     */
    @JvmName("ssycqvodpvbjehib")
    public suspend fun endpointConfigurations(
        vararg
        argument: suspend EndpointGroupEndpointConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EndpointGroupEndpointConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.endpointConfigurations = mapped
    }

    /**
     * @param argument The list of endpoint objects. Fields documented below.
     */
    @JvmName("hxgjjgimkbwqgdpi")
    public suspend
    fun endpointConfigurations(argument: suspend EndpointGroupEndpointConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EndpointGroupEndpointConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.endpointConfigurations = mapped
    }

    /**
     * @param values The list of endpoint objects. Fields documented below.
     */
    @JvmName("tuppilvociaiesne")
    public suspend fun endpointConfigurations(vararg values: EndpointGroupEndpointConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointConfigurations = mapped
    }

    /**
     * @param value The name of the AWS Region where the endpoint group is located.
     */
    @JvmName("ofaglijiudqorgvq")
    public suspend fun endpointGroupRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointGroupRegion = mapped
    }

    /**
     * @param value The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.
     */
    @JvmName("fftwbyqftxsmcfcm")
    public suspend fun healthCheckIntervalSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckIntervalSeconds = mapped
    }

    /**
     * @param value If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The default value is slash (`/`). the provider will only perform drift detection of its value when present in a configuration.
     */
    @JvmName("yddlyqnjoadhghik")
    public suspend fun healthCheckPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckPath = mapped
    }

    /**
     * @param value The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port is the listener port that this endpoint group is associated with. If listener port is a list of ports, Global Accelerator uses the first port in the list.
     * the provider will only perform drift detection of its value when present in a configuration.
     */
    @JvmName("ngruggxibxjwpgte")
    public suspend fun healthCheckPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckPort = mapped
    }

    /**
     * @param value The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default value is TCP.
     */
    @JvmName("wxxoutvayjkjivwf")
    public suspend fun healthCheckProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckProtocol = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the listener.
     */
    @JvmName("kwsfungfkrivkamc")
    public suspend fun listenerArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerArn = mapped
    }

    /**
     * @param value Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. Fields documented below.
     */
    @JvmName("edlagmnbtjikfpgq")
    public suspend fun portOverrides(`value`: List<EndpointGroupPortOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portOverrides = mapped
    }

    /**
     * @param argument Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. Fields documented below.
     */
    @JvmName("baylwgshmkxcjbli")
    public suspend
    fun portOverrides(argument: List<suspend EndpointGroupPortOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EndpointGroupPortOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.portOverrides = mapped
    }

    /**
     * @param argument Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. Fields documented below.
     */
    @JvmName("lthlnrgmvdigqmfx")
    public suspend fun portOverrides(
        vararg
        argument: suspend EndpointGroupPortOverrideArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EndpointGroupPortOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.portOverrides = mapped
    }

    /**
     * @param argument Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. Fields documented below.
     */
    @JvmName("ribaelvijexdbymr")
    public suspend
    fun portOverrides(argument: suspend EndpointGroupPortOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EndpointGroupPortOverrideArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.portOverrides = mapped
    }

    /**
     * @param values Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. Fields documented below.
     */
    @JvmName("xxyqqowvxopqmyuo")
    public suspend fun portOverrides(vararg values: EndpointGroupPortOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portOverrides = mapped
    }

    /**
     * @param value The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default value is 3.
     */
    @JvmName("cafsdgkcqpjytvwa")
    public suspend fun thresholdCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thresholdCount = mapped
    }

    /**
     * @param value The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for this listener. The default value is 100.
     */
    @JvmName("eiprpetphfoskxtg")
    public suspend fun trafficDialPercentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficDialPercentage = mapped
    }

    internal fun build(): EndpointGroupArgs = EndpointGroupArgs(
        endpointConfigurations = endpointConfigurations,
        endpointGroupRegion = endpointGroupRegion,
        healthCheckIntervalSeconds = healthCheckIntervalSeconds,
        healthCheckPath = healthCheckPath,
        healthCheckPort = healthCheckPort,
        healthCheckProtocol = healthCheckProtocol,
        listenerArn = listenerArn,
        portOverrides = portOverrides,
        thresholdCount = thresholdCount,
        trafficDialPercentage = trafficDialPercentage,
    )
}
