@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin

import com.pulumi.aws.globalaccelerator.GlobalacceleratorFunctions.getAcceleratorPlain
import com.pulumi.aws.globalaccelerator.GlobalacceleratorFunctions.getCustomRoutingAcceleratorPlain
import com.pulumi.aws.globalaccelerator.kotlin.inputs.GetAcceleratorPlainArgs
import com.pulumi.aws.globalaccelerator.kotlin.inputs.GetAcceleratorPlainArgsBuilder
import com.pulumi.aws.globalaccelerator.kotlin.inputs.GetCustomRoutingAcceleratorPlainArgs
import com.pulumi.aws.globalaccelerator.kotlin.inputs.GetCustomRoutingAcceleratorPlainArgsBuilder
import com.pulumi.aws.globalaccelerator.kotlin.outputs.GetAcceleratorResult
import com.pulumi.aws.globalaccelerator.kotlin.outputs.GetCustomRoutingAcceleratorResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.globalaccelerator.kotlin.outputs.GetAcceleratorResult.Companion.toKotlin as getAcceleratorResultToKotlin
import com.pulumi.aws.globalaccelerator.kotlin.outputs.GetCustomRoutingAcceleratorResult.Companion.toKotlin as getCustomRoutingAcceleratorResultToKotlin

public object GlobalacceleratorFunctions {
    /**
     * Provides information about a Global Accelerator accelerator.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.globalaccelerator.GlobalacceleratorFunctions;
     * import com.pulumi.aws.globalaccelerator.inputs.GetAcceleratorArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var acceleratorArn = config.get("acceleratorArn").orElse("");
     *         final var acceleratorName = config.get("acceleratorName").orElse("");
     *         final var example = GlobalacceleratorFunctions.getAccelerator(GetAcceleratorArgs.builder()
     *             .arn(acceleratorArn)
     *             .name(acceleratorName)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getAccelerator.
     * @return A collection of values returned by getAccelerator.
     */
    public suspend fun getAccelerator(argument: GetAcceleratorPlainArgs): GetAcceleratorResult =
        getAcceleratorResultToKotlin(getAcceleratorPlain(argument.toJava()).await())

    /**
     * @see [getAccelerator].
     * @param arn Full ARN of the Global Accelerator.
     * @param id
     * @param name Unique name of the Global Accelerator.
     * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
     * @return A collection of values returned by getAccelerator.
     */
    public suspend fun getAccelerator(
        arn: String? = null,
        id: String? = null,
        name: String? = null,
    ): GetAcceleratorResult {
        val argument = GetAcceleratorPlainArgs(
            arn = arn,
            id = id,
            name = name,
        )
        return getAcceleratorResultToKotlin(getAcceleratorPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccelerator].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;globalaccelerator&#46;kotlin&#46;inputs&#46;GetAcceleratorPlainArgs].
     * @return A collection of values returned by getAccelerator.
     */
    public suspend fun getAccelerator(argument: suspend GetAcceleratorPlainArgsBuilder.() -> Unit):
        GetAcceleratorResult {
        val builder = GetAcceleratorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAcceleratorResultToKotlin(getAcceleratorPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a Global Accelerator custom routing accelerator.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.globalaccelerator.GlobalacceleratorFunctions;
     * import com.pulumi.aws.globalaccelerator.inputs.GetCustomRoutingAcceleratorArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var acceleratorArn = config.get("acceleratorArn").orElse("");
     *         final var acceleratorName = config.get("acceleratorName").orElse("");
     *         final var example = GlobalacceleratorFunctions.getCustomRoutingAccelerator(GetCustomRoutingAcceleratorArgs.builder()
     *             .arn(acceleratorArn)
     *             .name(acceleratorName)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getCustomRoutingAccelerator.
     * @return A collection of values returned by getCustomRoutingAccelerator.
     */
    public suspend fun getCustomRoutingAccelerator(argument: GetCustomRoutingAcceleratorPlainArgs):
        GetCustomRoutingAcceleratorResult =
        getCustomRoutingAcceleratorResultToKotlin(getCustomRoutingAcceleratorPlain(argument.toJava()).await())

    /**
     * @see [getCustomRoutingAccelerator].
     * @param arn Full ARN of the custom routing accelerator.
     * @param name Unique name of the custom routing accelerator.
     * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
     * @param tags
     * @return A collection of values returned by getCustomRoutingAccelerator.
     */
    public suspend fun getCustomRoutingAccelerator(
        arn: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetCustomRoutingAcceleratorResult {
        val argument = GetCustomRoutingAcceleratorPlainArgs(
            arn = arn,
            name = name,
            tags = tags,
        )
        return getCustomRoutingAcceleratorResultToKotlin(getCustomRoutingAcceleratorPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomRoutingAccelerator].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;globalaccelerator&#46;kotlin&#46;inputs&#46;GetCustomRoutingAcceleratorPlainArgs].
     * @return A collection of values returned by getCustomRoutingAccelerator.
     */
    public suspend
    fun getCustomRoutingAccelerator(argument: suspend GetCustomRoutingAcceleratorPlainArgsBuilder.() -> Unit):
        GetCustomRoutingAcceleratorResult {
        val builder = GetCustomRoutingAcceleratorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomRoutingAcceleratorResultToKotlin(getCustomRoutingAcceleratorPlain(builtArgument.toJava()).await())
    }
}
