@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin

import com.pulumi.aws.globalaccelerator.kotlin.outputs.ListenerPortRange
import com.pulumi.aws.globalaccelerator.kotlin.outputs.ListenerPortRange.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Listener].
 */
@PulumiTagMarker
public class ListenerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ListenerArgs = ListenerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ListenerArgsBuilder.() -> Unit) {
        val builder = ListenerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Listener {
        val builtJavaResource = com.pulumi.aws.globalaccelerator.Listener(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Listener(builtJavaResource)
    }
}

/**
 * Provides a Global Accelerator listener.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.globalaccelerator.Accelerator;
 * import com.pulumi.aws.globalaccelerator.AcceleratorArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.AcceleratorAttributesArgs;
 * import com.pulumi.aws.globalaccelerator.Listener;
 * import com.pulumi.aws.globalaccelerator.ListenerArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.ListenerPortRangeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccelerator = new Accelerator("exampleAccelerator", AcceleratorArgs.builder()
 *             .ipAddressType("IPV4")
 *             .enabled(true)
 *             .attributes(AcceleratorAttributesArgs.builder()
 *                 .flowLogsEnabled(true)
 *                 .flowLogsS3Bucket("example-bucket")
 *                 .flowLogsS3Prefix("flow-logs/")
 *                 .build())
 *             .build());
 *         var exampleListener = new Listener("exampleListener", ListenerArgs.builder()
 *             .acceleratorArn(exampleAccelerator.id())
 *             .clientAffinity("SOURCE_IP")
 *             .protocol("TCP")
 *             .portRanges(ListenerPortRangeArgs.builder()
 *                 .fromPort(80)
 *                 .toPort(80)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Global Accelerator listeners using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:globalaccelerator/listener:Listener example arn:aws:globalaccelerator::111111111111:accelerator/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/listener/xxxxxxxx
 * ```
 *
 */
public class Listener internal constructor(
    override val javaResource: com.pulumi.aws.globalaccelerator.Listener,
) : KotlinCustomResource(javaResource, ListenerMapper) {
    /**
     * The Amazon Resource Name (ARN) of your accelerator.
     */
    public val acceleratorArn: Output<String>
        get() = javaResource.acceleratorArn().applyValue({ args0 -> args0 })

    /**
     * Direct all requests from a user to the same endpoint. Valid values are `NONE`, `SOURCE_IP`. Default: `NONE`. If `NONE`, Global Accelerator uses the "five-tuple" properties of source IP address, source port, destination IP address, destination port, and protocol to select the hash value. If `SOURCE_IP`, Global Accelerator uses the "two-tuple" properties of source (client) IP address and destination IP address to select the hash value.
     */
    public val clientAffinity: Output<String>?
        get() = javaResource.clientAffinity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    public val portRanges: Output<List<ListenerPortRange>>
        get() = javaResource.portRanges().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The protocol for the connections from clients to the accelerator. Valid values are `TCP`, `UDP`.
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })
}

public object ListenerMapper : ResourceMapper<Listener> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.globalaccelerator.Listener::class == javaResource::class

    override fun map(javaResource: Resource): Listener = Listener(
        javaResource as
            com.pulumi.aws.globalaccelerator.Listener,
    )
}

/**
 * @see [Listener].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Listener].
 */
public suspend fun listener(name: String, block: suspend ListenerResourceBuilder.() -> Unit):
    Listener {
    val builder = ListenerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Listener].
 * @param name The _unique_ name of the resulting resource.
 */
public fun listener(name: String): Listener {
    val builder = ListenerResourceBuilder()
    builder.name(name)
    return builder.build()
}
