@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin

import com.pulumi.aws.globalaccelerator.ListenerArgs.builder
import com.pulumi.aws.globalaccelerator.kotlin.inputs.ListenerPortRangeArgs
import com.pulumi.aws.globalaccelerator.kotlin.inputs.ListenerPortRangeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Global Accelerator listener.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.globalaccelerator.Accelerator;
 * import com.pulumi.aws.globalaccelerator.AcceleratorArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.AcceleratorAttributesArgs;
 * import com.pulumi.aws.globalaccelerator.Listener;
 * import com.pulumi.aws.globalaccelerator.ListenerArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.ListenerPortRangeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccelerator = new Accelerator("exampleAccelerator", AcceleratorArgs.builder()
 *             .ipAddressType("IPV4")
 *             .enabled(true)
 *             .attributes(AcceleratorAttributesArgs.builder()
 *                 .flowLogsEnabled(true)
 *                 .flowLogsS3Bucket("example-bucket")
 *                 .flowLogsS3Prefix("flow-logs/")
 *                 .build())
 *             .build());
 *         var exampleListener = new Listener("exampleListener", ListenerArgs.builder()
 *             .acceleratorArn(exampleAccelerator.id())
 *             .clientAffinity("SOURCE_IP")
 *             .protocol("TCP")
 *             .portRanges(ListenerPortRangeArgs.builder()
 *                 .fromPort(80)
 *                 .toPort(80)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Global Accelerator listeners using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:globalaccelerator/listener:Listener example arn:aws:globalaccelerator::111111111111:accelerator/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/listener/xxxxxxxx
 * ```
 * @property acceleratorArn The Amazon Resource Name (ARN) of your accelerator.
 * @property clientAffinity Direct all requests from a user to the same endpoint. Valid values are `NONE`, `SOURCE_IP`. Default: `NONE`. If `NONE`, Global Accelerator uses the "five-tuple" properties of source IP address, source port, destination IP address, destination port, and protocol to select the hash value. If `SOURCE_IP`, Global Accelerator uses the "two-tuple" properties of source (client) IP address and destination IP address to select the hash value.
 * @property portRanges The list of port ranges for the connections from clients to the accelerator. Fields documented below.
 * @property protocol The protocol for the connections from clients to the accelerator. Valid values are `TCP`, `UDP`.
 */
public data class ListenerArgs(
    public val acceleratorArn: Output<String>? = null,
    public val clientAffinity: Output<String>? = null,
    public val portRanges: Output<List<ListenerPortRangeArgs>>? = null,
    public val protocol: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.globalaccelerator.ListenerArgs> {
    override fun toJava(): com.pulumi.aws.globalaccelerator.ListenerArgs =
        com.pulumi.aws.globalaccelerator.ListenerArgs.builder()
            .acceleratorArn(acceleratorArn?.applyValue({ args0 -> args0 }))
            .clientAffinity(clientAffinity?.applyValue({ args0 -> args0 }))
            .portRanges(
                portRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .protocol(protocol?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerArgs].
 */
@PulumiTagMarker
public class ListenerArgsBuilder internal constructor() {
    private var acceleratorArn: Output<String>? = null

    private var clientAffinity: Output<String>? = null

    private var portRanges: Output<List<ListenerPortRangeArgs>>? = null

    private var protocol: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of your accelerator.
     */
    @JvmName("hulwlcjdvgqdeywl")
    public suspend fun acceleratorArn(`value`: Output<String>) {
        this.acceleratorArn = value
    }

    /**
     * @param value Direct all requests from a user to the same endpoint. Valid values are `NONE`, `SOURCE_IP`. Default: `NONE`. If `NONE`, Global Accelerator uses the "five-tuple" properties of source IP address, source port, destination IP address, destination port, and protocol to select the hash value. If `SOURCE_IP`, Global Accelerator uses the "two-tuple" properties of source (client) IP address and destination IP address to select the hash value.
     */
    @JvmName("csahoxniqsrragqg")
    public suspend fun clientAffinity(`value`: Output<String>) {
        this.clientAffinity = value
    }

    /**
     * @param value The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("smadjayabnnikojx")
    public suspend fun portRanges(`value`: Output<List<ListenerPortRangeArgs>>) {
        this.portRanges = value
    }

    @JvmName("wvqqwkhwuwixcuyg")
    public suspend fun portRanges(vararg values: Output<ListenerPortRangeArgs>) {
        this.portRanges = Output.all(values.asList())
    }

    /**
     * @param values The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("atdyjvoxbteeuhjw")
    public suspend fun portRanges(values: List<Output<ListenerPortRangeArgs>>) {
        this.portRanges = Output.all(values)
    }

    /**
     * @param value The protocol for the connections from clients to the accelerator. Valid values are `TCP`, `UDP`.
     */
    @JvmName("nmgfgtnenkprctje")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of your accelerator.
     */
    @JvmName("rlklbpmwmgjbcpom")
    public suspend fun acceleratorArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorArn = mapped
    }

    /**
     * @param value Direct all requests from a user to the same endpoint. Valid values are `NONE`, `SOURCE_IP`. Default: `NONE`. If `NONE`, Global Accelerator uses the "five-tuple" properties of source IP address, source port, destination IP address, destination port, and protocol to select the hash value. If `SOURCE_IP`, Global Accelerator uses the "two-tuple" properties of source (client) IP address and destination IP address to select the hash value.
     */
    @JvmName("gsupynbtpplmliiy")
    public suspend fun clientAffinity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAffinity = mapped
    }

    /**
     * @param value The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("oyokkxgkhfduwffc")
    public suspend fun portRanges(`value`: List<ListenerPortRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portRanges = mapped
    }

    /**
     * @param argument The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("lnhyclionkxpprum")
    public suspend fun portRanges(argument: List<suspend ListenerPortRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ListenerPortRangeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.portRanges = mapped
    }

    /**
     * @param argument The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("teynjeiablocqsdh")
    public suspend fun portRanges(vararg argument: suspend ListenerPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ListenerPortRangeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.portRanges = mapped
    }

    /**
     * @param argument The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("ddolaesgbwhlbqnl")
    public suspend fun portRanges(argument: suspend ListenerPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ListenerPortRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.portRanges = mapped
    }

    /**
     * @param values The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("yltliewbkojocugf")
    public suspend fun portRanges(vararg values: ListenerPortRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portRanges = mapped
    }

    /**
     * @param value The protocol for the connections from clients to the accelerator. Valid values are `TCP`, `UDP`.
     */
    @JvmName("fpghvqbsxslepsyf")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): ListenerArgs = ListenerArgs(
        acceleratorArn = acceleratorArn,
        clientAffinity = clientAffinity,
        portRanges = portRanges,
        protocol = protocol,
    )
}
