@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin.inputs

import com.pulumi.aws.globalaccelerator.inputs.CustomRoutingEndpointGroupEndpointConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointId An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.
 */
public data class CustomRoutingEndpointGroupEndpointConfigurationArgs(
    public val endpointId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.globalaccelerator.inputs.CustomRoutingEndpointGroupEndpointConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.globalaccelerator.inputs.CustomRoutingEndpointGroupEndpointConfigurationArgs =
        com.pulumi.aws.globalaccelerator.inputs.CustomRoutingEndpointGroupEndpointConfigurationArgs.builder()
            .endpointId(endpointId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomRoutingEndpointGroupEndpointConfigurationArgs].
 */
@PulumiTagMarker
public class CustomRoutingEndpointGroupEndpointConfigurationArgsBuilder internal constructor() {
    private var endpointId: Output<String>? = null

    /**
     * @param value An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.
     */
    @JvmName("fjhnmwdbruarqpis")
    public suspend fun endpointId(`value`: Output<String>) {
        this.endpointId = value
    }

    /**
     * @param value An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.
     */
    @JvmName("csflkrugwdjdcdkk")
    public suspend fun endpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointId = mapped
    }

    internal fun build(): CustomRoutingEndpointGroupEndpointConfigurationArgs =
        CustomRoutingEndpointGroupEndpointConfigurationArgs(
            endpointId = endpointId,
        )
}
