@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin.inputs

import com.pulumi.aws.globalaccelerator.inputs.EndpointGroupEndpointConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clientIpPreservationEnabled Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint. See the [AWS documentation](https://docs.aws.amazon.com/global-accelerator/latest/dg/preserve-client-ip-address.html) for more details. The default value is `false`.
 * **Note:** When client IP address preservation is enabled, the Global Accelerator service creates an EC2 Security Group in the VPC named `GlobalAccelerator` that must be deleted (potentially outside of the provider) before the VPC will successfully delete. If this EC2 Security Group is not deleted, the provider will retry the VPC deletion for a few minutes before reporting a `DependencyViolation` error. This cannot be resolved by re-running the provider.
 * @property endpointId An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address allocation ID.
 * @property weight The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global Accelerator to route traffic based on proportions that you specify.
 */
public data class EndpointGroupEndpointConfigurationArgs(
    public val clientIpPreservationEnabled: Output<Boolean>? = null,
    public val endpointId: Output<String>? = null,
    public val weight: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.globalaccelerator.inputs.EndpointGroupEndpointConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.globalaccelerator.inputs.EndpointGroupEndpointConfigurationArgs =
        com.pulumi.aws.globalaccelerator.inputs.EndpointGroupEndpointConfigurationArgs.builder()
            .clientIpPreservationEnabled(clientIpPreservationEnabled?.applyValue({ args0 -> args0 }))
            .endpointId(endpointId?.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointGroupEndpointConfigurationArgs].
 */
@PulumiTagMarker
public class EndpointGroupEndpointConfigurationArgsBuilder internal constructor() {
    private var clientIpPreservationEnabled: Output<Boolean>? = null

    private var endpointId: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint. See the [AWS documentation](https://docs.aws.amazon.com/global-accelerator/latest/dg/preserve-client-ip-address.html) for more details. The default value is `false`.
     * **Note:** When client IP address preservation is enabled, the Global Accelerator service creates an EC2 Security Group in the VPC named `GlobalAccelerator` that must be deleted (potentially outside of the provider) before the VPC will successfully delete. If this EC2 Security Group is not deleted, the provider will retry the VPC deletion for a few minutes before reporting a `DependencyViolation` error. This cannot be resolved by re-running the provider.
     */
    @JvmName("jieetgobnfwcagmo")
    public suspend fun clientIpPreservationEnabled(`value`: Output<Boolean>) {
        this.clientIpPreservationEnabled = value
    }

    /**
     * @param value An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address allocation ID.
     */
    @JvmName("hibfwuyjrxoinkqa")
    public suspend fun endpointId(`value`: Output<String>) {
        this.endpointId = value
    }

    /**
     * @param value The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global Accelerator to route traffic based on proportions that you specify.
     */
    @JvmName("sxkuawlgknwpyncq")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint. See the [AWS documentation](https://docs.aws.amazon.com/global-accelerator/latest/dg/preserve-client-ip-address.html) for more details. The default value is `false`.
     * **Note:** When client IP address preservation is enabled, the Global Accelerator service creates an EC2 Security Group in the VPC named `GlobalAccelerator` that must be deleted (potentially outside of the provider) before the VPC will successfully delete. If this EC2 Security Group is not deleted, the provider will retry the VPC deletion for a few minutes before reporting a `DependencyViolation` error. This cannot be resolved by re-running the provider.
     */
    @JvmName("fjlwcrfyvmwphflq")
    public suspend fun clientIpPreservationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientIpPreservationEnabled = mapped
    }

    /**
     * @param value An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address allocation ID.
     */
    @JvmName("pdgrkgicqfnieyqh")
    public suspend fun endpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointId = mapped
    }

    /**
     * @param value The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global Accelerator to route traffic based on proportions that you specify.
     */
    @JvmName("qrabgbisvimyhacs")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): EndpointGroupEndpointConfigurationArgs =
        EndpointGroupEndpointConfigurationArgs(
            clientIpPreservationEnabled = clientIpPreservationEnabled,
            endpointId = endpointId,
            weight = weight,
        )
}
