@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin.inputs

import com.pulumi.aws.globalaccelerator.inputs.ListenerPortRangeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fromPort The first port in the range of ports, inclusive.
 * @property toPort The last port in the range of ports, inclusive.
 */
public data class ListenerPortRangeArgs(
    public val fromPort: Output<Int>? = null,
    public val toPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.globalaccelerator.inputs.ListenerPortRangeArgs> {
    override fun toJava(): com.pulumi.aws.globalaccelerator.inputs.ListenerPortRangeArgs =
        com.pulumi.aws.globalaccelerator.inputs.ListenerPortRangeArgs.builder()
            .fromPort(fromPort?.applyValue({ args0 -> args0 }))
            .toPort(toPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerPortRangeArgs].
 */
@PulumiTagMarker
public class ListenerPortRangeArgsBuilder internal constructor() {
    private var fromPort: Output<Int>? = null

    private var toPort: Output<Int>? = null

    /**
     * @param value The first port in the range of ports, inclusive.
     */
    @JvmName("rngknbdggxynyrfp")
    public suspend fun fromPort(`value`: Output<Int>) {
        this.fromPort = value
    }

    /**
     * @param value The last port in the range of ports, inclusive.
     */
    @JvmName("wjlnyphqestvxpeu")
    public suspend fun toPort(`value`: Output<Int>) {
        this.toPort = value
    }

    /**
     * @param value The first port in the range of ports, inclusive.
     */
    @JvmName("gupaikghaoreuyot")
    public suspend fun fromPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fromPort = mapped
    }

    /**
     * @param value The last port in the range of ports, inclusive.
     */
    @JvmName("lvtkkvdrgyguiayt")
    public suspend fun toPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.toPort = mapped
    }

    internal fun build(): ListenerPortRangeArgs = ListenerPortRangeArgs(
        fromPort = fromPort,
        toPort = toPort,
    )
}
