@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property flowLogsEnabled Indicates whether flow logs are enabled. Defaults to `false`. Valid values: `true`, `false`.
 * @property flowLogsS3Bucket The name of the Amazon S3 bucket for the flow logs. Required if `flow_logs_enabled` is `true`.
 * @property flowLogsS3Prefix The prefix for the location in the Amazon S3 bucket for the flow logs. Required if `flow_logs_enabled` is `true`.
 */
public data class CustomRoutingAcceleratorAttributes(
    public val flowLogsEnabled: Boolean? = null,
    public val flowLogsS3Bucket: String? = null,
    public val flowLogsS3Prefix: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.globalaccelerator.outputs.CustomRoutingAcceleratorAttributes):
            CustomRoutingAcceleratorAttributes = CustomRoutingAcceleratorAttributes(
            flowLogsEnabled = javaType.flowLogsEnabled().map({ args0 -> args0 }).orElse(null),
            flowLogsS3Bucket = javaType.flowLogsS3Bucket().map({ args0 -> args0 }).orElse(null),
            flowLogsS3Prefix = javaType.flowLogsS3Prefix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
