@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property fromPort The first port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.
 * @property protocols The protocol for the endpoint group that is associated with a custom routing accelerator. The protocol can be either `"TCP"` or `"UDP"`.
 * @property toPort The last port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.
 */
public data class CustomRoutingEndpointGroupDestinationConfiguration(
    public val fromPort: Int,
    public val protocols: List<String>,
    public val toPort: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.globalaccelerator.outputs.CustomRoutingEndpointGroupDestinationConfiguration):
            CustomRoutingEndpointGroupDestinationConfiguration =
            CustomRoutingEndpointGroupDestinationConfiguration(
                fromPort = javaType.fromPort(),
                protocols = javaType.protocols().map({ args0 -> args0 }),
                toPort = javaType.toPort(),
            )
    }
}
