@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getCustomRoutingAccelerator.
 * @property arn
 * @property attributes
 * @property dnsName
 * @property enabled
 * @property hostedZoneId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ipAddressType
 * @property ipSets
 * @property name
 * @property tags
 */
public data class GetCustomRoutingAcceleratorResult(
    public val arn: String,
    public val attributes: List<GetCustomRoutingAcceleratorAttribute>,
    public val dnsName: String,
    public val enabled: Boolean,
    public val hostedZoneId: String,
    public val id: String,
    public val ipAddressType: String,
    public val ipSets: List<GetCustomRoutingAcceleratorIpSet>,
    public val name: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.globalaccelerator.outputs.GetCustomRoutingAcceleratorResult):
            GetCustomRoutingAcceleratorResult = GetCustomRoutingAcceleratorResult(
            arn = javaType.arn(),
            attributes = javaType.attributes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.globalaccelerator.kotlin.outputs.GetCustomRoutingAcceleratorAttribute.Companion.toKotlin(args0)
                })
            }),
            dnsName = javaType.dnsName(),
            enabled = javaType.enabled(),
            hostedZoneId = javaType.hostedZoneId(),
            id = javaType.id(),
            ipAddressType = javaType.ipAddressType(),
            ipSets = javaType.ipSets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.globalaccelerator.kotlin.outputs.GetCustomRoutingAcceleratorIpSet.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
