@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.kotlin.outputs.CatalogDatabaseCreateTableDefaultPermission
import com.pulumi.aws.glue.kotlin.outputs.CatalogDatabaseTargetDatabase
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.glue.kotlin.outputs.CatalogDatabaseCreateTableDefaultPermission.Companion.toKotlin as catalogDatabaseCreateTableDefaultPermissionToKotlin
import com.pulumi.aws.glue.kotlin.outputs.CatalogDatabaseTargetDatabase.Companion.toKotlin as catalogDatabaseTargetDatabaseToKotlin

/**
 * Builder for [CatalogDatabase].
 */
@PulumiTagMarker
public class CatalogDatabaseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CatalogDatabaseArgs = CatalogDatabaseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CatalogDatabaseArgsBuilder.() -> Unit) {
        val builder = CatalogDatabaseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CatalogDatabase {
        val builtJavaResource = com.pulumi.aws.glue.CatalogDatabase(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CatalogDatabase(builtJavaResource)
    }
}

/**
 * Provides a Glue Catalog Database Resource. You can refer to the [Glue Developer Guide](http://docs.aws.amazon.com/glue/latest/dg/populate-data-catalog.html) for a full explanation of the Glue Data Catalog functionality
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogDatabase;
 * import com.pulumi.aws.glue.CatalogDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awsGlueCatalogDatabase = new CatalogDatabase("awsGlueCatalogDatabase", CatalogDatabaseArgs.builder()
 *             .name("MyCatalogDatabase")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Table Default Permissions
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogDatabase;
 * import com.pulumi.aws.glue.CatalogDatabaseArgs;
 * import com.pulumi.aws.glue.inputs.CatalogDatabaseCreateTableDefaultPermissionArgs;
 * import com.pulumi.aws.glue.inputs.CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awsGlueCatalogDatabase = new CatalogDatabase("awsGlueCatalogDatabase", CatalogDatabaseArgs.builder()
 *             .createTableDefaultPermissions(CatalogDatabaseCreateTableDefaultPermissionArgs.builder()
 *                 .permissions("SELECT")
 *                 .principal(CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs.builder()
 *                     .dataLakePrincipalIdentifier("IAM_ALLOWED_PRINCIPALS")
 *                     .build())
 *                 .build())
 *             .name("MyCatalogDatabase")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Catalog Databases using the `catalog_id:name`. If you have not set a Catalog ID specify the AWS Account ID that the database is in. For example:
 * ```sh
 *  $ pulumi import aws:glue/catalogDatabase:CatalogDatabase database 123456789012:my_database
 * ```
 *
 */
public class CatalogDatabase internal constructor(
    override val javaResource: com.pulumi.aws.glue.CatalogDatabase,
) : KotlinCustomResource(javaResource, CatalogDatabaseMapper) {
    /**
     * ARN of the Glue Catalog Database.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * ID of the Glue Catalog to create the database in. If omitted, this defaults to the AWS Account ID.
     */
    public val catalogId: Output<String>
        get() = javaResource.catalogId().applyValue({ args0 -> args0 })

    /**
     * Creates a set of default permissions on the table for principals. See `create_table_default_permission` below.
     */
    public val createTableDefaultPermissions:
        Output<List<CatalogDatabaseCreateTableDefaultPermission>>
        get() = javaResource.createTableDefaultPermissions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> catalogDatabaseCreateTableDefaultPermissionToKotlin(args0) })
            })
        })

    /**
     * Description of the database.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Location of the database (for example, an HDFS path).
     */
    public val locationUri: Output<String>
        get() = javaResource.locationUri().applyValue({ args0 -> args0 })

    /**
     * Name of the database. The acceptable characters are lowercase letters, numbers, and the underscore character.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of key-value pairs that define parameters and properties of the database.
     */
    public val parameters: Output<Map<String, String>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration block for a target database for resource linking. See `target_database` below.
     */
    public val targetDatabase: Output<CatalogDatabaseTargetDatabase>?
        get() = javaResource.targetDatabase().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> catalogDatabaseTargetDatabaseToKotlin(args0) })
            }).orElse(null)
        })
}

public object CatalogDatabaseMapper : ResourceMapper<CatalogDatabase> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glue.CatalogDatabase::class == javaResource::class

    override fun map(javaResource: Resource): CatalogDatabase = CatalogDatabase(
        javaResource as
            com.pulumi.aws.glue.CatalogDatabase,
    )
}

/**
 * @see [CatalogDatabase].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CatalogDatabase].
 */
public suspend fun catalogDatabase(
    name: String,
    block: suspend CatalogDatabaseResourceBuilder.() -> Unit,
): CatalogDatabase {
    val builder = CatalogDatabaseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CatalogDatabase].
 * @param name The _unique_ name of the resulting resource.
 */
public fun catalogDatabase(name: String): CatalogDatabase {
    val builder = CatalogDatabaseResourceBuilder()
    builder.name(name)
    return builder.build()
}
