@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.CatalogDatabaseArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.CatalogDatabaseCreateTableDefaultPermissionArgs
import com.pulumi.aws.glue.kotlin.inputs.CatalogDatabaseCreateTableDefaultPermissionArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CatalogDatabaseTargetDatabaseArgs
import com.pulumi.aws.glue.kotlin.inputs.CatalogDatabaseTargetDatabaseArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Glue Catalog Database Resource. You can refer to the [Glue Developer Guide](http://docs.aws.amazon.com/glue/latest/dg/populate-data-catalog.html) for a full explanation of the Glue Data Catalog functionality
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogDatabase;
 * import com.pulumi.aws.glue.CatalogDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awsGlueCatalogDatabase = new CatalogDatabase("awsGlueCatalogDatabase", CatalogDatabaseArgs.builder()
 *             .name("MyCatalogDatabase")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Table Default Permissions
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogDatabase;
 * import com.pulumi.aws.glue.CatalogDatabaseArgs;
 * import com.pulumi.aws.glue.inputs.CatalogDatabaseCreateTableDefaultPermissionArgs;
 * import com.pulumi.aws.glue.inputs.CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awsGlueCatalogDatabase = new CatalogDatabase("awsGlueCatalogDatabase", CatalogDatabaseArgs.builder()
 *             .createTableDefaultPermissions(CatalogDatabaseCreateTableDefaultPermissionArgs.builder()
 *                 .permissions("SELECT")
 *                 .principal(CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs.builder()
 *                     .dataLakePrincipalIdentifier("IAM_ALLOWED_PRINCIPALS")
 *                     .build())
 *                 .build())
 *             .name("MyCatalogDatabase")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Catalog Databases using the `catalog_id:name`. If you have not set a Catalog ID specify the AWS Account ID that the database is in. For example:
 * ```sh
 *  $ pulumi import aws:glue/catalogDatabase:CatalogDatabase database 123456789012:my_database
 * ```
 * @property catalogId ID of the Glue Catalog to create the database in. If omitted, this defaults to the AWS Account ID.
 * @property createTableDefaultPermissions Creates a set of default permissions on the table for principals. See `create_table_default_permission` below.
 * @property description Description of the database.
 * @property locationUri Location of the database (for example, an HDFS path).
 * @property name Name of the database. The acceptable characters are lowercase letters, numbers, and the underscore character.
 * @property parameters List of key-value pairs that define parameters and properties of the database.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetDatabase Configuration block for a target database for resource linking. See `target_database` below.
 */
public data class CatalogDatabaseArgs(
    public val catalogId: Output<String>? = null,
    public val createTableDefaultPermissions:
    Output<List<CatalogDatabaseCreateTableDefaultPermissionArgs>>? = null,
    public val description: Output<String>? = null,
    public val locationUri: Output<String>? = null,
    public val name: Output<String>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetDatabase: Output<CatalogDatabaseTargetDatabaseArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.CatalogDatabaseArgs> {
    override fun toJava(): com.pulumi.aws.glue.CatalogDatabaseArgs =
        com.pulumi.aws.glue.CatalogDatabaseArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .createTableDefaultPermissions(
                createTableDefaultPermissions?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .locationUri(locationUri?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetDatabase(
                targetDatabase?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [CatalogDatabaseArgs].
 */
@PulumiTagMarker
public class CatalogDatabaseArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var createTableDefaultPermissions:
        Output<List<CatalogDatabaseCreateTableDefaultPermissionArgs>>? = null

    private var description: Output<String>? = null

    private var locationUri: Output<String>? = null

    private var name: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetDatabase: Output<CatalogDatabaseTargetDatabaseArgs>? = null

    /**
     * @param value ID of the Glue Catalog to create the database in. If omitted, this defaults to the AWS Account ID.
     */
    @JvmName("rkbokbliiiarcicd")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Creates a set of default permissions on the table for principals. See `create_table_default_permission` below.
     */
    @JvmName("vjwxkbrwxuuirbwd")
    public suspend
    fun createTableDefaultPermissions(`value`: Output<List<CatalogDatabaseCreateTableDefaultPermissionArgs>>) {
        this.createTableDefaultPermissions = value
    }

    @JvmName("tckidschklrjmxyv")
    public suspend fun createTableDefaultPermissions(
        vararg
        values: Output<CatalogDatabaseCreateTableDefaultPermissionArgs>,
    ) {
        this.createTableDefaultPermissions = Output.all(values.asList())
    }

    /**
     * @param values Creates a set of default permissions on the table for principals. See `create_table_default_permission` below.
     */
    @JvmName("dlbmpnijoshtludk")
    public suspend
    fun createTableDefaultPermissions(values: List<Output<CatalogDatabaseCreateTableDefaultPermissionArgs>>) {
        this.createTableDefaultPermissions = Output.all(values)
    }

    /**
     * @param value Description of the database.
     */
    @JvmName("senpvlsphfxilorn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Location of the database (for example, an HDFS path).
     */
    @JvmName("bhvuddcqehdjcaar")
    public suspend fun locationUri(`value`: Output<String>) {
        this.locationUri = value
    }

    /**
     * @param value Name of the database. The acceptable characters are lowercase letters, numbers, and the underscore character.
     */
    @JvmName("objecimtanoiskos")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of key-value pairs that define parameters and properties of the database.
     */
    @JvmName("akaolkrqllodioga")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xstqpysqrxcsrjej")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for a target database for resource linking. See `target_database` below.
     */
    @JvmName("fwespiwxenvwyavi")
    public suspend fun targetDatabase(`value`: Output<CatalogDatabaseTargetDatabaseArgs>) {
        this.targetDatabase = value
    }

    /**
     * @param value ID of the Glue Catalog to create the database in. If omitted, this defaults to the AWS Account ID.
     */
    @JvmName("nnhxvruuhptopmbi")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Creates a set of default permissions on the table for principals. See `create_table_default_permission` below.
     */
    @JvmName("hskndwytxuhnxgos")
    public suspend
    fun createTableDefaultPermissions(`value`: List<CatalogDatabaseCreateTableDefaultPermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createTableDefaultPermissions = mapped
    }

    /**
     * @param argument Creates a set of default permissions on the table for principals. See `create_table_default_permission` below.
     */
    @JvmName("yomfhydyehqskoof")
    public suspend
    fun createTableDefaultPermissions(argument: List<suspend CatalogDatabaseCreateTableDefaultPermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CatalogDatabaseCreateTableDefaultPermissionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.createTableDefaultPermissions = mapped
    }

    /**
     * @param argument Creates a set of default permissions on the table for principals. See `create_table_default_permission` below.
     */
    @JvmName("umfaevtdelqjexos")
    public suspend fun createTableDefaultPermissions(
        vararg
        argument: suspend CatalogDatabaseCreateTableDefaultPermissionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CatalogDatabaseCreateTableDefaultPermissionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.createTableDefaultPermissions = mapped
    }

    /**
     * @param argument Creates a set of default permissions on the table for principals. See `create_table_default_permission` below.
     */
    @JvmName("hehdvoomtbbhtibm")
    public suspend
    fun createTableDefaultPermissions(argument: suspend CatalogDatabaseCreateTableDefaultPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CatalogDatabaseCreateTableDefaultPermissionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.createTableDefaultPermissions = mapped
    }

    /**
     * @param values Creates a set of default permissions on the table for principals. See `create_table_default_permission` below.
     */
    @JvmName("mwqjpyicwfymmohi")
    public suspend fun createTableDefaultPermissions(
        vararg
        values: CatalogDatabaseCreateTableDefaultPermissionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createTableDefaultPermissions = mapped
    }

    /**
     * @param value Description of the database.
     */
    @JvmName("mfhbwsswspxqnyjg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Location of the database (for example, an HDFS path).
     */
    @JvmName("pvtnkuhmbcbujscp")
    public suspend fun locationUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locationUri = mapped
    }

    /**
     * @param value Name of the database. The acceptable characters are lowercase letters, numbers, and the underscore character.
     */
    @JvmName("raepslredvklvgbj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of key-value pairs that define parameters and properties of the database.
     */
    @JvmName("xowvcfaaxfiiqvnp")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values List of key-value pairs that define parameters and properties of the database.
     */
    @JvmName("mwrigufadbnslurf")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rirtrwogfeaoeuio")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vjnyxpkeqjperqwp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block for a target database for resource linking. See `target_database` below.
     */
    @JvmName("imbnislckxcregbl")
    public suspend fun targetDatabase(`value`: CatalogDatabaseTargetDatabaseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDatabase = mapped
    }

    /**
     * @param argument Configuration block for a target database for resource linking. See `target_database` below.
     */
    @JvmName("tdrvdwdwbnhjobxh")
    public suspend
    fun targetDatabase(argument: suspend CatalogDatabaseTargetDatabaseArgsBuilder.() -> Unit) {
        val toBeMapped = CatalogDatabaseTargetDatabaseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetDatabase = mapped
    }

    internal fun build(): CatalogDatabaseArgs = CatalogDatabaseArgs(
        catalogId = catalogId,
        createTableDefaultPermissions = createTableDefaultPermissions,
        description = description,
        locationUri = locationUri,
        name = name,
        parameters = parameters,
        tags = tags,
        targetDatabase = targetDatabase,
    )
}
