@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.kotlin.outputs.CatalogTableOpenTableFormatInput
import com.pulumi.aws.glue.kotlin.outputs.CatalogTablePartitionIndex
import com.pulumi.aws.glue.kotlin.outputs.CatalogTablePartitionKey
import com.pulumi.aws.glue.kotlin.outputs.CatalogTableStorageDescriptor
import com.pulumi.aws.glue.kotlin.outputs.CatalogTableTargetTable
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.glue.kotlin.outputs.CatalogTableOpenTableFormatInput.Companion.toKotlin as catalogTableOpenTableFormatInputToKotlin
import com.pulumi.aws.glue.kotlin.outputs.CatalogTablePartitionIndex.Companion.toKotlin as catalogTablePartitionIndexToKotlin
import com.pulumi.aws.glue.kotlin.outputs.CatalogTablePartitionKey.Companion.toKotlin as catalogTablePartitionKeyToKotlin
import com.pulumi.aws.glue.kotlin.outputs.CatalogTableStorageDescriptor.Companion.toKotlin as catalogTableStorageDescriptorToKotlin
import com.pulumi.aws.glue.kotlin.outputs.CatalogTableTargetTable.Companion.toKotlin as catalogTableTargetTableToKotlin

/**
 * Builder for [CatalogTable].
 */
@PulumiTagMarker
public class CatalogTableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CatalogTableArgs = CatalogTableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CatalogTableArgsBuilder.() -> Unit) {
        val builder = CatalogTableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CatalogTable {
        val builtJavaResource = com.pulumi.aws.glue.CatalogTable(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CatalogTable(builtJavaResource)
    }
}

/**
 * Provides a Glue Catalog Table Resource. You can refer to the [Glue Developer Guide](http://docs.aws.amazon.com/glue/latest/dg/populate-data-catalog.html) for a full explanation of the Glue Data Catalog functionality.
 * ## Example Usage
 * ### Basic Table
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogTable;
 * import com.pulumi.aws.glue.CatalogTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awsGlueCatalogTable = new CatalogTable("awsGlueCatalogTable", CatalogTableArgs.builder()
 *             .databaseName("MyCatalogDatabase")
 *             .name("MyCatalogTable")
 *             .build());
 *     }
 * }
 * ```
 * ### Parquet Table for Athena
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogTable;
 * import com.pulumi.aws.glue.CatalogTableArgs;
 * import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorArgs;
 * import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSerDeInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awsGlueCatalogTable = new CatalogTable("awsGlueCatalogTable", CatalogTableArgs.builder()
 *             .databaseName("MyCatalogDatabase")
 *             .name("MyCatalogTable")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("EXTERNAL", "TRUE"),
 *                 Map.entry("parquet.compression", "SNAPPY")
 *             ))
 *             .storageDescriptor(CatalogTableStorageDescriptorArgs.builder()
 *                 .columns(
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .name("my_string")
 *                         .type("string")
 *                         .build(),
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .name("my_double")
 *                         .type("double")
 *                         .build(),
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .comment("")
 *                         .name("my_date")
 *                         .type("date")
 *                         .build(),
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .comment("")
 *                         .name("my_bigint")
 *                         .type("bigint")
 *                         .build(),
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .comment("")
 *                         .name("my_struct")
 *                         .type("struct<my_nested_string:string>")
 *                         .build())
 *                 .inputFormat("org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat")
 *                 .location("s3://my-bucket/event-streams/my-stream")
 *                 .outputFormat("org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat")
 *                 .serDeInfo(CatalogTableStorageDescriptorSerDeInfoArgs.builder()
 *                     .name("my-stream")
 *                     .parameters(Map.of("serialization.format", 1))
 *                     .serializationLibrary("org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe")
 *                     .build())
 *                 .build())
 *             .tableType("EXTERNAL_TABLE")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Tables using the catalog ID (usually AWS account ID), database name, and table name. For example:
 * ```sh
 *  $ pulumi import aws:glue/catalogTable:CatalogTable MyTable 123456789012:MyDatabase:MyTable
 * ```
 *
 */
public class CatalogTable internal constructor(
    override val javaResource: com.pulumi.aws.glue.CatalogTable,
) : KotlinCustomResource(javaResource, CatalogTableMapper) {
    /**
     * The ARN of the Glue Table.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
     */
    public val catalogId: Output<String>
        get() = javaResource.catalogId().applyValue({ args0 -> args0 })

    /**
     * Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
     * The follow arguments are optional:
     */
    public val databaseName: Output<String>
        get() = javaResource.databaseName().applyValue({ args0 -> args0 })

    /**
     * Description of the table.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the table. For Hive compatibility, this must be entirely lowercase.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Configuration block for open table formats. See `open_table_format_input` below.
     */
    public val openTableFormatInput: Output<CatalogTableOpenTableFormatInput>?
        get() = javaResource.openTableFormatInput().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> catalogTableOpenTableFormatInputToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Owner of the table.
     */
    public val owner: Output<String>?
        get() = javaResource.owner().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Properties associated with this table, as a list of key-value pairs.
     */
    public val parameters: Output<Map<String, String>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
     */
    public val partitionIndices: Output<List<CatalogTablePartitionIndex>>
        get() = javaResource.partitionIndices().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> catalogTablePartitionIndexToKotlin(args0) })
            })
        })

    /**
     * Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
     */
    public val partitionKeys: Output<List<CatalogTablePartitionKey>>?
        get() = javaResource.partitionKeys().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        catalogTablePartitionKeyToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Retention time for this table.
     */
    public val retention: Output<Int>?
        get() = javaResource.retention().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
     */
    public val storageDescriptor: Output<CatalogTableStorageDescriptor>?
        get() = javaResource.storageDescriptor().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> catalogTableStorageDescriptorToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
     */
    public val tableType: Output<String>?
        get() = javaResource.tableType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Configuration block of a target table for resource linking. See `target_table` below.
     */
    public val targetTable: Output<CatalogTableTargetTable>?
        get() = javaResource.targetTable().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    catalogTableTargetTableToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * If the table is a view, the expanded text of the view; otherwise null.
     */
    public val viewExpandedText: Output<String>?
        get() = javaResource.viewExpandedText().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If the table is a view, the original text of the view; otherwise null.
     */
    public val viewOriginalText: Output<String>?
        get() = javaResource.viewOriginalText().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object CatalogTableMapper : ResourceMapper<CatalogTable> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glue.CatalogTable::class == javaResource::class

    override fun map(javaResource: Resource): CatalogTable = CatalogTable(
        javaResource as
            com.pulumi.aws.glue.CatalogTable,
    )
}

/**
 * @see [CatalogTable].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CatalogTable].
 */
public suspend fun catalogTable(
    name: String,
    block: suspend CatalogTableResourceBuilder.() -> Unit,
): CatalogTable {
    val builder = CatalogTableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CatalogTable].
 * @param name The _unique_ name of the resulting resource.
 */
public fun catalogTable(name: String): CatalogTable {
    val builder = CatalogTableResourceBuilder()
    builder.name(name)
    return builder.build()
}
