@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.CatalogTableArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.CatalogTableOpenTableFormatInputArgs
import com.pulumi.aws.glue.kotlin.inputs.CatalogTableOpenTableFormatInputArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CatalogTablePartitionIndexArgs
import com.pulumi.aws.glue.kotlin.inputs.CatalogTablePartitionIndexArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CatalogTablePartitionKeyArgs
import com.pulumi.aws.glue.kotlin.inputs.CatalogTablePartitionKeyArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CatalogTableStorageDescriptorArgs
import com.pulumi.aws.glue.kotlin.inputs.CatalogTableStorageDescriptorArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CatalogTableTargetTableArgs
import com.pulumi.aws.glue.kotlin.inputs.CatalogTableTargetTableArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Glue Catalog Table Resource. You can refer to the [Glue Developer Guide](http://docs.aws.amazon.com/glue/latest/dg/populate-data-catalog.html) for a full explanation of the Glue Data Catalog functionality.
 * ## Example Usage
 * ### Basic Table
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogTable;
 * import com.pulumi.aws.glue.CatalogTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awsGlueCatalogTable = new CatalogTable("awsGlueCatalogTable", CatalogTableArgs.builder()
 *             .databaseName("MyCatalogDatabase")
 *             .name("MyCatalogTable")
 *             .build());
 *     }
 * }
 * ```
 * ### Parquet Table for Athena
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogTable;
 * import com.pulumi.aws.glue.CatalogTableArgs;
 * import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorArgs;
 * import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSerDeInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awsGlueCatalogTable = new CatalogTable("awsGlueCatalogTable", CatalogTableArgs.builder()
 *             .databaseName("MyCatalogDatabase")
 *             .name("MyCatalogTable")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("EXTERNAL", "TRUE"),
 *                 Map.entry("parquet.compression", "SNAPPY")
 *             ))
 *             .storageDescriptor(CatalogTableStorageDescriptorArgs.builder()
 *                 .columns(
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .name("my_string")
 *                         .type("string")
 *                         .build(),
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .name("my_double")
 *                         .type("double")
 *                         .build(),
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .comment("")
 *                         .name("my_date")
 *                         .type("date")
 *                         .build(),
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .comment("")
 *                         .name("my_bigint")
 *                         .type("bigint")
 *                         .build(),
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .comment("")
 *                         .name("my_struct")
 *                         .type("struct<my_nested_string:string>")
 *                         .build())
 *                 .inputFormat("org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat")
 *                 .location("s3://my-bucket/event-streams/my-stream")
 *                 .outputFormat("org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat")
 *                 .serDeInfo(CatalogTableStorageDescriptorSerDeInfoArgs.builder()
 *                     .name("my-stream")
 *                     .parameters(Map.of("serialization.format", 1))
 *                     .serializationLibrary("org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe")
 *                     .build())
 *                 .build())
 *             .tableType("EXTERNAL_TABLE")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Tables using the catalog ID (usually AWS account ID), database name, and table name. For example:
 * ```sh
 *  $ pulumi import aws:glue/catalogTable:CatalogTable MyTable 123456789012:MyDatabase:MyTable
 * ```
 * @property catalogId ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
 * @property databaseName Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
 * The follow arguments are optional:
 * @property description Description of the table.
 * @property name Name of the table. For Hive compatibility, this must be entirely lowercase.
 * @property openTableFormatInput Configuration block for open table formats. See `open_table_format_input` below.
 * @property owner Owner of the table.
 * @property parameters Properties associated with this table, as a list of key-value pairs.
 * @property partitionIndices Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
 * @property partitionKeys Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
 * @property retention Retention time for this table.
 * @property storageDescriptor Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
 * @property tableType Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
 * @property targetTable Configuration block of a target table for resource linking. See `target_table` below.
 * @property viewExpandedText If the table is a view, the expanded text of the view; otherwise null.
 * @property viewOriginalText If the table is a view, the original text of the view; otherwise null.
 */
public data class CatalogTableArgs(
    public val catalogId: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val openTableFormatInput: Output<CatalogTableOpenTableFormatInputArgs>? = null,
    public val owner: Output<String>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val partitionIndices: Output<List<CatalogTablePartitionIndexArgs>>? = null,
    public val partitionKeys: Output<List<CatalogTablePartitionKeyArgs>>? = null,
    public val retention: Output<Int>? = null,
    public val storageDescriptor: Output<CatalogTableStorageDescriptorArgs>? = null,
    public val tableType: Output<String>? = null,
    public val targetTable: Output<CatalogTableTargetTableArgs>? = null,
    public val viewExpandedText: Output<String>? = null,
    public val viewOriginalText: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.CatalogTableArgs> {
    override fun toJava(): com.pulumi.aws.glue.CatalogTableArgs =
        com.pulumi.aws.glue.CatalogTableArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .openTableFormatInput(
                openTableFormatInput?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .owner(owner?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .partitionIndices(
                partitionIndices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .partitionKeys(
                partitionKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .retention(retention?.applyValue({ args0 -> args0 }))
            .storageDescriptor(storageDescriptor?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tableType(tableType?.applyValue({ args0 -> args0 }))
            .targetTable(targetTable?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .viewExpandedText(viewExpandedText?.applyValue({ args0 -> args0 }))
            .viewOriginalText(viewOriginalText?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CatalogTableArgs].
 */
@PulumiTagMarker
public class CatalogTableArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var openTableFormatInput: Output<CatalogTableOpenTableFormatInputArgs>? = null

    private var owner: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var partitionIndices: Output<List<CatalogTablePartitionIndexArgs>>? = null

    private var partitionKeys: Output<List<CatalogTablePartitionKeyArgs>>? = null

    private var retention: Output<Int>? = null

    private var storageDescriptor: Output<CatalogTableStorageDescriptorArgs>? = null

    private var tableType: Output<String>? = null

    private var targetTable: Output<CatalogTableTargetTableArgs>? = null

    private var viewExpandedText: Output<String>? = null

    private var viewOriginalText: Output<String>? = null

    /**
     * @param value ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
     */
    @JvmName("hitppsxsinujxmyq")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
     * The follow arguments are optional:
     */
    @JvmName("puhovgyujuwesxnq")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Description of the table.
     */
    @JvmName("tkdmyuluxmiulain")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the table. For Hive compatibility, this must be entirely lowercase.
     */
    @JvmName("wqfatqtshfmxsggu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration block for open table formats. See `open_table_format_input` below.
     */
    @JvmName("eulibxwdhwbkkbrn")
    public suspend fun openTableFormatInput(`value`: Output<CatalogTableOpenTableFormatInputArgs>) {
        this.openTableFormatInput = value
    }

    /**
     * @param value Owner of the table.
     */
    @JvmName("xtlkmfuxogfvujvm")
    public suspend fun owner(`value`: Output<String>) {
        this.owner = value
    }

    /**
     * @param value Properties associated with this table, as a list of key-value pairs.
     */
    @JvmName("idvuwvtlwkcyoltk")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
     */
    @JvmName("lqvavetvwxxpkjne")
    public suspend fun partitionIndices(`value`: Output<List<CatalogTablePartitionIndexArgs>>) {
        this.partitionIndices = value
    }

    @JvmName("avsjvvqkqgofuked")
    public suspend fun partitionIndices(vararg values: Output<CatalogTablePartitionIndexArgs>) {
        this.partitionIndices = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
     */
    @JvmName("afdxgulyeakweiuq")
    public suspend fun partitionIndices(values: List<Output<CatalogTablePartitionIndexArgs>>) {
        this.partitionIndices = Output.all(values)
    }

    /**
     * @param value Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
     */
    @JvmName("tsmubhjfgdqqnist")
    public suspend fun partitionKeys(`value`: Output<List<CatalogTablePartitionKeyArgs>>) {
        this.partitionKeys = value
    }

    @JvmName("nnhnpfvghtopwnru")
    public suspend fun partitionKeys(vararg values: Output<CatalogTablePartitionKeyArgs>) {
        this.partitionKeys = Output.all(values.asList())
    }

    /**
     * @param values Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
     */
    @JvmName("ayehuxvxyxfkmqir")
    public suspend fun partitionKeys(values: List<Output<CatalogTablePartitionKeyArgs>>) {
        this.partitionKeys = Output.all(values)
    }

    /**
     * @param value Retention time for this table.
     */
    @JvmName("xyjjdlnxneipltvx")
    public suspend fun retention(`value`: Output<Int>) {
        this.retention = value
    }

    /**
     * @param value Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
     */
    @JvmName("dfcmufpwaexedfsh")
    public suspend fun storageDescriptor(`value`: Output<CatalogTableStorageDescriptorArgs>) {
        this.storageDescriptor = value
    }

    /**
     * @param value Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
     */
    @JvmName("dcivlelxcqjyegjx")
    public suspend fun tableType(`value`: Output<String>) {
        this.tableType = value
    }

    /**
     * @param value Configuration block of a target table for resource linking. See `target_table` below.
     */
    @JvmName("ochyspdxrwjtlkmi")
    public suspend fun targetTable(`value`: Output<CatalogTableTargetTableArgs>) {
        this.targetTable = value
    }

    /**
     * @param value If the table is a view, the expanded text of the view; otherwise null.
     */
    @JvmName("prkgavdvmfpftbso")
    public suspend fun viewExpandedText(`value`: Output<String>) {
        this.viewExpandedText = value
    }

    /**
     * @param value If the table is a view, the original text of the view; otherwise null.
     */
    @JvmName("tkasycumyjjtkbly")
    public suspend fun viewOriginalText(`value`: Output<String>) {
        this.viewOriginalText = value
    }

    /**
     * @param value ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
     */
    @JvmName("owusnpbjrahxxrdt")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
     * The follow arguments are optional:
     */
    @JvmName("dghihbumoucqlieg")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Description of the table.
     */
    @JvmName("djnwnbahsblxrkve")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the table. For Hive compatibility, this must be entirely lowercase.
     */
    @JvmName("rseefdcvwpgntbhu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration block for open table formats. See `open_table_format_input` below.
     */
    @JvmName("hhjarykldixotosr")
    public suspend fun openTableFormatInput(`value`: CatalogTableOpenTableFormatInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openTableFormatInput = mapped
    }

    /**
     * @param argument Configuration block for open table formats. See `open_table_format_input` below.
     */
    @JvmName("mhqifhpfkilwfxih")
    public suspend
    fun openTableFormatInput(argument: suspend CatalogTableOpenTableFormatInputArgsBuilder.() -> Unit) {
        val toBeMapped = CatalogTableOpenTableFormatInputArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.openTableFormatInput = mapped
    }

    /**
     * @param value Owner of the table.
     */
    @JvmName("kpytckwjtowyarab")
    public suspend fun owner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.owner = mapped
    }

    /**
     * @param value Properties associated with this table, as a list of key-value pairs.
     */
    @JvmName("kpokojrquinkwwhf")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Properties associated with this table, as a list of key-value pairs.
     */
    @JvmName("vnurvgqqsjrhmdrh")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
     */
    @JvmName("kgxlpocufgppeajw")
    public suspend fun partitionIndices(`value`: List<CatalogTablePartitionIndexArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionIndices = mapped
    }

    /**
     * @param argument Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
     */
    @JvmName("uhowcxwngcelixwp")
    public suspend
    fun partitionIndices(argument: List<suspend CatalogTablePartitionIndexArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CatalogTablePartitionIndexArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.partitionIndices = mapped
    }

    /**
     * @param argument Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
     */
    @JvmName("sbiwiohgtpxlovoo")
    public suspend fun partitionIndices(
        vararg
        argument: suspend CatalogTablePartitionIndexArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CatalogTablePartitionIndexArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.partitionIndices = mapped
    }

    /**
     * @param argument Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
     */
    @JvmName("vlpuahqrqlygraov")
    public suspend
    fun partitionIndices(argument: suspend CatalogTablePartitionIndexArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CatalogTablePartitionIndexArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.partitionIndices = mapped
    }

    /**
     * @param values Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
     */
    @JvmName("ymflpqvjikfapasa")
    public suspend fun partitionIndices(vararg values: CatalogTablePartitionIndexArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionIndices = mapped
    }

    /**
     * @param value Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
     */
    @JvmName("cjjvexdsiwhjrhfy")
    public suspend fun partitionKeys(`value`: List<CatalogTablePartitionKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionKeys = mapped
    }

    /**
     * @param argument Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
     */
    @JvmName("cbmlteexmnadwmyq")
    public suspend
    fun partitionKeys(argument: List<suspend CatalogTablePartitionKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CatalogTablePartitionKeyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.partitionKeys = mapped
    }

    /**
     * @param argument Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
     */
    @JvmName("byxmfftstfrsvjik")
    public suspend fun partitionKeys(
        vararg
        argument: suspend CatalogTablePartitionKeyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CatalogTablePartitionKeyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.partitionKeys = mapped
    }

    /**
     * @param argument Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
     */
    @JvmName("dsufpjrceqrejmhn")
    public suspend
    fun partitionKeys(argument: suspend CatalogTablePartitionKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CatalogTablePartitionKeyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.partitionKeys = mapped
    }

    /**
     * @param values Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
     */
    @JvmName("fqxrrkpgwfaggaak")
    public suspend fun partitionKeys(vararg values: CatalogTablePartitionKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionKeys = mapped
    }

    /**
     * @param value Retention time for this table.
     */
    @JvmName("aqmnymfisvmfjcwt")
    public suspend fun retention(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retention = mapped
    }

    /**
     * @param value Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
     */
    @JvmName("alianilecfltayto")
    public suspend fun storageDescriptor(`value`: CatalogTableStorageDescriptorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageDescriptor = mapped
    }

    /**
     * @param argument Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
     */
    @JvmName("wwxugmlvjmudmyov")
    public suspend
    fun storageDescriptor(argument: suspend CatalogTableStorageDescriptorArgsBuilder.() -> Unit) {
        val toBeMapped = CatalogTableStorageDescriptorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageDescriptor = mapped
    }

    /**
     * @param value Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
     */
    @JvmName("iaryepcwtmjjysih")
    public suspend fun tableType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableType = mapped
    }

    /**
     * @param value Configuration block of a target table for resource linking. See `target_table` below.
     */
    @JvmName("sxrblaxnuwaaohkd")
    public suspend fun targetTable(`value`: CatalogTableTargetTableArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetTable = mapped
    }

    /**
     * @param argument Configuration block of a target table for resource linking. See `target_table` below.
     */
    @JvmName("qhxiiaqwbaxxkbwk")
    public suspend fun targetTable(argument: suspend CatalogTableTargetTableArgsBuilder.() -> Unit) {
        val toBeMapped = CatalogTableTargetTableArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetTable = mapped
    }

    /**
     * @param value If the table is a view, the expanded text of the view; otherwise null.
     */
    @JvmName("uiwtvexytqdwaivy")
    public suspend fun viewExpandedText(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.viewExpandedText = mapped
    }

    /**
     * @param value If the table is a view, the original text of the view; otherwise null.
     */
    @JvmName("esdtgwgidebqbndc")
    public suspend fun viewOriginalText(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.viewOriginalText = mapped
    }

    internal fun build(): CatalogTableArgs = CatalogTableArgs(
        catalogId = catalogId,
        databaseName = databaseName,
        description = description,
        name = name,
        openTableFormatInput = openTableFormatInput,
        owner = owner,
        parameters = parameters,
        partitionIndices = partitionIndices,
        partitionKeys = partitionKeys,
        retention = retention,
        storageDescriptor = storageDescriptor,
        tableType = tableType,
        targetTable = targetTable,
        viewExpandedText = viewExpandedText,
        viewOriginalText = viewOriginalText,
    )
}
