@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.kotlin.outputs.ClassifierCsvClassifier
import com.pulumi.aws.glue.kotlin.outputs.ClassifierGrokClassifier
import com.pulumi.aws.glue.kotlin.outputs.ClassifierJsonClassifier
import com.pulumi.aws.glue.kotlin.outputs.ClassifierXmlClassifier
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.glue.kotlin.outputs.ClassifierCsvClassifier.Companion.toKotlin as classifierCsvClassifierToKotlin
import com.pulumi.aws.glue.kotlin.outputs.ClassifierGrokClassifier.Companion.toKotlin as classifierGrokClassifierToKotlin
import com.pulumi.aws.glue.kotlin.outputs.ClassifierJsonClassifier.Companion.toKotlin as classifierJsonClassifierToKotlin
import com.pulumi.aws.glue.kotlin.outputs.ClassifierXmlClassifier.Companion.toKotlin as classifierXmlClassifierToKotlin

/**
 * Builder for [Classifier].
 */
@PulumiTagMarker
public class ClassifierResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClassifierArgs = ClassifierArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClassifierArgsBuilder.() -> Unit) {
        val builder = ClassifierArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Classifier {
        val builtJavaResource = com.pulumi.aws.glue.Classifier(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Classifier(builtJavaResource)
    }
}

/**
 * Provides a Glue Classifier resource.
 * > **NOTE:** It is only valid to create one type of classifier (csv, grok, JSON, or XML). Changing classifier types will recreate the classifier.
 * ## Example Usage
 * ### Csv Classifier
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Classifier;
 * import com.pulumi.aws.glue.ClassifierArgs;
 * import com.pulumi.aws.glue.inputs.ClassifierCsvClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Classifier("example", ClassifierArgs.builder()
 *             .csvClassifier(ClassifierCsvClassifierArgs.builder()
 *                 .allowSingleColumn(false)
 *                 .containsHeader("PRESENT")
 *                 .delimiter(",")
 *                 .disableValueTrimming(false)
 *                 .headers(
 *                     "example1",
 *                     "example2")
 *                 .quoteSymbol("'")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Grok Classifier
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Classifier;
 * import com.pulumi.aws.glue.ClassifierArgs;
 * import com.pulumi.aws.glue.inputs.ClassifierGrokClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Classifier("example", ClassifierArgs.builder()
 *             .grokClassifier(ClassifierGrokClassifierArgs.builder()
 *                 .classification("example")
 *                 .grokPattern("example")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### JSON Classifier
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Classifier;
 * import com.pulumi.aws.glue.ClassifierArgs;
 * import com.pulumi.aws.glue.inputs.ClassifierJsonClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Classifier("example", ClassifierArgs.builder()
 *             .jsonClassifier(ClassifierJsonClassifierArgs.builder()
 *                 .jsonPath("example")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### XML Classifier
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Classifier;
 * import com.pulumi.aws.glue.ClassifierArgs;
 * import com.pulumi.aws.glue.inputs.ClassifierXmlClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Classifier("example", ClassifierArgs.builder()
 *             .xmlClassifier(ClassifierXmlClassifierArgs.builder()
 *                 .classification("example")
 *                 .rowTag("example")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Classifiers using their name. For example:
 * ```sh
 *  $ pulumi import aws:glue/classifier:Classifier MyClassifier MyClassifier
 * ```
 *
 */
public class Classifier internal constructor(
    override val javaResource: com.pulumi.aws.glue.Classifier,
) : KotlinCustomResource(javaResource, ClassifierMapper) {
    /**
     * A classifier for Csv content. Defined below.
     */
    public val csvClassifier: Output<ClassifierCsvClassifier>?
        get() = javaResource.csvClassifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> classifierCsvClassifierToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A classifier that uses grok patterns. Defined below.
     */
    public val grokClassifier: Output<ClassifierGrokClassifier>?
        get() = javaResource.grokClassifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> classifierGrokClassifierToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A classifier for JSON content. Defined below.
     */
    public val jsonClassifier: Output<ClassifierJsonClassifier>?
        get() = javaResource.jsonClassifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> classifierJsonClassifierToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the classifier.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A classifier for XML content. Defined below.
     */
    public val xmlClassifier: Output<ClassifierXmlClassifier>?
        get() = javaResource.xmlClassifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> classifierXmlClassifierToKotlin(args0) })
            }).orElse(null)
        })
}

public object ClassifierMapper : ResourceMapper<Classifier> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glue.Classifier::class == javaResource::class

    override fun map(javaResource: Resource): Classifier = Classifier(
        javaResource as
            com.pulumi.aws.glue.Classifier,
    )
}

/**
 * @see [Classifier].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Classifier].
 */
public suspend fun classifier(name: String, block: suspend ClassifierResourceBuilder.() -> Unit):
    Classifier {
    val builder = ClassifierResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Classifier].
 * @param name The _unique_ name of the resulting resource.
 */
public fun classifier(name: String): Classifier {
    val builder = ClassifierResourceBuilder()
    builder.name(name)
    return builder.build()
}
