@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.ClassifierArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.ClassifierCsvClassifierArgs
import com.pulumi.aws.glue.kotlin.inputs.ClassifierCsvClassifierArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.ClassifierGrokClassifierArgs
import com.pulumi.aws.glue.kotlin.inputs.ClassifierGrokClassifierArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.ClassifierJsonClassifierArgs
import com.pulumi.aws.glue.kotlin.inputs.ClassifierJsonClassifierArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.ClassifierXmlClassifierArgs
import com.pulumi.aws.glue.kotlin.inputs.ClassifierXmlClassifierArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a Glue Classifier resource.
 * > **NOTE:** It is only valid to create one type of classifier (csv, grok, JSON, or XML). Changing classifier types will recreate the classifier.
 * ## Example Usage
 * ### Csv Classifier
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Classifier;
 * import com.pulumi.aws.glue.ClassifierArgs;
 * import com.pulumi.aws.glue.inputs.ClassifierCsvClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Classifier("example", ClassifierArgs.builder()
 *             .csvClassifier(ClassifierCsvClassifierArgs.builder()
 *                 .allowSingleColumn(false)
 *                 .containsHeader("PRESENT")
 *                 .delimiter(",")
 *                 .disableValueTrimming(false)
 *                 .headers(
 *                     "example1",
 *                     "example2")
 *                 .quoteSymbol("'")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Grok Classifier
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Classifier;
 * import com.pulumi.aws.glue.ClassifierArgs;
 * import com.pulumi.aws.glue.inputs.ClassifierGrokClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Classifier("example", ClassifierArgs.builder()
 *             .grokClassifier(ClassifierGrokClassifierArgs.builder()
 *                 .classification("example")
 *                 .grokPattern("example")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### JSON Classifier
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Classifier;
 * import com.pulumi.aws.glue.ClassifierArgs;
 * import com.pulumi.aws.glue.inputs.ClassifierJsonClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Classifier("example", ClassifierArgs.builder()
 *             .jsonClassifier(ClassifierJsonClassifierArgs.builder()
 *                 .jsonPath("example")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### XML Classifier
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Classifier;
 * import com.pulumi.aws.glue.ClassifierArgs;
 * import com.pulumi.aws.glue.inputs.ClassifierXmlClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Classifier("example", ClassifierArgs.builder()
 *             .xmlClassifier(ClassifierXmlClassifierArgs.builder()
 *                 .classification("example")
 *                 .rowTag("example")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Classifiers using their name. For example:
 * ```sh
 *  $ pulumi import aws:glue/classifier:Classifier MyClassifier MyClassifier
 * ```
 * @property csvClassifier A classifier for Csv content. Defined below.
 * @property grokClassifier A classifier that uses grok patterns. Defined below.
 * @property jsonClassifier A classifier for JSON content. Defined below.
 * @property name The name of the classifier.
 * @property xmlClassifier A classifier for XML content. Defined below.
 */
public data class ClassifierArgs(
    public val csvClassifier: Output<ClassifierCsvClassifierArgs>? = null,
    public val grokClassifier: Output<ClassifierGrokClassifierArgs>? = null,
    public val jsonClassifier: Output<ClassifierJsonClassifierArgs>? = null,
    public val name: Output<String>? = null,
    public val xmlClassifier: Output<ClassifierXmlClassifierArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.ClassifierArgs> {
    override fun toJava(): com.pulumi.aws.glue.ClassifierArgs =
        com.pulumi.aws.glue.ClassifierArgs.builder()
            .csvClassifier(csvClassifier?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .grokClassifier(grokClassifier?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jsonClassifier(jsonClassifier?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .xmlClassifier(xmlClassifier?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ClassifierArgs].
 */
@PulumiTagMarker
public class ClassifierArgsBuilder internal constructor() {
    private var csvClassifier: Output<ClassifierCsvClassifierArgs>? = null

    private var grokClassifier: Output<ClassifierGrokClassifierArgs>? = null

    private var jsonClassifier: Output<ClassifierJsonClassifierArgs>? = null

    private var name: Output<String>? = null

    private var xmlClassifier: Output<ClassifierXmlClassifierArgs>? = null

    /**
     * @param value A classifier for Csv content. Defined below.
     */
    @JvmName("uxhsssdykmwcdloo")
    public suspend fun csvClassifier(`value`: Output<ClassifierCsvClassifierArgs>) {
        this.csvClassifier = value
    }

    /**
     * @param value A classifier that uses grok patterns. Defined below.
     */
    @JvmName("mobuotcimfcijqmg")
    public suspend fun grokClassifier(`value`: Output<ClassifierGrokClassifierArgs>) {
        this.grokClassifier = value
    }

    /**
     * @param value A classifier for JSON content. Defined below.
     */
    @JvmName("oepfnriusyjihaak")
    public suspend fun jsonClassifier(`value`: Output<ClassifierJsonClassifierArgs>) {
        this.jsonClassifier = value
    }

    /**
     * @param value The name of the classifier.
     */
    @JvmName("iaromfovirnjllac")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A classifier for XML content. Defined below.
     */
    @JvmName("cxpvpkgqyguwdyfr")
    public suspend fun xmlClassifier(`value`: Output<ClassifierXmlClassifierArgs>) {
        this.xmlClassifier = value
    }

    /**
     * @param value A classifier for Csv content. Defined below.
     */
    @JvmName("hqnnxlnntehamdey")
    public suspend fun csvClassifier(`value`: ClassifierCsvClassifierArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvClassifier = mapped
    }

    /**
     * @param argument A classifier for Csv content. Defined below.
     */
    @JvmName("gihwhisvnyoyifgf")
    public suspend
    fun csvClassifier(argument: suspend ClassifierCsvClassifierArgsBuilder.() -> Unit) {
        val toBeMapped = ClassifierCsvClassifierArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.csvClassifier = mapped
    }

    /**
     * @param value A classifier that uses grok patterns. Defined below.
     */
    @JvmName("qkhnpftdbxoikoog")
    public suspend fun grokClassifier(`value`: ClassifierGrokClassifierArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grokClassifier = mapped
    }

    /**
     * @param argument A classifier that uses grok patterns. Defined below.
     */
    @JvmName("xytchkdjnrxjbdpe")
    public suspend
    fun grokClassifier(argument: suspend ClassifierGrokClassifierArgsBuilder.() -> Unit) {
        val toBeMapped = ClassifierGrokClassifierArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.grokClassifier = mapped
    }

    /**
     * @param value A classifier for JSON content. Defined below.
     */
    @JvmName("acesfakjfmweyovm")
    public suspend fun jsonClassifier(`value`: ClassifierJsonClassifierArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonClassifier = mapped
    }

    /**
     * @param argument A classifier for JSON content. Defined below.
     */
    @JvmName("ximiatiowsoucwdq")
    public suspend
    fun jsonClassifier(argument: suspend ClassifierJsonClassifierArgsBuilder.() -> Unit) {
        val toBeMapped = ClassifierJsonClassifierArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.jsonClassifier = mapped
    }

    /**
     * @param value The name of the classifier.
     */
    @JvmName("gtmewwmdvrngpvxg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A classifier for XML content. Defined below.
     */
    @JvmName("qvuiyxsxdjyahbye")
    public suspend fun xmlClassifier(`value`: ClassifierXmlClassifierArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xmlClassifier = mapped
    }

    /**
     * @param argument A classifier for XML content. Defined below.
     */
    @JvmName("ayjlieawqbetrinl")
    public suspend
    fun xmlClassifier(argument: suspend ClassifierXmlClassifierArgsBuilder.() -> Unit) {
        val toBeMapped = ClassifierXmlClassifierArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.xmlClassifier = mapped
    }

    internal fun build(): ClassifierArgs = ClassifierArgs(
        csvClassifier = csvClassifier,
        grokClassifier = grokClassifier,
        jsonClassifier = jsonClassifier,
        name = name,
        xmlClassifier = xmlClassifier,
    )
}
