@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.kotlin.outputs.ConnectionPhysicalConnectionRequirements
import com.pulumi.aws.glue.kotlin.outputs.ConnectionPhysicalConnectionRequirements.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Connection].
 */
@PulumiTagMarker
public class ConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectionArgs = ConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectionArgsBuilder.() -> Unit) {
        val builder = ConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Connection {
        val builtJavaResource = com.pulumi.aws.glue.Connection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Connection(builtJavaResource)
    }
}

/**
 * Provides a Glue Connection resource.
 * ## Example Usage
 * ### Non-VPC Connection
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Connection;
 * import com.pulumi.aws.glue.ConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connection("example", ConnectionArgs.builder()
 *             .connectionProperties(Map.ofEntries(
 *                 Map.entry("JDBC_CONNECTION_URL", "jdbc:mysql://example.com/exampledatabase"),
 *                 Map.entry("PASSWORD", "examplepassword"),
 *                 Map.entry("USERNAME", "exampleusername")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### VPC Connection
 * For more information, see the [AWS Documentation](https://docs.aws.amazon.com/glue/latest/dg/populate-add-connection.html#connection-JDBC-VPC).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Connection;
 * import com.pulumi.aws.glue.ConnectionArgs;
 * import com.pulumi.aws.glue.inputs.ConnectionPhysicalConnectionRequirementsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connection("example", ConnectionArgs.builder()
 *             .connectionProperties(Map.ofEntries(
 *                 Map.entry("JDBC_CONNECTION_URL", String.format("jdbc:mysql://%s/exampledatabase", aws_rds_cluster.example().endpoint())),
 *                 Map.entry("PASSWORD", "examplepassword"),
 *                 Map.entry("USERNAME", "exampleusername")
 *             ))
 *             .physicalConnectionRequirements(ConnectionPhysicalConnectionRequirementsArgs.builder()
 *                 .availabilityZone(aws_subnet.example().availability_zone())
 *                 .securityGroupIdLists(aws_security_group.example().id())
 *                 .subnetId(aws_subnet.example().id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Connections using the `CATALOG-ID` (AWS account ID if not custom) and `NAME`. For example:
 * ```sh
 *  $ pulumi import aws:glue/connection:Connection MyConnection 123456789012:MyConnection
 * ```
 *
 */
public class Connection internal constructor(
    override val javaResource: com.pulumi.aws.glue.Connection,
) : KotlinCustomResource(javaResource, ConnectionMapper) {
    /**
     * The ARN of the Glue Connection.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ID of the Data Catalog in which to create the connection. If none is supplied, the AWS account ID is used by default.
     */
    public val catalogId: Output<String>
        get() = javaResource.catalogId().applyValue({ args0 -> args0 })

    /**
     * A map of key-value pairs used as parameters for this connection.
     */
    public val connectionProperties: Output<Map<String, String>>?
        get() = javaResource.connectionProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the connection. Supported are: `CUSTOM`, `JDBC`, `KAFKA`, `MARKETPLACE`, `MONGODB`, and `NETWORK`. Defaults to `JDBC`.
     */
    public val connectionType: Output<String>?
        get() = javaResource.connectionType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of the connection.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of criteria that can be used in selecting this connection.
     */
    public val matchCriterias: Output<List<String>>?
        get() = javaResource.matchCriterias().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The name of the connection.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of physical connection requirements, such as VPC and SecurityGroup. Defined below.
     */
    public val physicalConnectionRequirements: Output<ConnectionPhysicalConnectionRequirements>?
        get() = javaResource.physicalConnectionRequirements().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ConnectionMapper : ResourceMapper<Connection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glue.Connection::class == javaResource::class

    override fun map(javaResource: Resource): Connection = Connection(
        javaResource as
            com.pulumi.aws.glue.Connection,
    )
}

/**
 * @see [Connection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Connection].
 */
public suspend fun connection(name: String, block: suspend ConnectionResourceBuilder.() -> Unit):
    Connection {
    val builder = ConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Connection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connection(name: String): Connection {
    val builder = ConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
