@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.ConnectionArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.ConnectionPhysicalConnectionRequirementsArgs
import com.pulumi.aws.glue.kotlin.inputs.ConnectionPhysicalConnectionRequirementsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Glue Connection resource.
 * ## Example Usage
 * ### Non-VPC Connection
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Connection;
 * import com.pulumi.aws.glue.ConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connection("example", ConnectionArgs.builder()
 *             .connectionProperties(Map.ofEntries(
 *                 Map.entry("JDBC_CONNECTION_URL", "jdbc:mysql://example.com/exampledatabase"),
 *                 Map.entry("PASSWORD", "examplepassword"),
 *                 Map.entry("USERNAME", "exampleusername")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### VPC Connection
 * For more information, see the [AWS Documentation](https://docs.aws.amazon.com/glue/latest/dg/populate-add-connection.html#connection-JDBC-VPC).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Connection;
 * import com.pulumi.aws.glue.ConnectionArgs;
 * import com.pulumi.aws.glue.inputs.ConnectionPhysicalConnectionRequirementsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connection("example", ConnectionArgs.builder()
 *             .connectionProperties(Map.ofEntries(
 *                 Map.entry("JDBC_CONNECTION_URL", String.format("jdbc:mysql://%s/exampledatabase", aws_rds_cluster.example().endpoint())),
 *                 Map.entry("PASSWORD", "examplepassword"),
 *                 Map.entry("USERNAME", "exampleusername")
 *             ))
 *             .physicalConnectionRequirements(ConnectionPhysicalConnectionRequirementsArgs.builder()
 *                 .availabilityZone(aws_subnet.example().availability_zone())
 *                 .securityGroupIdLists(aws_security_group.example().id())
 *                 .subnetId(aws_subnet.example().id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Connections using the `CATALOG-ID` (AWS account ID if not custom) and `NAME`. For example:
 * ```sh
 *  $ pulumi import aws:glue/connection:Connection MyConnection 123456789012:MyConnection
 * ```
 * @property catalogId The ID of the Data Catalog in which to create the connection. If none is supplied, the AWS account ID is used by default.
 * @property connectionProperties A map of key-value pairs used as parameters for this connection.
 * @property connectionType The type of the connection. Supported are: `CUSTOM`, `JDBC`, `KAFKA`, `MARKETPLACE`, `MONGODB`, and `NETWORK`. Defaults to `JDBC`.
 * @property description Description of the connection.
 * @property matchCriterias A list of criteria that can be used in selecting this connection.
 * @property name The name of the connection.
 * @property physicalConnectionRequirements A map of physical connection requirements, such as VPC and SecurityGroup. Defined below.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ConnectionArgs(
    public val catalogId: Output<String>? = null,
    public val connectionProperties: Output<Map<String, String>>? = null,
    public val connectionType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val matchCriterias: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val physicalConnectionRequirements: Output<ConnectionPhysicalConnectionRequirementsArgs>? =
        null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.ConnectionArgs> {
    override fun toJava(): com.pulumi.aws.glue.ConnectionArgs =
        com.pulumi.aws.glue.ConnectionArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .connectionProperties(
                connectionProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .connectionType(connectionType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .matchCriterias(matchCriterias?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .physicalConnectionRequirements(
                physicalConnectionRequirements?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConnectionArgs].
 */
@PulumiTagMarker
public class ConnectionArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var connectionProperties: Output<Map<String, String>>? = null

    private var connectionType: Output<String>? = null

    private var description: Output<String>? = null

    private var matchCriterias: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var physicalConnectionRequirements: Output<ConnectionPhysicalConnectionRequirementsArgs>? =
        null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The ID of the Data Catalog in which to create the connection. If none is supplied, the AWS account ID is used by default.
     */
    @JvmName("btscjmgmlhvljxwq")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value A map of key-value pairs used as parameters for this connection.
     */
    @JvmName("cggjutwusmiirspm")
    public suspend fun connectionProperties(`value`: Output<Map<String, String>>) {
        this.connectionProperties = value
    }

    /**
     * @param value The type of the connection. Supported are: `CUSTOM`, `JDBC`, `KAFKA`, `MARKETPLACE`, `MONGODB`, and `NETWORK`. Defaults to `JDBC`.
     */
    @JvmName("dmwkkxaluagrljnd")
    public suspend fun connectionType(`value`: Output<String>) {
        this.connectionType = value
    }

    /**
     * @param value Description of the connection.
     */
    @JvmName("cxbrenmglpibktiv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A list of criteria that can be used in selecting this connection.
     */
    @JvmName("dcncvricwujxskys")
    public suspend fun matchCriterias(`value`: Output<List<String>>) {
        this.matchCriterias = value
    }

    @JvmName("somofbhvplyonkte")
    public suspend fun matchCriterias(vararg values: Output<String>) {
        this.matchCriterias = Output.all(values.asList())
    }

    /**
     * @param values A list of criteria that can be used in selecting this connection.
     */
    @JvmName("hgylvtvigcvuxhoh")
    public suspend fun matchCriterias(values: List<Output<String>>) {
        this.matchCriterias = Output.all(values)
    }

    /**
     * @param value The name of the connection.
     */
    @JvmName("yrlsqgupifggmegw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of physical connection requirements, such as VPC and SecurityGroup. Defined below.
     */
    @JvmName("ubxdqxhnpqcurgix")
    public suspend
    fun physicalConnectionRequirements(`value`: Output<ConnectionPhysicalConnectionRequirementsArgs>) {
        this.physicalConnectionRequirements = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sohfhkfepsjcncsm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the Data Catalog in which to create the connection. If none is supplied, the AWS account ID is used by default.
     */
    @JvmName("jgcdhnormnndrnvl")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value A map of key-value pairs used as parameters for this connection.
     */
    @JvmName("pipwiweunqnpikqa")
    public suspend fun connectionProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionProperties = mapped
    }

    /**
     * @param values A map of key-value pairs used as parameters for this connection.
     */
    @JvmName("djqxaqhkyaqnivux")
    public fun connectionProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionProperties = mapped
    }

    /**
     * @param value The type of the connection. Supported are: `CUSTOM`, `JDBC`, `KAFKA`, `MARKETPLACE`, `MONGODB`, and `NETWORK`. Defaults to `JDBC`.
     */
    @JvmName("lsmmjhjosjkojikj")
    public suspend fun connectionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionType = mapped
    }

    /**
     * @param value Description of the connection.
     */
    @JvmName("msgngwdvhukcgslf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A list of criteria that can be used in selecting this connection.
     */
    @JvmName("ivdqdcnltueljxxb")
    public suspend fun matchCriterias(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchCriterias = mapped
    }

    /**
     * @param values A list of criteria that can be used in selecting this connection.
     */
    @JvmName("rxncghchnvcovdaj")
    public suspend fun matchCriterias(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchCriterias = mapped
    }

    /**
     * @param value The name of the connection.
     */
    @JvmName("ylblsyweawchqyeg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of physical connection requirements, such as VPC and SecurityGroup. Defined below.
     */
    @JvmName("gpnfedrwkqdyyrhs")
    public suspend
    fun physicalConnectionRequirements(`value`: ConnectionPhysicalConnectionRequirementsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.physicalConnectionRequirements = mapped
    }

    /**
     * @param argument A map of physical connection requirements, such as VPC and SecurityGroup. Defined below.
     */
    @JvmName("atnuefnvyvusrudo")
    public suspend
    fun physicalConnectionRequirements(argument: suspend ConnectionPhysicalConnectionRequirementsArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionPhysicalConnectionRequirementsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.physicalConnectionRequirements = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eitkqhdckvualcej")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("igxvvvfjbsfbmerk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConnectionArgs = ConnectionArgs(
        catalogId = catalogId,
        connectionProperties = connectionProperties,
        connectionType = connectionType,
        description = description,
        matchCriterias = matchCriterias,
        name = name,
        physicalConnectionRequirements = physicalConnectionRequirements,
        tags = tags,
    )
}
