@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.CrawlerArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerCatalogTargetArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerCatalogTargetArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerDeltaTargetArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerDeltaTargetArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerDynamodbTargetArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerDynamodbTargetArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerHudiTargetArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerHudiTargetArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerIcebergTargetArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerIcebergTargetArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerJdbcTargetArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerJdbcTargetArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerLakeFormationConfigurationArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerLakeFormationConfigurationArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerLineageConfigurationArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerLineageConfigurationArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerMongodbTargetArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerMongodbTargetArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerRecrawlPolicyArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerRecrawlPolicyArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerS3TargetArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerS3TargetArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerSchemaChangePolicyArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerSchemaChangePolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a Glue Crawler. More information can be found in the [AWS Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html)
 * ## Example Usage
 * ### DynamoDB Target Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Crawler;
 * import com.pulumi.aws.glue.CrawlerArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerDynamodbTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Crawler("example", CrawlerArgs.builder()
 *             .databaseName(aws_glue_catalog_database.example().name())
 *             .role(aws_iam_role.example().arn())
 *             .dynamodbTargets(CrawlerDynamodbTargetArgs.builder()
 *                 .path("table-name")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### JDBC Target Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Crawler;
 * import com.pulumi.aws.glue.CrawlerArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerJdbcTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Crawler("example", CrawlerArgs.builder()
 *             .databaseName(aws_glue_catalog_database.example().name())
 *             .role(aws_iam_role.example().arn())
 *             .jdbcTargets(CrawlerJdbcTargetArgs.builder()
 *                 .connectionName(aws_glue_connection.example().name())
 *                 .path("database-name/%")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### S3 Target Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Crawler;
 * import com.pulumi.aws.glue.CrawlerArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerS3TargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Crawler("example", CrawlerArgs.builder()
 *             .databaseName(aws_glue_catalog_database.example().name())
 *             .role(aws_iam_role.example().arn())
 *             .s3Targets(CrawlerS3TargetArgs.builder()
 *                 .path(String.format("s3://%s", aws_s3_bucket.example().bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Catalog Target Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Crawler;
 * import com.pulumi.aws.glue.CrawlerArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerCatalogTargetArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerSchemaChangePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Crawler("example", CrawlerArgs.builder()
 *             .databaseName(aws_glue_catalog_database.example().name())
 *             .role(aws_iam_role.example().arn())
 *             .catalogTargets(CrawlerCatalogTargetArgs.builder()
 *                 .databaseName(aws_glue_catalog_database.example().name())
 *                 .tables(aws_glue_catalog_table.example().name())
 *                 .build())
 *             .schemaChangePolicy(CrawlerSchemaChangePolicyArgs.builder()
 *                 .deleteBehavior("LOG")
 *                 .build())
 *             .configuration("""
 * {
 *   "Version":1.0,
 *   "Grouping": {
 *     "TableGroupingPolicy": "CombineCompatibleSchemas"
 *   }
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ### MongoDB Target Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Crawler;
 * import com.pulumi.aws.glue.CrawlerArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerMongodbTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Crawler("example", CrawlerArgs.builder()
 *             .databaseName(aws_glue_catalog_database.example().name())
 *             .role(aws_iam_role.example().arn())
 *             .mongodbTargets(CrawlerMongodbTargetArgs.builder()
 *                 .connectionName(aws_glue_connection.example().name())
 *                 .path("database-name/%")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Configuration Settings Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Crawler;
 * import com.pulumi.aws.glue.CrawlerArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerS3TargetArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventsCrawler = new Crawler("eventsCrawler", CrawlerArgs.builder()
 *             .databaseName(aws_glue_catalog_database.glue_database().name())
 *             .schedule("cron(0 1 * * ? *)")
 *             .role(aws_iam_role.glue_role().arn())
 *             .tags(var_.tags())
 *             .configuration(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Grouping", jsonObject(
 *                         jsonProperty("TableGroupingPolicy", "CombineCompatibleSchemas")
 *                     )),
 *                     jsonProperty("CrawlerOutput", jsonObject(
 *                         jsonProperty("Partitions", jsonObject(
 *                             jsonProperty("AddOrUpdateBehavior", "InheritFromTable")
 *                         ))
 *                     )),
 *                     jsonProperty("Version", 1)
 *                 )))
 *             .s3Targets(CrawlerS3TargetArgs.builder()
 *                 .path(String.format("s3://%s", aws_s3_bucket.data_lake_bucket().bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Crawlers using `name`. For example:
 * ```sh
 *  $ pulumi import aws:glue/crawler:Crawler MyJob MyJob
 * ```
 * @property catalogTargets List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
 * @property classifiers List of custom classifiers. By default, all AWS classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.
 * @property configuration JSON string of configuration information. For more details see [Setting Crawler Configuration Options](https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
 * @property databaseName Glue database where results are written.
 * @property deltaTargets List of nested Delta Lake target arguments. See Delta Target below.
 * @property description Description of the crawler.
 * @property dynamodbTargets List of nested DynamoDB target arguments. See Dynamodb Target below.
 * @property hudiTargets List of nested Hudi target arguments. See Iceberg Target below.
 * @property icebergTargets List of nested Iceberg target arguments. See Iceberg Target below.
 * @property jdbcTargets List of nested JDBC target arguments. See JDBC Target below.
 * @property lakeFormationConfiguration Specifies Lake Formation configuration settings for the crawler. See Lake Formation Configuration below.
 * @property lineageConfiguration Specifies data lineage configuration settings for the crawler. See Lineage Configuration below.
 * @property mongodbTargets List of nested MongoDB target arguments. See MongoDB Target below.
 * @property name Name of the crawler.
 * @property recrawlPolicy A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.. See Recrawl Policy below.
 * @property role The IAM role friendly name (including path without leading slash), or ARN of an IAM role, used by the crawler to access other resources.
 * @property s3Targets List of nested Amazon S3 target arguments. See S3 Target below.
 * @property schedule A cron expression used to specify the schedule. For more information, see [Time-Based Schedules for Jobs and Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html). For example, to run something every day at 12:15 UTC, you would specify: `cron(15 12 * * ? *)`.
 * @property schemaChangePolicy Policy for the crawler's update and deletion behavior. See Schema Change Policy below.
 * @property securityConfiguration The name of Security Configuration to be used by the crawler
 * @property tablePrefix The table prefix used for catalog tables that are created.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CrawlerArgs(
    public val catalogTargets: Output<List<CrawlerCatalogTargetArgs>>? = null,
    public val classifiers: Output<List<String>>? = null,
    public val configuration: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val deltaTargets: Output<List<CrawlerDeltaTargetArgs>>? = null,
    public val description: Output<String>? = null,
    public val dynamodbTargets: Output<List<CrawlerDynamodbTargetArgs>>? = null,
    public val hudiTargets: Output<List<CrawlerHudiTargetArgs>>? = null,
    public val icebergTargets: Output<List<CrawlerIcebergTargetArgs>>? = null,
    public val jdbcTargets: Output<List<CrawlerJdbcTargetArgs>>? = null,
    public val lakeFormationConfiguration: Output<CrawlerLakeFormationConfigurationArgs>? = null,
    public val lineageConfiguration: Output<CrawlerLineageConfigurationArgs>? = null,
    public val mongodbTargets: Output<List<CrawlerMongodbTargetArgs>>? = null,
    public val name: Output<String>? = null,
    public val recrawlPolicy: Output<CrawlerRecrawlPolicyArgs>? = null,
    public val role: Output<String>? = null,
    public val s3Targets: Output<List<CrawlerS3TargetArgs>>? = null,
    public val schedule: Output<String>? = null,
    public val schemaChangePolicy: Output<CrawlerSchemaChangePolicyArgs>? = null,
    public val securityConfiguration: Output<String>? = null,
    public val tablePrefix: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.CrawlerArgs> {
    override fun toJava(): com.pulumi.aws.glue.CrawlerArgs = com.pulumi.aws.glue.CrawlerArgs.builder()
        .catalogTargets(
            catalogTargets?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .classifiers(classifiers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .configuration(configuration?.applyValue({ args0 -> args0 }))
        .databaseName(databaseName?.applyValue({ args0 -> args0 }))
        .deltaTargets(
            deltaTargets?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .description(description?.applyValue({ args0 -> args0 }))
        .dynamodbTargets(
            dynamodbTargets?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .hudiTargets(
            hudiTargets?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .icebergTargets(
            icebergTargets?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .jdbcTargets(
            jdbcTargets?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .lakeFormationConfiguration(
            lakeFormationConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .lineageConfiguration(
            lineageConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .mongodbTargets(
            mongodbTargets?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .name(name?.applyValue({ args0 -> args0 }))
        .recrawlPolicy(recrawlPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .role(role?.applyValue({ args0 -> args0 }))
        .s3Targets(
            s3Targets?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .schedule(schedule?.applyValue({ args0 -> args0 }))
        .schemaChangePolicy(
            schemaChangePolicy?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .securityConfiguration(securityConfiguration?.applyValue({ args0 -> args0 }))
        .tablePrefix(tablePrefix?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [CrawlerArgs].
 */
@PulumiTagMarker
public class CrawlerArgsBuilder internal constructor() {
    private var catalogTargets: Output<List<CrawlerCatalogTargetArgs>>? = null

    private var classifiers: Output<List<String>>? = null

    private var configuration: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var deltaTargets: Output<List<CrawlerDeltaTargetArgs>>? = null

    private var description: Output<String>? = null

    private var dynamodbTargets: Output<List<CrawlerDynamodbTargetArgs>>? = null

    private var hudiTargets: Output<List<CrawlerHudiTargetArgs>>? = null

    private var icebergTargets: Output<List<CrawlerIcebergTargetArgs>>? = null

    private var jdbcTargets: Output<List<CrawlerJdbcTargetArgs>>? = null

    private var lakeFormationConfiguration: Output<CrawlerLakeFormationConfigurationArgs>? = null

    private var lineageConfiguration: Output<CrawlerLineageConfigurationArgs>? = null

    private var mongodbTargets: Output<List<CrawlerMongodbTargetArgs>>? = null

    private var name: Output<String>? = null

    private var recrawlPolicy: Output<CrawlerRecrawlPolicyArgs>? = null

    private var role: Output<String>? = null

    private var s3Targets: Output<List<CrawlerS3TargetArgs>>? = null

    private var schedule: Output<String>? = null

    private var schemaChangePolicy: Output<CrawlerSchemaChangePolicyArgs>? = null

    private var securityConfiguration: Output<String>? = null

    private var tablePrefix: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
     */
    @JvmName("htudkgamlhiqjgoj")
    public suspend fun catalogTargets(`value`: Output<List<CrawlerCatalogTargetArgs>>) {
        this.catalogTargets = value
    }

    @JvmName("ljtmdjlwelwtgiqx")
    public suspend fun catalogTargets(vararg values: Output<CrawlerCatalogTargetArgs>) {
        this.catalogTargets = Output.all(values.asList())
    }

    /**
     * @param values List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
     */
    @JvmName("fgnnsgrfutpqwnfw")
    public suspend fun catalogTargets(values: List<Output<CrawlerCatalogTargetArgs>>) {
        this.catalogTargets = Output.all(values)
    }

    /**
     * @param value List of custom classifiers. By default, all AWS classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.
     */
    @JvmName("wdoxhtkrteobccbn")
    public suspend fun classifiers(`value`: Output<List<String>>) {
        this.classifiers = value
    }

    @JvmName("vbhyuotcbwlrkdgt")
    public suspend fun classifiers(vararg values: Output<String>) {
        this.classifiers = Output.all(values.asList())
    }

    /**
     * @param values List of custom classifiers. By default, all AWS classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.
     */
    @JvmName("wptcmybqkepckuko")
    public suspend fun classifiers(values: List<Output<String>>) {
        this.classifiers = Output.all(values)
    }

    /**
     * @param value JSON string of configuration information. For more details see [Setting Crawler Configuration Options](https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
     */
    @JvmName("pnfwbnajktxtbxyd")
    public suspend fun configuration(`value`: Output<String>) {
        this.configuration = value
    }

    /**
     * @param value Glue database where results are written.
     */
    @JvmName("emxlwgmccoleugyc")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value List of nested Delta Lake target arguments. See Delta Target below.
     */
    @JvmName("cyjuvunehkqdktjv")
    public suspend fun deltaTargets(`value`: Output<List<CrawlerDeltaTargetArgs>>) {
        this.deltaTargets = value
    }

    @JvmName("jkipyfpbycstqmef")
    public suspend fun deltaTargets(vararg values: Output<CrawlerDeltaTargetArgs>) {
        this.deltaTargets = Output.all(values.asList())
    }

    /**
     * @param values List of nested Delta Lake target arguments. See Delta Target below.
     */
    @JvmName("asvqgifaroyygwds")
    public suspend fun deltaTargets(values: List<Output<CrawlerDeltaTargetArgs>>) {
        this.deltaTargets = Output.all(values)
    }

    /**
     * @param value Description of the crawler.
     */
    @JvmName("hyyfblynohlhwwqf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of nested DynamoDB target arguments. See Dynamodb Target below.
     */
    @JvmName("epjdsmxgtvisevhi")
    public suspend fun dynamodbTargets(`value`: Output<List<CrawlerDynamodbTargetArgs>>) {
        this.dynamodbTargets = value
    }

    @JvmName("rrlagesduaakosfb")
    public suspend fun dynamodbTargets(vararg values: Output<CrawlerDynamodbTargetArgs>) {
        this.dynamodbTargets = Output.all(values.asList())
    }

    /**
     * @param values List of nested DynamoDB target arguments. See Dynamodb Target below.
     */
    @JvmName("toqvbbthmxjsihai")
    public suspend fun dynamodbTargets(values: List<Output<CrawlerDynamodbTargetArgs>>) {
        this.dynamodbTargets = Output.all(values)
    }

    /**
     * @param value List of nested Hudi target arguments. See Iceberg Target below.
     */
    @JvmName("suwoyhuqjrholffy")
    public suspend fun hudiTargets(`value`: Output<List<CrawlerHudiTargetArgs>>) {
        this.hudiTargets = value
    }

    @JvmName("unxgbhpnfvwbhhdc")
    public suspend fun hudiTargets(vararg values: Output<CrawlerHudiTargetArgs>) {
        this.hudiTargets = Output.all(values.asList())
    }

    /**
     * @param values List of nested Hudi target arguments. See Iceberg Target below.
     */
    @JvmName("oyyjtykkxkppohwa")
    public suspend fun hudiTargets(values: List<Output<CrawlerHudiTargetArgs>>) {
        this.hudiTargets = Output.all(values)
    }

    /**
     * @param value List of nested Iceberg target arguments. See Iceberg Target below.
     */
    @JvmName("qnulcrtvmvbriqkb")
    public suspend fun icebergTargets(`value`: Output<List<CrawlerIcebergTargetArgs>>) {
        this.icebergTargets = value
    }

    @JvmName("dqpgssmsvwqlyeeb")
    public suspend fun icebergTargets(vararg values: Output<CrawlerIcebergTargetArgs>) {
        this.icebergTargets = Output.all(values.asList())
    }

    /**
     * @param values List of nested Iceberg target arguments. See Iceberg Target below.
     */
    @JvmName("ichpxkepwmuhgssb")
    public suspend fun icebergTargets(values: List<Output<CrawlerIcebergTargetArgs>>) {
        this.icebergTargets = Output.all(values)
    }

    /**
     * @param value List of nested JDBC target arguments. See JDBC Target below.
     */
    @JvmName("dgqjqucrmaegffom")
    public suspend fun jdbcTargets(`value`: Output<List<CrawlerJdbcTargetArgs>>) {
        this.jdbcTargets = value
    }

    @JvmName("grkhvvnqdcajsgyv")
    public suspend fun jdbcTargets(vararg values: Output<CrawlerJdbcTargetArgs>) {
        this.jdbcTargets = Output.all(values.asList())
    }

    /**
     * @param values List of nested JDBC target arguments. See JDBC Target below.
     */
    @JvmName("kelxrkofworsslbb")
    public suspend fun jdbcTargets(values: List<Output<CrawlerJdbcTargetArgs>>) {
        this.jdbcTargets = Output.all(values)
    }

    /**
     * @param value Specifies Lake Formation configuration settings for the crawler. See Lake Formation Configuration below.
     */
    @JvmName("lesiqiffnrkwkkud")
    public suspend
    fun lakeFormationConfiguration(`value`: Output<CrawlerLakeFormationConfigurationArgs>) {
        this.lakeFormationConfiguration = value
    }

    /**
     * @param value Specifies data lineage configuration settings for the crawler. See Lineage Configuration below.
     */
    @JvmName("wcwlcltdwmtowtci")
    public suspend fun lineageConfiguration(`value`: Output<CrawlerLineageConfigurationArgs>) {
        this.lineageConfiguration = value
    }

    /**
     * @param value List of nested MongoDB target arguments. See MongoDB Target below.
     */
    @JvmName("tgitvisgvbhmmmon")
    public suspend fun mongodbTargets(`value`: Output<List<CrawlerMongodbTargetArgs>>) {
        this.mongodbTargets = value
    }

    @JvmName("uobhhffubylojytx")
    public suspend fun mongodbTargets(vararg values: Output<CrawlerMongodbTargetArgs>) {
        this.mongodbTargets = Output.all(values.asList())
    }

    /**
     * @param values List of nested MongoDB target arguments. See MongoDB Target below.
     */
    @JvmName("gdiswhpcyuopfmdy")
    public suspend fun mongodbTargets(values: List<Output<CrawlerMongodbTargetArgs>>) {
        this.mongodbTargets = Output.all(values)
    }

    /**
     * @param value Name of the crawler.
     */
    @JvmName("clxkfjtuwscebyai")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.. See Recrawl Policy below.
     */
    @JvmName("rcvsvmlpdjnsrnom")
    public suspend fun recrawlPolicy(`value`: Output<CrawlerRecrawlPolicyArgs>) {
        this.recrawlPolicy = value
    }

    /**
     * @param value The IAM role friendly name (including path without leading slash), or ARN of an IAM role, used by the crawler to access other resources.
     */
    @JvmName("dbqbtuidsftvpihf")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value List of nested Amazon S3 target arguments. See S3 Target below.
     */
    @JvmName("gtyseknpxvcqjakq")
    public suspend fun s3Targets(`value`: Output<List<CrawlerS3TargetArgs>>) {
        this.s3Targets = value
    }

    @JvmName("wxblajjsmnsxmsqf")
    public suspend fun s3Targets(vararg values: Output<CrawlerS3TargetArgs>) {
        this.s3Targets = Output.all(values.asList())
    }

    /**
     * @param values List of nested Amazon S3 target arguments. See S3 Target below.
     */
    @JvmName("rfbrlxttwcocofyu")
    public suspend fun s3Targets(values: List<Output<CrawlerS3TargetArgs>>) {
        this.s3Targets = Output.all(values)
    }

    /**
     * @param value A cron expression used to specify the schedule. For more information, see [Time-Based Schedules for Jobs and Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html). For example, to run something every day at 12:15 UTC, you would specify: `cron(15 12 * * ? *)`.
     */
    @JvmName("mkombhdircmwwpix")
    public suspend fun schedule(`value`: Output<String>) {
        this.schedule = value
    }

    /**
     * @param value Policy for the crawler's update and deletion behavior. See Schema Change Policy below.
     */
    @JvmName("jclxokatvsrkldcd")
    public suspend fun schemaChangePolicy(`value`: Output<CrawlerSchemaChangePolicyArgs>) {
        this.schemaChangePolicy = value
    }

    /**
     * @param value The name of Security Configuration to be used by the crawler
     */
    @JvmName("flavbnraykhwufor")
    public suspend fun securityConfiguration(`value`: Output<String>) {
        this.securityConfiguration = value
    }

    /**
     * @param value The table prefix used for catalog tables that are created.
     */
    @JvmName("mnjjseesuqdynclm")
    public suspend fun tablePrefix(`value`: Output<String>) {
        this.tablePrefix = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dqbcirydbbspxwvq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
     */
    @JvmName("kdvpyqdkbjcrjsan")
    public suspend fun catalogTargets(`value`: List<CrawlerCatalogTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogTargets = mapped
    }

    /**
     * @param argument List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
     */
    @JvmName("ioprrokjntobphnp")
    public suspend
    fun catalogTargets(argument: List<suspend CrawlerCatalogTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CrawlerCatalogTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.catalogTargets = mapped
    }

    /**
     * @param argument List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
     */
    @JvmName("ylxypvctyxqcxxvm")
    public suspend fun catalogTargets(
        vararg
        argument: suspend CrawlerCatalogTargetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CrawlerCatalogTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.catalogTargets = mapped
    }

    /**
     * @param argument List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
     */
    @JvmName("gsobemabqmrvleri")
    public suspend fun catalogTargets(argument: suspend CrawlerCatalogTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CrawlerCatalogTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.catalogTargets = mapped
    }

    /**
     * @param values List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
     */
    @JvmName("ehwdkbprtkfhkaba")
    public suspend fun catalogTargets(vararg values: CrawlerCatalogTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.catalogTargets = mapped
    }

    /**
     * @param value List of custom classifiers. By default, all AWS classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.
     */
    @JvmName("rpgrhqjpdypiuxws")
    public suspend fun classifiers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.classifiers = mapped
    }

    /**
     * @param values List of custom classifiers. By default, all AWS classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.
     */
    @JvmName("gqcjcaikvnpxceta")
    public suspend fun classifiers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.classifiers = mapped
    }

    /**
     * @param value JSON string of configuration information. For more details see [Setting Crawler Configuration Options](https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
     */
    @JvmName("vrpcpthbcpwemaco")
    public suspend fun configuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param value Glue database where results are written.
     */
    @JvmName("ysmqrfthodvbvacd")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value List of nested Delta Lake target arguments. See Delta Target below.
     */
    @JvmName("jsvrhpbxbigucxnc")
    public suspend fun deltaTargets(`value`: List<CrawlerDeltaTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deltaTargets = mapped
    }

    /**
     * @param argument List of nested Delta Lake target arguments. See Delta Target below.
     */
    @JvmName("gdtovmjusyqidtum")
    public suspend
    fun deltaTargets(argument: List<suspend CrawlerDeltaTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CrawlerDeltaTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.deltaTargets = mapped
    }

    /**
     * @param argument List of nested Delta Lake target arguments. See Delta Target below.
     */
    @JvmName("nwckwirkvucyemnt")
    public suspend fun deltaTargets(
        vararg
        argument: suspend CrawlerDeltaTargetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CrawlerDeltaTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.deltaTargets = mapped
    }

    /**
     * @param argument List of nested Delta Lake target arguments. See Delta Target below.
     */
    @JvmName("cgygwjdfigptjjme")
    public suspend fun deltaTargets(argument: suspend CrawlerDeltaTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CrawlerDeltaTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.deltaTargets = mapped
    }

    /**
     * @param values List of nested Delta Lake target arguments. See Delta Target below.
     */
    @JvmName("fqwjycjsixswllmi")
    public suspend fun deltaTargets(vararg values: CrawlerDeltaTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deltaTargets = mapped
    }

    /**
     * @param value Description of the crawler.
     */
    @JvmName("bammygoqnubnmklo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of nested DynamoDB target arguments. See Dynamodb Target below.
     */
    @JvmName("rrkyafaexogchsrg")
    public suspend fun dynamodbTargets(`value`: List<CrawlerDynamodbTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamodbTargets = mapped
    }

    /**
     * @param argument List of nested DynamoDB target arguments. See Dynamodb Target below.
     */
    @JvmName("tayudyxahwqlhdsq")
    public suspend
    fun dynamodbTargets(argument: List<suspend CrawlerDynamodbTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CrawlerDynamodbTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dynamodbTargets = mapped
    }

    /**
     * @param argument List of nested DynamoDB target arguments. See Dynamodb Target below.
     */
    @JvmName("iuehxjlcnencgqfq")
    public suspend fun dynamodbTargets(
        vararg
        argument: suspend CrawlerDynamodbTargetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CrawlerDynamodbTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dynamodbTargets = mapped
    }

    /**
     * @param argument List of nested DynamoDB target arguments. See Dynamodb Target below.
     */
    @JvmName("sujnxkdbksqqbplc")
    public suspend
    fun dynamodbTargets(argument: suspend CrawlerDynamodbTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CrawlerDynamodbTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dynamodbTargets = mapped
    }

    /**
     * @param values List of nested DynamoDB target arguments. See Dynamodb Target below.
     */
    @JvmName("bclxdwvhhkoynbsg")
    public suspend fun dynamodbTargets(vararg values: CrawlerDynamodbTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dynamodbTargets = mapped
    }

    /**
     * @param value List of nested Hudi target arguments. See Iceberg Target below.
     */
    @JvmName("dkhteiggngelsirw")
    public suspend fun hudiTargets(`value`: List<CrawlerHudiTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hudiTargets = mapped
    }

    /**
     * @param argument List of nested Hudi target arguments. See Iceberg Target below.
     */
    @JvmName("wwdocgyoovqrqjil")
    public suspend fun hudiTargets(argument: List<suspend CrawlerHudiTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CrawlerHudiTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.hudiTargets = mapped
    }

    /**
     * @param argument List of nested Hudi target arguments. See Iceberg Target below.
     */
    @JvmName("nnpcxpoothkhyvsv")
    public suspend fun hudiTargets(vararg argument: suspend CrawlerHudiTargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CrawlerHudiTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.hudiTargets = mapped
    }

    /**
     * @param argument List of nested Hudi target arguments. See Iceberg Target below.
     */
    @JvmName("kiuukqxnbrnbysjr")
    public suspend fun hudiTargets(argument: suspend CrawlerHudiTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CrawlerHudiTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.hudiTargets = mapped
    }

    /**
     * @param values List of nested Hudi target arguments. See Iceberg Target below.
     */
    @JvmName("nntbgiupdipvmqea")
    public suspend fun hudiTargets(vararg values: CrawlerHudiTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hudiTargets = mapped
    }

    /**
     * @param value List of nested Iceberg target arguments. See Iceberg Target below.
     */
    @JvmName("ddvmxwxlcgsajkel")
    public suspend fun icebergTargets(`value`: List<CrawlerIcebergTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.icebergTargets = mapped
    }

    /**
     * @param argument List of nested Iceberg target arguments. See Iceberg Target below.
     */
    @JvmName("vuyobrchmnrnmrnv")
    public suspend
    fun icebergTargets(argument: List<suspend CrawlerIcebergTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CrawlerIcebergTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.icebergTargets = mapped
    }

    /**
     * @param argument List of nested Iceberg target arguments. See Iceberg Target below.
     */
    @JvmName("piacqhftcmniieid")
    public suspend fun icebergTargets(
        vararg
        argument: suspend CrawlerIcebergTargetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CrawlerIcebergTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.icebergTargets = mapped
    }

    /**
     * @param argument List of nested Iceberg target arguments. See Iceberg Target below.
     */
    @JvmName("nfjjgoyuixgosxwp")
    public suspend fun icebergTargets(argument: suspend CrawlerIcebergTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CrawlerIcebergTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.icebergTargets = mapped
    }

    /**
     * @param values List of nested Iceberg target arguments. See Iceberg Target below.
     */
    @JvmName("guowgrtcogrnolim")
    public suspend fun icebergTargets(vararg values: CrawlerIcebergTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.icebergTargets = mapped
    }

    /**
     * @param value List of nested JDBC target arguments. See JDBC Target below.
     */
    @JvmName("kmlffunucucetccm")
    public suspend fun jdbcTargets(`value`: List<CrawlerJdbcTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jdbcTargets = mapped
    }

    /**
     * @param argument List of nested JDBC target arguments. See JDBC Target below.
     */
    @JvmName("ocgjatsluymegwhj")
    public suspend fun jdbcTargets(argument: List<suspend CrawlerJdbcTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CrawlerJdbcTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.jdbcTargets = mapped
    }

    /**
     * @param argument List of nested JDBC target arguments. See JDBC Target below.
     */
    @JvmName("eflajrswxsrmbosd")
    public suspend fun jdbcTargets(vararg argument: suspend CrawlerJdbcTargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CrawlerJdbcTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.jdbcTargets = mapped
    }

    /**
     * @param argument List of nested JDBC target arguments. See JDBC Target below.
     */
    @JvmName("elvovnscnfvevgjw")
    public suspend fun jdbcTargets(argument: suspend CrawlerJdbcTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CrawlerJdbcTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.jdbcTargets = mapped
    }

    /**
     * @param values List of nested JDBC target arguments. See JDBC Target below.
     */
    @JvmName("sjvpucaripyjwdoi")
    public suspend fun jdbcTargets(vararg values: CrawlerJdbcTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jdbcTargets = mapped
    }

    /**
     * @param value Specifies Lake Formation configuration settings for the crawler. See Lake Formation Configuration below.
     */
    @JvmName("mydvuyqnqsephqdt")
    public suspend fun lakeFormationConfiguration(`value`: CrawlerLakeFormationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lakeFormationConfiguration = mapped
    }

    /**
     * @param argument Specifies Lake Formation configuration settings for the crawler. See Lake Formation Configuration below.
     */
    @JvmName("tgvuqyirvfhbfaxk")
    public suspend
    fun lakeFormationConfiguration(argument: suspend CrawlerLakeFormationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CrawlerLakeFormationConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.lakeFormationConfiguration = mapped
    }

    /**
     * @param value Specifies data lineage configuration settings for the crawler. See Lineage Configuration below.
     */
    @JvmName("equxnnpbkfwyvorq")
    public suspend fun lineageConfiguration(`value`: CrawlerLineageConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lineageConfiguration = mapped
    }

    /**
     * @param argument Specifies data lineage configuration settings for the crawler. See Lineage Configuration below.
     */
    @JvmName("bxqxlwgybjdpmxjh")
    public suspend
    fun lineageConfiguration(argument: suspend CrawlerLineageConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CrawlerLineageConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.lineageConfiguration = mapped
    }

    /**
     * @param value List of nested MongoDB target arguments. See MongoDB Target below.
     */
    @JvmName("syoanjgffdhuywfc")
    public suspend fun mongodbTargets(`value`: List<CrawlerMongodbTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mongodbTargets = mapped
    }

    /**
     * @param argument List of nested MongoDB target arguments. See MongoDB Target below.
     */
    @JvmName("klqynhbufuowafxd")
    public suspend
    fun mongodbTargets(argument: List<suspend CrawlerMongodbTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CrawlerMongodbTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mongodbTargets = mapped
    }

    /**
     * @param argument List of nested MongoDB target arguments. See MongoDB Target below.
     */
    @JvmName("ioabpybubsakbsvw")
    public suspend fun mongodbTargets(
        vararg
        argument: suspend CrawlerMongodbTargetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CrawlerMongodbTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mongodbTargets = mapped
    }

    /**
     * @param argument List of nested MongoDB target arguments. See MongoDB Target below.
     */
    @JvmName("ffxhyojjgqycojii")
    public suspend fun mongodbTargets(argument: suspend CrawlerMongodbTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CrawlerMongodbTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.mongodbTargets = mapped
    }

    /**
     * @param values List of nested MongoDB target arguments. See MongoDB Target below.
     */
    @JvmName("cxhuisyfcwqksmnr")
    public suspend fun mongodbTargets(vararg values: CrawlerMongodbTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mongodbTargets = mapped
    }

    /**
     * @param value Name of the crawler.
     */
    @JvmName("idaybeihlvdysajc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.. See Recrawl Policy below.
     */
    @JvmName("gudwcerjlefbdkpy")
    public suspend fun recrawlPolicy(`value`: CrawlerRecrawlPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recrawlPolicy = mapped
    }

    /**
     * @param argument A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.. See Recrawl Policy below.
     */
    @JvmName("fedwjyapsnguulnh")
    public suspend fun recrawlPolicy(argument: suspend CrawlerRecrawlPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = CrawlerRecrawlPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.recrawlPolicy = mapped
    }

    /**
     * @param value The IAM role friendly name (including path without leading slash), or ARN of an IAM role, used by the crawler to access other resources.
     */
    @JvmName("qxgykbppwxnyxpqu")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value List of nested Amazon S3 target arguments. See S3 Target below.
     */
    @JvmName("ysgcpyiyiyyjwyld")
    public suspend fun s3Targets(`value`: List<CrawlerS3TargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Targets = mapped
    }

    /**
     * @param argument List of nested Amazon S3 target arguments. See S3 Target below.
     */
    @JvmName("dqgslgiipkdntjsb")
    public suspend fun s3Targets(argument: List<suspend CrawlerS3TargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CrawlerS3TargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.s3Targets = mapped
    }

    /**
     * @param argument List of nested Amazon S3 target arguments. See S3 Target below.
     */
    @JvmName("pnmoqiuodwlvvvjo")
    public suspend fun s3Targets(vararg argument: suspend CrawlerS3TargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CrawlerS3TargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.s3Targets = mapped
    }

    /**
     * @param argument List of nested Amazon S3 target arguments. See S3 Target below.
     */
    @JvmName("idjtcbmhgbcynuus")
    public suspend fun s3Targets(argument: suspend CrawlerS3TargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CrawlerS3TargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.s3Targets = mapped
    }

    /**
     * @param values List of nested Amazon S3 target arguments. See S3 Target below.
     */
    @JvmName("bxhjqqlgexqdmglp")
    public suspend fun s3Targets(vararg values: CrawlerS3TargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Targets = mapped
    }

    /**
     * @param value A cron expression used to specify the schedule. For more information, see [Time-Based Schedules for Jobs and Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html). For example, to run something every day at 12:15 UTC, you would specify: `cron(15 12 * * ? *)`.
     */
    @JvmName("taxmglqbcjravlip")
    public suspend fun schedule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value Policy for the crawler's update and deletion behavior. See Schema Change Policy below.
     */
    @JvmName("cwlschduiavsnxai")
    public suspend fun schemaChangePolicy(`value`: CrawlerSchemaChangePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaChangePolicy = mapped
    }

    /**
     * @param argument Policy for the crawler's update and deletion behavior. See Schema Change Policy below.
     */
    @JvmName("pubthymprhpipsug")
    public suspend
    fun schemaChangePolicy(argument: suspend CrawlerSchemaChangePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = CrawlerSchemaChangePolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schemaChangePolicy = mapped
    }

    /**
     * @param value The name of Security Configuration to be used by the crawler
     */
    @JvmName("onwnybqiciwyyrjv")
    public suspend fun securityConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityConfiguration = mapped
    }

    /**
     * @param value The table prefix used for catalog tables that are created.
     */
    @JvmName("rhsqlvenqdbxclpi")
    public suspend fun tablePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tablePrefix = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xrhgqsvrcjmrqtls")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xrmiobobrifufhkb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CrawlerArgs = CrawlerArgs(
        catalogTargets = catalogTargets,
        classifiers = classifiers,
        configuration = configuration,
        databaseName = databaseName,
        deltaTargets = deltaTargets,
        description = description,
        dynamodbTargets = dynamodbTargets,
        hudiTargets = hudiTargets,
        icebergTargets = icebergTargets,
        jdbcTargets = jdbcTargets,
        lakeFormationConfiguration = lakeFormationConfiguration,
        lineageConfiguration = lineageConfiguration,
        mongodbTargets = mongodbTargets,
        name = name,
        recrawlPolicy = recrawlPolicy,
        role = role,
        s3Targets = s3Targets,
        schedule = schedule,
        schemaChangePolicy = schemaChangePolicy,
        securityConfiguration = securityConfiguration,
        tablePrefix = tablePrefix,
        tags = tags,
    )
}
