@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.DataCatalogEncryptionSettingsArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs
import com.pulumi.aws.glue.kotlin.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a Glue Data Catalog Encryption Settings resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.DataCatalogEncryptionSettings;
 * import com.pulumi.aws.glue.DataCatalogEncryptionSettingsArgs;
 * import com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs;
 * import com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs;
 * import com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataCatalogEncryptionSettings("example", DataCatalogEncryptionSettingsArgs.builder()
 *             .dataCatalogEncryptionSettings(DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs.builder()
 *                 .connectionPasswordEncryption(DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs.builder()
 *                     .awsKmsKeyId(aws_kms_key.test().arn())
 *                     .returnConnectionPasswordEncrypted(true)
 *                     .build())
 *                 .encryptionAtRest(DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs.builder()
 *                     .catalogEncryptionMode("SSE-KMS")
 *                     .sseAwsKmsKeyId(aws_kms_key.test().arn())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Data Catalog Encryption Settings using `CATALOG-ID` (AWS account ID if not custom). For example:
 * ```sh
 *  $ pulumi import aws:glue/dataCatalogEncryptionSettings:DataCatalogEncryptionSettings example 123456789012
 * ```
 * @property catalogId The ID of the Data Catalog to set the security configuration for. If none is provided, the AWS account ID is used by default.
 * @property dataCatalogEncryptionSettings The security configuration to set. see Data Catalog Encryption Settings.
 */
public data class DataCatalogEncryptionSettingsArgs(
    public val catalogId: Output<String>? = null,
    public val dataCatalogEncryptionSettings:
    Output<DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.DataCatalogEncryptionSettingsArgs> {
    override fun toJava(): com.pulumi.aws.glue.DataCatalogEncryptionSettingsArgs =
        com.pulumi.aws.glue.DataCatalogEncryptionSettingsArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .dataCatalogEncryptionSettings(
                dataCatalogEncryptionSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [DataCatalogEncryptionSettingsArgs].
 */
@PulumiTagMarker
public class DataCatalogEncryptionSettingsArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var dataCatalogEncryptionSettings:
        Output<DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs>? = null

    /**
     * @param value The ID of the Data Catalog to set the security configuration for. If none is provided, the AWS account ID is used by default.
     */
    @JvmName("hrgsvwwmkpvskjne")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value The security configuration to set. see Data Catalog Encryption Settings.
     */
    @JvmName("avevtyetlelsrukn")
    public suspend
    fun dataCatalogEncryptionSettings(`value`: Output<DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs>) {
        this.dataCatalogEncryptionSettings = value
    }

    /**
     * @param value The ID of the Data Catalog to set the security configuration for. If none is provided, the AWS account ID is used by default.
     */
    @JvmName("sbvanprrwfxxjqpa")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value The security configuration to set. see Data Catalog Encryption Settings.
     */
    @JvmName("pqxphcgbkcsnixhv")
    public suspend
    fun dataCatalogEncryptionSettings(`value`: DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCatalogEncryptionSettings = mapped
    }

    /**
     * @param argument The security configuration to set. see Data Catalog Encryption Settings.
     */
    @JvmName("qdupptpxetkdwufc")
    public suspend
    fun dataCatalogEncryptionSettings(argument: suspend DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dataCatalogEncryptionSettings = mapped
    }

    internal fun build(): DataCatalogEncryptionSettingsArgs = DataCatalogEncryptionSettingsArgs(
        catalogId = catalogId,
        dataCatalogEncryptionSettings = dataCatalogEncryptionSettings,
    )
}
