@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.kotlin.outputs.DataQualityRulesetTargetTable
import com.pulumi.aws.glue.kotlin.outputs.DataQualityRulesetTargetTable.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [DataQualityRuleset].
 */
@PulumiTagMarker
public class DataQualityRulesetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataQualityRulesetArgs = DataQualityRulesetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataQualityRulesetArgsBuilder.() -> Unit) {
        val builder = DataQualityRulesetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DataQualityRuleset {
        val builtJavaResource = com.pulumi.aws.glue.DataQualityRuleset(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DataQualityRuleset(builtJavaResource)
    }
}

/**
 * Provides a Glue Data Quality Ruleset Resource. You can refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/glue-data-quality.html) for a full explanation of the Glue Data Quality Ruleset functionality
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.DataQualityRuleset;
 * import com.pulumi.aws.glue.DataQualityRulesetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataQualityRuleset("example", DataQualityRulesetArgs.builder()
 *             .ruleset("Rules = [Completeness \"colA\" between 0.4 and 0.8]")
 *             .build());
 *     }
 * }
 * ```
 * ### With description
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.DataQualityRuleset;
 * import com.pulumi.aws.glue.DataQualityRulesetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataQualityRuleset("example", DataQualityRulesetArgs.builder()
 *             .description("example")
 *             .ruleset("Rules = [Completeness \"colA\" between 0.4 and 0.8]")
 *             .build());
 *     }
 * }
 * ```
 * ### With tags
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.DataQualityRuleset;
 * import com.pulumi.aws.glue.DataQualityRulesetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataQualityRuleset("example", DataQualityRulesetArgs.builder()
 *             .ruleset("Rules = [Completeness \"colA\" between 0.4 and 0.8]")
 *             .tags(Map.of("hello", "world"))
 *             .build());
 *     }
 * }
 * ```
 * ### With target_table
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.DataQualityRuleset;
 * import com.pulumi.aws.glue.DataQualityRulesetArgs;
 * import com.pulumi.aws.glue.inputs.DataQualityRulesetTargetTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataQualityRuleset("example", DataQualityRulesetArgs.builder()
 *             .ruleset("Rules = [Completeness \"colA\" between 0.4 and 0.8]")
 *             .targetTable(DataQualityRulesetTargetTableArgs.builder()
 *                 .databaseName(aws_glue_catalog_database.example().name())
 *                 .tableName(aws_glue_catalog_table.example().name())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Data Quality Ruleset using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:glue/dataQualityRuleset:DataQualityRuleset example exampleName
 * ```
 *
 */
public class DataQualityRuleset internal constructor(
    override val javaResource: com.pulumi.aws.glue.DataQualityRuleset,
) : KotlinCustomResource(javaResource, DataQualityRulesetMapper) {
    /**
     * ARN of the Glue Data Quality Ruleset.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The time and date that this data quality ruleset was created.
     */
    public val createdOn: Output<String>
        get() = javaResource.createdOn().applyValue({ args0 -> args0 })

    /**
     * Description of the data quality ruleset.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time and date that this data quality ruleset was created.
     */
    public val lastModifiedOn: Output<String>
        get() = javaResource.lastModifiedOn().applyValue({ args0 -> args0 })

    /**
     * Name of the data quality ruleset.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * When a ruleset was created from a recommendation run, this run ID is generated to link the two together.
     */
    public val recommendationRunId: Output<String>
        get() = javaResource.recommendationRunId().applyValue({ args0 -> args0 })

    /**
     * A Data Quality Definition Language (DQDL) ruleset. For more information, see the AWS Glue developer guide.
     */
    public val ruleset: Output<String>
        get() = javaResource.ruleset().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A Configuration block specifying a target table associated with the data quality ruleset. See `target_table` below.
     */
    public val targetTable: Output<DataQualityRulesetTargetTable>?
        get() = javaResource.targetTable().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object DataQualityRulesetMapper : ResourceMapper<DataQualityRuleset> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glue.DataQualityRuleset::class == javaResource::class

    override fun map(javaResource: Resource): DataQualityRuleset = DataQualityRuleset(
        javaResource as
            com.pulumi.aws.glue.DataQualityRuleset,
    )
}

/**
 * @see [DataQualityRuleset].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataQualityRuleset].
 */
public suspend fun dataQualityRuleset(
    name: String,
    block: suspend DataQualityRulesetResourceBuilder.() -> Unit,
): DataQualityRuleset {
    val builder = DataQualityRulesetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataQualityRuleset].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataQualityRuleset(name: String): DataQualityRuleset {
    val builder = DataQualityRulesetResourceBuilder()
    builder.name(name)
    return builder.build()
}
