@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.DataQualityRulesetArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.DataQualityRulesetTargetTableArgs
import com.pulumi.aws.glue.kotlin.inputs.DataQualityRulesetTargetTableArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Glue Data Quality Ruleset Resource. You can refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/glue-data-quality.html) for a full explanation of the Glue Data Quality Ruleset functionality
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.DataQualityRuleset;
 * import com.pulumi.aws.glue.DataQualityRulesetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataQualityRuleset("example", DataQualityRulesetArgs.builder()
 *             .ruleset("Rules = [Completeness \"colA\" between 0.4 and 0.8]")
 *             .build());
 *     }
 * }
 * ```
 * ### With description
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.DataQualityRuleset;
 * import com.pulumi.aws.glue.DataQualityRulesetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataQualityRuleset("example", DataQualityRulesetArgs.builder()
 *             .description("example")
 *             .ruleset("Rules = [Completeness \"colA\" between 0.4 and 0.8]")
 *             .build());
 *     }
 * }
 * ```
 * ### With tags
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.DataQualityRuleset;
 * import com.pulumi.aws.glue.DataQualityRulesetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataQualityRuleset("example", DataQualityRulesetArgs.builder()
 *             .ruleset("Rules = [Completeness \"colA\" between 0.4 and 0.8]")
 *             .tags(Map.of("hello", "world"))
 *             .build());
 *     }
 * }
 * ```
 * ### With target_table
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.DataQualityRuleset;
 * import com.pulumi.aws.glue.DataQualityRulesetArgs;
 * import com.pulumi.aws.glue.inputs.DataQualityRulesetTargetTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataQualityRuleset("example", DataQualityRulesetArgs.builder()
 *             .ruleset("Rules = [Completeness \"colA\" between 0.4 and 0.8]")
 *             .targetTable(DataQualityRulesetTargetTableArgs.builder()
 *                 .databaseName(aws_glue_catalog_database.example().name())
 *                 .tableName(aws_glue_catalog_table.example().name())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Data Quality Ruleset using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:glue/dataQualityRuleset:DataQualityRuleset example exampleName
 * ```
 * @property description Description of the data quality ruleset.
 * @property name Name of the data quality ruleset.
 * @property ruleset A Data Quality Definition Language (DQDL) ruleset. For more information, see the AWS Glue developer guide.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetTable A Configuration block specifying a target table associated with the data quality ruleset. See `target_table` below.
 */
public data class DataQualityRulesetArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val ruleset: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetTable: Output<DataQualityRulesetTargetTableArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.DataQualityRulesetArgs> {
    override fun toJava(): com.pulumi.aws.glue.DataQualityRulesetArgs =
        com.pulumi.aws.glue.DataQualityRulesetArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ruleset(ruleset?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetTable(targetTable?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataQualityRulesetArgs].
 */
@PulumiTagMarker
public class DataQualityRulesetArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var ruleset: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetTable: Output<DataQualityRulesetTargetTableArgs>? = null

    /**
     * @param value Description of the data quality ruleset.
     */
    @JvmName("vypskqgqkcyahumc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the data quality ruleset.
     */
    @JvmName("kmqgnbnfsjpngrxy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A Data Quality Definition Language (DQDL) ruleset. For more information, see the AWS Glue developer guide.
     */
    @JvmName("uoyoohndvgtmqkhe")
    public suspend fun ruleset(`value`: Output<String>) {
        this.ruleset = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gmrotnlaraarmdon")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A Configuration block specifying a target table associated with the data quality ruleset. See `target_table` below.
     */
    @JvmName("msrxbankgxdaerbj")
    public suspend fun targetTable(`value`: Output<DataQualityRulesetTargetTableArgs>) {
        this.targetTable = value
    }

    /**
     * @param value Description of the data quality ruleset.
     */
    @JvmName("klyqasrgkdyyiooc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the data quality ruleset.
     */
    @JvmName("gitehjdbuyqrxlxx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A Data Quality Definition Language (DQDL) ruleset. For more information, see the AWS Glue developer guide.
     */
    @JvmName("ueaajtogpfrufvub")
    public suspend fun ruleset(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleset = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("blurkhnmknkmephv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kqtwrvnqeruhhauc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A Configuration block specifying a target table associated with the data quality ruleset. See `target_table` below.
     */
    @JvmName("hwsrbpefhphyngyg")
    public suspend fun targetTable(`value`: DataQualityRulesetTargetTableArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetTable = mapped
    }

    /**
     * @param argument A Configuration block specifying a target table associated with the data quality ruleset. See `target_table` below.
     */
    @JvmName("fedfqowqnvwmigul")
    public suspend
    fun targetTable(argument: suspend DataQualityRulesetTargetTableArgsBuilder.() -> Unit) {
        val toBeMapped = DataQualityRulesetTargetTableArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetTable = mapped
    }

    internal fun build(): DataQualityRulesetArgs = DataQualityRulesetArgs(
        description = description,
        name = name,
        ruleset = ruleset,
        tags = tags,
        targetTable = targetTable,
    )
}
