@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.DevEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Glue Development Endpoint resource.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.glue.DevEndpoint;
 * import com.pulumi.aws.glue.DevEndpointArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("glue.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleDevEndpoint = new DevEndpoint("exampleDevEndpoint", DevEndpointArgs.builder()
 *             .roleArn(exampleRole.arn())
 *             .build());
 *         var example_AWSGlueServiceRole = new RolePolicyAttachment("example-AWSGlueServiceRole", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSGlueServiceRole")
 *             .role(exampleRole.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a Glue Development Endpoint using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:glue/devEndpoint:DevEndpoint example foo
 * ```
 * @property arguments A map of arguments used to configure the endpoint.
 * @property extraJarsS3Path Path to one or more Java Jars in an S3 bucket that should be loaded in this endpoint.
 * @property extraPythonLibsS3Path Path(s) to one or more Python libraries in an S3 bucket that should be loaded in this endpoint. Multiple values must be complete paths separated by a comma.
 * @property glueVersion Specifies the versions of Python and Apache Spark to use. Defaults to AWS Glue version 0.9.
 * @property name The name of this endpoint. It must be unique in your account.
 * @property numberOfNodes The number of AWS Glue Data Processing Units (DPUs) to allocate to this endpoint. Conflicts with `worker_type`.
 * @property numberOfWorkers The number of workers of a defined worker type that are allocated to this endpoint. This field is available only when you choose worker type G.1X or G.2X.
 * @property publicKey The public key to be used by this endpoint for authentication.
 * @property publicKeys A list of public keys to be used by this endpoint for authentication.
 * @property roleArn The IAM role for this endpoint.
 * @property securityConfiguration The name of the Security Configuration structure to be used with this endpoint.
 * @property securityGroupIds Security group IDs for the security groups to be used by this endpoint.
 * @property subnetId The subnet ID for the new endpoint to use.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property workerType The type of predefined worker that is allocated to this endpoint. Accepts a value of Standard, G.1X, or G.2X.
 */
public data class DevEndpointArgs(
    public val arguments: Output<Map<String, String>>? = null,
    public val extraJarsS3Path: Output<String>? = null,
    public val extraPythonLibsS3Path: Output<String>? = null,
    public val glueVersion: Output<String>? = null,
    public val name: Output<String>? = null,
    public val numberOfNodes: Output<Int>? = null,
    public val numberOfWorkers: Output<Int>? = null,
    public val publicKey: Output<String>? = null,
    public val publicKeys: Output<List<String>>? = null,
    public val roleArn: Output<String>? = null,
    public val securityConfiguration: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workerType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.DevEndpointArgs> {
    override fun toJava(): com.pulumi.aws.glue.DevEndpointArgs =
        com.pulumi.aws.glue.DevEndpointArgs.builder()
            .arguments(
                arguments?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .extraJarsS3Path(extraJarsS3Path?.applyValue({ args0 -> args0 }))
            .extraPythonLibsS3Path(extraPythonLibsS3Path?.applyValue({ args0 -> args0 }))
            .glueVersion(glueVersion?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .numberOfNodes(numberOfNodes?.applyValue({ args0 -> args0 }))
            .numberOfWorkers(numberOfWorkers?.applyValue({ args0 -> args0 }))
            .publicKey(publicKey?.applyValue({ args0 -> args0 }))
            .publicKeys(publicKeys?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .securityConfiguration(securityConfiguration?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workerType(workerType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DevEndpointArgs].
 */
@PulumiTagMarker
public class DevEndpointArgsBuilder internal constructor() {
    private var arguments: Output<Map<String, String>>? = null

    private var extraJarsS3Path: Output<String>? = null

    private var extraPythonLibsS3Path: Output<String>? = null

    private var glueVersion: Output<String>? = null

    private var name: Output<String>? = null

    private var numberOfNodes: Output<Int>? = null

    private var numberOfWorkers: Output<Int>? = null

    private var publicKey: Output<String>? = null

    private var publicKeys: Output<List<String>>? = null

    private var roleArn: Output<String>? = null

    private var securityConfiguration: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workerType: Output<String>? = null

    /**
     * @param value A map of arguments used to configure the endpoint.
     */
    @JvmName("pfomrdvokmcbyqvr")
    public suspend fun arguments(`value`: Output<Map<String, String>>) {
        this.arguments = value
    }

    /**
     * @param value Path to one or more Java Jars in an S3 bucket that should be loaded in this endpoint.
     */
    @JvmName("eabxmbtjmcjykitc")
    public suspend fun extraJarsS3Path(`value`: Output<String>) {
        this.extraJarsS3Path = value
    }

    /**
     * @param value Path(s) to one or more Python libraries in an S3 bucket that should be loaded in this endpoint. Multiple values must be complete paths separated by a comma.
     */
    @JvmName("bnqsivnxvwaajatd")
    public suspend fun extraPythonLibsS3Path(`value`: Output<String>) {
        this.extraPythonLibsS3Path = value
    }

    /**
     * @param value Specifies the versions of Python and Apache Spark to use. Defaults to AWS Glue version 0.9.
     */
    @JvmName("vogwovgeblnnjfqi")
    public suspend fun glueVersion(`value`: Output<String>) {
        this.glueVersion = value
    }

    /**
     * @param value The name of this endpoint. It must be unique in your account.
     */
    @JvmName("njboawxgfyrtmcns")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The number of AWS Glue Data Processing Units (DPUs) to allocate to this endpoint. Conflicts with `worker_type`.
     */
    @JvmName("lfspainqthqlebys")
    public suspend fun numberOfNodes(`value`: Output<Int>) {
        this.numberOfNodes = value
    }

    /**
     * @param value The number of workers of a defined worker type that are allocated to this endpoint. This field is available only when you choose worker type G.1X or G.2X.
     */
    @JvmName("vnijnkfdqdkefwbi")
    public suspend fun numberOfWorkers(`value`: Output<Int>) {
        this.numberOfWorkers = value
    }

    /**
     * @param value The public key to be used by this endpoint for authentication.
     */
    @JvmName("jwhbcrxyidtnucoq")
    public suspend fun publicKey(`value`: Output<String>) {
        this.publicKey = value
    }

    /**
     * @param value A list of public keys to be used by this endpoint for authentication.
     */
    @JvmName("kuthrlqgyencbybn")
    public suspend fun publicKeys(`value`: Output<List<String>>) {
        this.publicKeys = value
    }

    @JvmName("isehuxsidrqvllsj")
    public suspend fun publicKeys(vararg values: Output<String>) {
        this.publicKeys = Output.all(values.asList())
    }

    /**
     * @param values A list of public keys to be used by this endpoint for authentication.
     */
    @JvmName("abxvgvyirfjqlglg")
    public suspend fun publicKeys(values: List<Output<String>>) {
        this.publicKeys = Output.all(values)
    }

    /**
     * @param value The IAM role for this endpoint.
     */
    @JvmName("lkqiwbfjqygglsgh")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The name of the Security Configuration structure to be used with this endpoint.
     */
    @JvmName("iqvishfrmxyjjlul")
    public suspend fun securityConfiguration(`value`: Output<String>) {
        this.securityConfiguration = value
    }

    /**
     * @param value Security group IDs for the security groups to be used by this endpoint.
     */
    @JvmName("lvwpmlmlrscoddth")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("pxkypwrvhcjumskp")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Security group IDs for the security groups to be used by this endpoint.
     */
    @JvmName("yxjtpqjwnxvmngdg")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The subnet ID for the new endpoint to use.
     */
    @JvmName("kydoouvappjvmvca")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bhtbwppjgfdtawgy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of predefined worker that is allocated to this endpoint. Accepts a value of Standard, G.1X, or G.2X.
     */
    @JvmName("adipibjnauircghr")
    public suspend fun workerType(`value`: Output<String>) {
        this.workerType = value
    }

    /**
     * @param value A map of arguments used to configure the endpoint.
     */
    @JvmName("acmdnytojawqjpht")
    public suspend fun arguments(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param values A map of arguments used to configure the endpoint.
     */
    @JvmName("ckjloukftutdyear")
    public fun arguments(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param value Path to one or more Java Jars in an S3 bucket that should be loaded in this endpoint.
     */
    @JvmName("erkgqceoqmlqqglm")
    public suspend fun extraJarsS3Path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extraJarsS3Path = mapped
    }

    /**
     * @param value Path(s) to one or more Python libraries in an S3 bucket that should be loaded in this endpoint. Multiple values must be complete paths separated by a comma.
     */
    @JvmName("dgcwwrqbmsiehikg")
    public suspend fun extraPythonLibsS3Path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extraPythonLibsS3Path = mapped
    }

    /**
     * @param value Specifies the versions of Python and Apache Spark to use. Defaults to AWS Glue version 0.9.
     */
    @JvmName("khxsdxyetdacgbty")
    public suspend fun glueVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.glueVersion = mapped
    }

    /**
     * @param value The name of this endpoint. It must be unique in your account.
     */
    @JvmName("bkanjiogwmodkvrq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The number of AWS Glue Data Processing Units (DPUs) to allocate to this endpoint. Conflicts with `worker_type`.
     */
    @JvmName("giwhalitrgmkwgta")
    public suspend fun numberOfNodes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfNodes = mapped
    }

    /**
     * @param value The number of workers of a defined worker type that are allocated to this endpoint. This field is available only when you choose worker type G.1X or G.2X.
     */
    @JvmName("awuekwofgyhetitq")
    public suspend fun numberOfWorkers(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfWorkers = mapped
    }

    /**
     * @param value The public key to be used by this endpoint for authentication.
     */
    @JvmName("anyrtxjuatwvaybp")
    public suspend fun publicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKey = mapped
    }

    /**
     * @param value A list of public keys to be used by this endpoint for authentication.
     */
    @JvmName("kjkmkyijwxdtubcg")
    public suspend fun publicKeys(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKeys = mapped
    }

    /**
     * @param values A list of public keys to be used by this endpoint for authentication.
     */
    @JvmName("ewkowhbybltpipdk")
    public suspend fun publicKeys(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicKeys = mapped
    }

    /**
     * @param value The IAM role for this endpoint.
     */
    @JvmName("qckrvnpytmmqrrar")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The name of the Security Configuration structure to be used with this endpoint.
     */
    @JvmName("vnifrrqfiqancswx")
    public suspend fun securityConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityConfiguration = mapped
    }

    /**
     * @param value Security group IDs for the security groups to be used by this endpoint.
     */
    @JvmName("yojgvnhifhhvuxsh")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values Security group IDs for the security groups to be used by this endpoint.
     */
    @JvmName("etjesmpskbqurkrp")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The subnet ID for the new endpoint to use.
     */
    @JvmName("xvkoixsfduthexic")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qmaxjhtufpxdbune")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ghnyykhvhwdvbjyb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of predefined worker that is allocated to this endpoint. Accepts a value of Standard, G.1X, or G.2X.
     */
    @JvmName("wtnpnnrsjmmvntod")
    public suspend fun workerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerType = mapped
    }

    internal fun build(): DevEndpointArgs = DevEndpointArgs(
        arguments = arguments,
        extraJarsS3Path = extraJarsS3Path,
        extraPythonLibsS3Path = extraPythonLibsS3Path,
        glueVersion = glueVersion,
        name = name,
        numberOfNodes = numberOfNodes,
        numberOfWorkers = numberOfWorkers,
        publicKey = publicKey,
        publicKeys = publicKeys,
        roleArn = roleArn,
        securityConfiguration = securityConfiguration,
        securityGroupIds = securityGroupIds,
        subnetId = subnetId,
        tags = tags,
        workerType = workerType,
    )
}
