@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.GlueFunctions.getCatalogTablePlain
import com.pulumi.aws.glue.GlueFunctions.getConnectionPlain
import com.pulumi.aws.glue.GlueFunctions.getDataCatalogEncryptionSettingsPlain
import com.pulumi.aws.glue.GlueFunctions.getScriptPlain
import com.pulumi.aws.glue.kotlin.inputs.GetCatalogTablePlainArgs
import com.pulumi.aws.glue.kotlin.inputs.GetCatalogTablePlainArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.GetConnectionPlainArgs
import com.pulumi.aws.glue.kotlin.inputs.GetConnectionPlainArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.GetDataCatalogEncryptionSettingsPlainArgs
import com.pulumi.aws.glue.kotlin.inputs.GetDataCatalogEncryptionSettingsPlainArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.GetScriptDagEdge
import com.pulumi.aws.glue.kotlin.inputs.GetScriptDagNode
import com.pulumi.aws.glue.kotlin.inputs.GetScriptPlainArgs
import com.pulumi.aws.glue.kotlin.inputs.GetScriptPlainArgsBuilder
import com.pulumi.aws.glue.kotlin.outputs.GetCatalogTableResult
import com.pulumi.aws.glue.kotlin.outputs.GetConnectionResult
import com.pulumi.aws.glue.kotlin.outputs.GetDataCatalogEncryptionSettingsResult
import com.pulumi.aws.glue.kotlin.outputs.GetScriptResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.glue.kotlin.outputs.GetCatalogTableResult.Companion.toKotlin as getCatalogTableResultToKotlin
import com.pulumi.aws.glue.kotlin.outputs.GetConnectionResult.Companion.toKotlin as getConnectionResultToKotlin
import com.pulumi.aws.glue.kotlin.outputs.GetDataCatalogEncryptionSettingsResult.Companion.toKotlin as getDataCatalogEncryptionSettingsResultToKotlin
import com.pulumi.aws.glue.kotlin.outputs.GetScriptResult.Companion.toKotlin as getScriptResultToKotlin

public object GlueFunctions {
    /**
     * This data source can be used to fetch information about an AWS Glue Data Catalog Table.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.glue.GlueFunctions;
     * import com.pulumi.aws.glue.inputs.GetCatalogTableArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GlueFunctions.getCatalogTable(GetCatalogTableArgs.builder()
     *             .databaseName("MyCatalogDatabase")
     *             .name("MyCatalogTable")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getCatalogTable.
     * @return A collection of values returned by getCatalogTable.
     */
    public suspend fun getCatalogTable(argument: GetCatalogTablePlainArgs): GetCatalogTableResult =
        getCatalogTableResultToKotlin(getCatalogTablePlain(argument.toJava()).await())

    /**
     * @see [getCatalogTable].
     * @param catalogId ID of the Glue Catalog and database where the table metadata resides. If omitted, this defaults to the current AWS Account ID.
     * @param databaseName Name of the metadata database where the table metadata resides.
     * @param name Name of the table.
     * @param queryAsOfTime The time as of when to read the table contents. If not set, the most recent transaction commit time will be used. Cannot be specified along with `transaction_id`. Specified in RFC 3339 format, e.g. `2006-01-02T15:04:05Z07:00`.
     * @param transactionId The transaction ID at which to read the table contents.
     * @return A collection of values returned by getCatalogTable.
     */
    public suspend fun getCatalogTable(
        catalogId: String? = null,
        databaseName: String,
        name: String,
        queryAsOfTime: String? = null,
        transactionId: Int? = null,
    ): GetCatalogTableResult {
        val argument = GetCatalogTablePlainArgs(
            catalogId = catalogId,
            databaseName = databaseName,
            name = name,
            queryAsOfTime = queryAsOfTime,
            transactionId = transactionId,
        )
        return getCatalogTableResultToKotlin(getCatalogTablePlain(argument.toJava()).await())
    }

    /**
     * @see [getCatalogTable].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;glue&#46;kotlin&#46;inputs&#46;GetCatalogTablePlainArgs].
     * @return A collection of values returned by getCatalogTable.
     */
    public suspend fun getCatalogTable(argument: suspend GetCatalogTablePlainArgsBuilder.() -> Unit):
        GetCatalogTableResult {
        val builder = GetCatalogTablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCatalogTableResultToKotlin(getCatalogTablePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source can be used to fetch information about a specific Glue Connection.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.glue.GlueFunctions;
     * import com.pulumi.aws.glue.inputs.GetConnectionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GlueFunctions.getConnection(GetConnectionArgs.builder()
     *             .id("123456789123:connection")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getConnection.
     * @return A collection of values returned by getConnection.
     */
    public suspend fun getConnection(argument: GetConnectionPlainArgs): GetConnectionResult =
        getConnectionResultToKotlin(getConnectionPlain(argument.toJava()).await())

    /**
     * @see [getConnection].
     * @param id Concatenation of the catalog ID and connection name. For example, if your account ID is
     * `123456789123` and the connection name is `conn` then the ID is `123456789123:conn`.
     * @param tags Tags assigned to the resource
     * @return A collection of values returned by getConnection.
     */
    public suspend fun getConnection(id: String, tags: Map<String, String>? = null):
        GetConnectionResult {
        val argument = GetConnectionPlainArgs(
            id = id,
            tags = tags,
        )
        return getConnectionResultToKotlin(getConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnection].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;glue&#46;kotlin&#46;inputs&#46;GetConnectionPlainArgs].
     * @return A collection of values returned by getConnection.
     */
    public suspend fun getConnection(argument: suspend GetConnectionPlainArgsBuilder.() -> Unit):
        GetConnectionResult {
        val builder = GetConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectionResultToKotlin(getConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source can be used to fetch information about AWS Glue Data Catalog Encryption Settings.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.glue.GlueFunctions;
     * import com.pulumi.aws.glue.inputs.GetDataCatalogEncryptionSettingsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GlueFunctions.getDataCatalogEncryptionSettings(GetDataCatalogEncryptionSettingsArgs.builder()
     *             .id("123456789123")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getDataCatalogEncryptionSettings.
     * @return A collection of values returned by getDataCatalogEncryptionSettings.
     */
    public suspend
    fun getDataCatalogEncryptionSettings(argument: GetDataCatalogEncryptionSettingsPlainArgs):
        GetDataCatalogEncryptionSettingsResult =
        getDataCatalogEncryptionSettingsResultToKotlin(getDataCatalogEncryptionSettingsPlain(argument.toJava()).await())

    /**
     * @see [getDataCatalogEncryptionSettings].
     * @param catalogId ID of the Data Catalog. This is typically the AWS account ID.
     * @return A collection of values returned by getDataCatalogEncryptionSettings.
     */
    public suspend fun getDataCatalogEncryptionSettings(catalogId: String):
        GetDataCatalogEncryptionSettingsResult {
        val argument = GetDataCatalogEncryptionSettingsPlainArgs(
            catalogId = catalogId,
        )
        return getDataCatalogEncryptionSettingsResultToKotlin(getDataCatalogEncryptionSettingsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataCatalogEncryptionSettings].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;glue&#46;kotlin&#46;inputs&#46;GetDataCatalogEncryptionSettingsPlainArgs].
     * @return A collection of values returned by getDataCatalogEncryptionSettings.
     */
    public suspend
    fun getDataCatalogEncryptionSettings(argument: suspend GetDataCatalogEncryptionSettingsPlainArgsBuilder.() -> Unit):
        GetDataCatalogEncryptionSettingsResult {
        val builder = GetDataCatalogEncryptionSettingsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataCatalogEncryptionSettingsResultToKotlin(getDataCatalogEncryptionSettingsPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to generate a Glue script from a Directed Acyclic Graph (DAG).
     * ## Example Usage
     * ### Generate Python Script
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.glue.GlueFunctions;
     * import com.pulumi.aws.glue.inputs.GetScriptArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GlueFunctions.getScript(GetScriptArgs.builder()
     *             .language("PYTHON")
     *             .dagEdges(
     *                 GetScriptDagEdgeArgs.builder()
     *                     .source("datasource0")
     *                     .target("applymapping1")
     *                     .build(),
     *                 GetScriptDagEdgeArgs.builder()
     *                     .source("applymapping1")
     *                     .target("selectfields2")
     *                     .build(),
     *                 GetScriptDagEdgeArgs.builder()
     *                     .source("selectfields2")
     *                     .target("resolvechoice3")
     *                     .build(),
     *                 GetScriptDagEdgeArgs.builder()
     *                     .source("resolvechoice3")
     *                     .target("datasink4")
     *                     .build())
     *             .dagNodes(
     *                 GetScriptDagNodeArgs.builder()
     *                     .id("datasource0")
     *                     .nodeType("DataSource")
     *                     .args(
     *                         GetScriptDagNodeArgArgs.builder()
     *                             .name("database")
     *                             .value(String.format("\"%s\"", aws_glue_catalog_database.source().name()))
     *                             .build(),
     *                         GetScriptDagNodeArgArgs.builder()
     *                             .name("table_name")
     *                             .value(String.format("\"%s\"", aws_glue_catalog_table.source().name()))
     *                             .build())
     *                     .build(),
     *                 GetScriptDagNodeArgs.builder()
     *                     .id("applymapping1")
     *                     .nodeType("ApplyMapping")
     *                     .args(GetScriptDagNodeArgArgs.builder()
     *                         .name("mapping")
     *                         .value("[(\"column1\", \"string\", \"column1\", \"string\")]")
     *                         .build())
     *                     .build(),
     *                 GetScriptDagNodeArgs.builder()
     *                     .id("selectfields2")
     *                     .nodeType("SelectFields")
     *                     .args(GetScriptDagNodeArgArgs.builder()
     *                         .name("paths")
     *                         .value("[\"column1\"]")
     *                         .build())
     *                     .build(),
     *                 GetScriptDagNodeArgs.builder()
     *                     .id("resolvechoice3")
     *                     .nodeType("ResolveChoice")
     *                     .args(
     *                         GetScriptDagNodeArgArgs.builder()
     *                             .name("choice")
     *                             .value("\"MATCH_CATALOG\"")
     *                             .build(),
     *                         GetScriptDagNodeArgArgs.builder()
     *                             .name("database")
     *                             .value(String.format("\"%s\"", aws_glue_catalog_database.destination().name()))
     *                             .build(),
     *                         GetScriptDagNodeArgArgs.builder()
     *                             .name("table_name")
     *                             .value(String.format("\"%s\"", aws_glue_catalog_table.destination().name()))
     *                             .build())
     *                     .build(),
     *                 GetScriptDagNodeArgs.builder()
     *                     .id("datasink4")
     *                     .nodeType("DataSink")
     *                     .args(
     *                         GetScriptDagNodeArgArgs.builder()
     *                             .name("database")
     *                             .value(String.format("\"%s\"", aws_glue_catalog_database.destination().name()))
     *                             .build(),
     *                         GetScriptDagNodeArgArgs.builder()
     *                             .name("table_name")
     *                             .value(String.format("\"%s\"", aws_glue_catalog_table.destination().name()))
     *                             .build())
     *                     .build())
     *             .build());
     *         ctx.export("pythonScript", example.applyValue(getScriptResult -> getScriptResult.pythonScript()));
     *     }
     * }
     * ```
     * ### Generate Scala Code
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.glue.GlueFunctions;
     * import com.pulumi.aws.glue.inputs.GetScriptArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GlueFunctions.getScript(GetScriptArgs.builder()
     *             .language("SCALA")
     *             .dagEdges(
     *                 GetScriptDagEdgeArgs.builder()
     *                     .source("datasource0")
     *                     .target("applymapping1")
     *                     .build(),
     *                 GetScriptDagEdgeArgs.builder()
     *                     .source("applymapping1")
     *                     .target("selectfields2")
     *                     .build(),
     *                 GetScriptDagEdgeArgs.builder()
     *                     .source("selectfields2")
     *                     .target("resolvechoice3")
     *                     .build(),
     *                 GetScriptDagEdgeArgs.builder()
     *                     .source("resolvechoice3")
     *                     .target("datasink4")
     *                     .build())
     *             .dagNodes(
     *                 GetScriptDagNodeArgs.builder()
     *                     .id("datasource0")
     *                     .nodeType("DataSource")
     *                     .args(
     *                         GetScriptDagNodeArgArgs.builder()
     *                             .name("database")
     *                             .value(String.format("\"%s\"", aws_glue_catalog_database.source().name()))
     *                             .build(),
     *                         GetScriptDagNodeArgArgs.builder()
     *                             .name("table_name")
     *                             .value(String.format("\"%s\"", aws_glue_catalog_table.source().name()))
     *                             .build())
     *                     .build(),
     *                 GetScriptDagNodeArgs.builder()
     *                     .id("applymapping1")
     *                     .nodeType("ApplyMapping")
     *                     .args(GetScriptDagNodeArgArgs.builder()
     *                         .name("mappings")
     *                         .value("[(\"column1\", \"string\", \"column1\", \"string\")]")
     *                         .build())
     *                     .build(),
     *                 GetScriptDagNodeArgs.builder()
     *                     .id("selectfields2")
     *                     .nodeType("SelectFields")
     *                     .args(GetScriptDagNodeArgArgs.builder()
     *                         .name("paths")
     *                         .value("[\"column1\"]")
     *                         .build())
     *                     .build(),
     *                 GetScriptDagNodeArgs.builder()
     *                     .id("resolvechoice3")
     *                     .nodeType("ResolveChoice")
     *                     .args(
     *                         GetScriptDagNodeArgArgs.builder()
     *                             .name("choice")
     *                             .value("\"MATCH_CATALOG\"")
     *                             .build(),
     *                         GetScriptDagNodeArgArgs.builder()
     *                             .name("database")
     *                             .value(String.format("\"%s\"", aws_glue_catalog_database.destination().name()))
     *                             .build(),
     *                         GetScriptDagNodeArgArgs.builder()
     *                             .name("table_name")
     *                             .value(String.format("\"%s\"", aws_glue_catalog_table.destination().name()))
     *                             .build())
     *                     .build(),
     *                 GetScriptDagNodeArgs.builder()
     *                     .id("datasink4")
     *                     .nodeType("DataSink")
     *                     .args(
     *                         GetScriptDagNodeArgArgs.builder()
     *                             .name("database")
     *                             .value(String.format("\"%s\"", aws_glue_catalog_database.destination().name()))
     *                             .build(),
     *                         GetScriptDagNodeArgArgs.builder()
     *                             .name("table_name")
     *                             .value(String.format("\"%s\"", aws_glue_catalog_table.destination().name()))
     *                             .build())
     *                     .build())
     *             .build());
     *         ctx.export("scalaCode", example.applyValue(getScriptResult -> getScriptResult.scalaCode()));
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getScript.
     * @return A collection of values returned by getScript.
     */
    public suspend fun getScript(argument: GetScriptPlainArgs): GetScriptResult =
        getScriptResultToKotlin(getScriptPlain(argument.toJava()).await())

    /**
     * @see [getScript].
     * @param dagEdges List of the edges in the DAG. Defined below.
     * @param dagNodes List of the nodes in the DAG. Defined below.
     * @param language Programming language of the resulting code from the DAG. Defaults to `PYTHON`. Valid values are `PYTHON` and `SCALA`.
     * @return A collection of values returned by getScript.
     */
    public suspend fun getScript(
        dagEdges: List<GetScriptDagEdge>,
        dagNodes: List<GetScriptDagNode>,
        language: String? = null,
    ): GetScriptResult {
        val argument = GetScriptPlainArgs(
            dagEdges = dagEdges,
            dagNodes = dagNodes,
            language = language,
        )
        return getScriptResultToKotlin(getScriptPlain(argument.toJava()).await())
    }

    /**
     * @see [getScript].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;glue&#46;kotlin&#46;inputs&#46;GetScriptPlainArgs].
     * @return A collection of values returned by getScript.
     */
    public suspend fun getScript(argument: suspend GetScriptPlainArgsBuilder.() -> Unit):
        GetScriptResult {
        val builder = GetScriptPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScriptResultToKotlin(getScriptPlain(builtArgument.toJava()).await())
    }
}
