@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.kotlin.outputs.JobCommand
import com.pulumi.aws.glue.kotlin.outputs.JobExecutionProperty
import com.pulumi.aws.glue.kotlin.outputs.JobNotificationProperty
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.glue.kotlin.outputs.JobCommand.Companion.toKotlin as jobCommandToKotlin
import com.pulumi.aws.glue.kotlin.outputs.JobExecutionProperty.Companion.toKotlin as jobExecutionPropertyToKotlin
import com.pulumi.aws.glue.kotlin.outputs.JobNotificationProperty.Companion.toKotlin as jobNotificationPropertyToKotlin

/**
 * Builder for [Job].
 */
@PulumiTagMarker
public class JobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobArgs = JobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobArgsBuilder.() -> Unit) {
        val builder = JobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Job {
        val builtJavaResource = com.pulumi.aws.glue.Job(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Job(builtJavaResource)
    }
}

/**
 * Provides a Glue Job resource.
 * > Glue functionality, such as monitoring and logging of jobs, is typically managed with the `default_arguments` argument. See the [Special Parameters Used by AWS Glue](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html) topic in the Glue developer guide for additional information.
 * ## Example Usage
 * ### Python Job
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Job;
 * import com.pulumi.aws.glue.JobArgs;
 * import com.pulumi.aws.glue.inputs.JobCommandArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Job("example", JobArgs.builder()
 *             .roleArn(aws_iam_role.example().arn())
 *             .command(JobCommandArgs.builder()
 *                 .scriptLocation(String.format("s3://%s/example.py", aws_s3_bucket.example().bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Ray Job
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Job;
 * import com.pulumi.aws.glue.JobArgs;
 * import com.pulumi.aws.glue.inputs.JobCommandArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Job("example", JobArgs.builder()
 *             .roleArn(aws_iam_role.example().arn())
 *             .glueVersion("4.0")
 *             .workerType("Z.2X")
 *             .command(JobCommandArgs.builder()
 *                 .name("glueray")
 *                 .pythonVersion("3.9")
 *                 .runtime("Ray2.4")
 *                 .scriptLocation(String.format("s3://%s/example.py", aws_s3_bucket.example().bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Scala Job
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Job;
 * import com.pulumi.aws.glue.JobArgs;
 * import com.pulumi.aws.glue.inputs.JobCommandArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Job("example", JobArgs.builder()
 *             .roleArn(aws_iam_role.example().arn())
 *             .command(JobCommandArgs.builder()
 *                 .scriptLocation(String.format("s3://%s/example.scala", aws_s3_bucket.example().bucket()))
 *                 .build())
 *             .defaultArguments(Map.of("--job-language", "scala"))
 *             .build());
 *     }
 * }
 * ```
 * ### Streaming Job
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Job;
 * import com.pulumi.aws.glue.JobArgs;
 * import com.pulumi.aws.glue.inputs.JobCommandArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Job("example", JobArgs.builder()
 *             .roleArn(aws_iam_role.example().arn())
 *             .command(JobCommandArgs.builder()
 *                 .name("gluestreaming")
 *                 .scriptLocation(String.format("s3://%s/example.script", aws_s3_bucket.example().bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Enabling CloudWatch Logs and Metrics
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.glue.Job;
 * import com.pulumi.aws.glue.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup("exampleLogGroup", LogGroupArgs.builder()
 *             .retentionInDays(14)
 *             .build());
 *         var exampleJob = new Job("exampleJob", JobArgs.builder()
 *             .defaultArguments(Map.ofEntries(
 *                 Map.entry("--continuous-log-logGroup", exampleLogGroup.name()),
 *                 Map.entry("--enable-continuous-cloudwatch-log", "true"),
 *                 Map.entry("--enable-continuous-log-filter", "true"),
 *                 Map.entry("--enable-metrics", "")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Jobs using `name`. For example:
 * ```sh
 *  $ pulumi import aws:glue/job:Job MyJob MyJob
 * ```
 *
 */
public class Job internal constructor(
    override val javaResource: com.pulumi.aws.glue.Job,
) : KotlinCustomResource(javaResource, JobMapper) {
    /**
     * Amazon Resource Name (ARN) of Glue Job
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The command of the job. Defined below.
     */
    public val command: Output<JobCommand>
        get() = javaResource.command().applyValue({ args0 ->
            args0.let({ args0 ->
                jobCommandToKotlin(args0)
            })
        })

    /**
     * The list of connections used for this job.
     */
    public val connections: Output<List<String>>?
        get() = javaResource.connections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The map of default arguments for this job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes. For information about how to specify and consume your own Job arguments, see the [Calling AWS Glue APIs in Python](http://docs&#46;aws&#46;amazon&#46;com/glue/latest/dg/aws-glue-programming-python-calling&#46;html) topic in the developer guide&#46; For information about the key-value pairs that AWS Glue consumes to set up your job, see the [Special Parameters Used by AWS Glue](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html) topic in the developer guide.
     */
    public val defaultArguments: Output<Map<String, String>>?
        get() = javaResource.defaultArguments().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Description of the job.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the job is run with a standard or flexible execution class. The standard execution class is ideal for time-sensitive workloads that require fast job startup and dedicated resources. Valid value: `FLEX`, `STANDARD`.
     */
    public val executionClass: Output<String>?
        get() = javaResource.executionClass().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Execution property of the job. Defined below.
     */
    public val executionProperty: Output<JobExecutionProperty>
        get() = javaResource.executionProperty().applyValue({ args0 ->
            args0.let({ args0 ->
                jobExecutionPropertyToKotlin(args0)
            })
        })

    /**
     * The version of glue to use, for example "1.0". Ray jobs should set this to 4.0 or greater. For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
     */
    public val glueVersion: Output<String>
        get() = javaResource.glueVersion().applyValue({ args0 -> args0 })

    /**
     * The maximum number of AWS Glue data processing units (DPUs) that can be allocated when this job runs. `Required` when `pythonshell` is set, accept either `0.0625` or `1.0`. Use `number_of_workers` and `worker_type` arguments instead with `glue_version` `2.0` and above.
     */
    public val maxCapacity: Output<Double>
        get() = javaResource.maxCapacity().applyValue({ args0 -> args0 })

    /**
     * The maximum number of times to retry this job if it fails.
     */
    public val maxRetries: Output<Int>?
        get() = javaResource.maxRetries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name you assign to this job. It must be unique in your account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Non-overridable arguments for this job, specified as name-value pairs.
     */
    public val nonOverridableArguments: Output<Map<String, String>>?
        get() = javaResource.nonOverridableArguments().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Notification property of the job. Defined below.
     */
    public val notificationProperty: Output<JobNotificationProperty>
        get() = javaResource.notificationProperty().applyValue({ args0 ->
            args0.let({ args0 ->
                jobNotificationPropertyToKotlin(args0)
            })
        })

    /**
     * The number of workers of a defined workerType that are allocated when a job runs.
     */
    public val numberOfWorkers: Output<Int>?
        get() = javaResource.numberOfWorkers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the IAM role associated with this job.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * The name of the Security Configuration to be associated with the job.
     */
    public val securityConfiguration: Output<String>?
        get() = javaResource.securityConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The job timeout in minutes. The default is 2880 minutes (48 hours) for `glueetl` and `pythonshell` jobs, and null (unlimited) for `gluestreaming` jobs.
     */
    public val timeout: Output<Int>
        get() = javaResource.timeout().applyValue({ args0 -> args0 })

    /**
     * The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, G.2X, or G.025X for Spark jobs. Accepts the value Z.2X for Ray jobs.
     * * For the Standard worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
     * * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
     * * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
     * * For the G.025X worker type, each worker maps to 0.25 DPU (2 vCPU, 4GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for low volume streaming jobs. Only available for Glue version 3.0.
     * * For the Z.2X worker type, each worker maps to 2 M-DPU (8vCPU, 64 GB of m emory, 128 GB disk), and provides up to 8 Ray workers based on the autoscaler.
     */
    public val workerType: Output<String>?
        get() = javaResource.workerType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object JobMapper : ResourceMapper<Job> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glue.Job::class == javaResource::class

    override fun map(javaResource: Resource): Job = Job(javaResource as com.pulumi.aws.glue.Job)
}

/**
 * @see [Job].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Job].
 */
public suspend fun job(name: String, block: suspend JobResourceBuilder.() -> Unit): Job {
    val builder = JobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Job].
 * @param name The _unique_ name of the resulting resource.
 */
public fun job(name: String): Job {
    val builder = JobResourceBuilder()
    builder.name(name)
    return builder.build()
}
