@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.JobArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.JobCommandArgs
import com.pulumi.aws.glue.kotlin.inputs.JobCommandArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.JobExecutionPropertyArgs
import com.pulumi.aws.glue.kotlin.inputs.JobExecutionPropertyArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.JobNotificationPropertyArgs
import com.pulumi.aws.glue.kotlin.inputs.JobNotificationPropertyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Glue Job resource.
 * > Glue functionality, such as monitoring and logging of jobs, is typically managed with the `default_arguments` argument. See the [Special Parameters Used by AWS Glue](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html) topic in the Glue developer guide for additional information.
 * ## Example Usage
 * ### Python Job
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Job;
 * import com.pulumi.aws.glue.JobArgs;
 * import com.pulumi.aws.glue.inputs.JobCommandArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Job("example", JobArgs.builder()
 *             .roleArn(aws_iam_role.example().arn())
 *             .command(JobCommandArgs.builder()
 *                 .scriptLocation(String.format("s3://%s/example.py", aws_s3_bucket.example().bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Ray Job
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Job;
 * import com.pulumi.aws.glue.JobArgs;
 * import com.pulumi.aws.glue.inputs.JobCommandArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Job("example", JobArgs.builder()
 *             .roleArn(aws_iam_role.example().arn())
 *             .glueVersion("4.0")
 *             .workerType("Z.2X")
 *             .command(JobCommandArgs.builder()
 *                 .name("glueray")
 *                 .pythonVersion("3.9")
 *                 .runtime("Ray2.4")
 *                 .scriptLocation(String.format("s3://%s/example.py", aws_s3_bucket.example().bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Scala Job
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Job;
 * import com.pulumi.aws.glue.JobArgs;
 * import com.pulumi.aws.glue.inputs.JobCommandArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Job("example", JobArgs.builder()
 *             .roleArn(aws_iam_role.example().arn())
 *             .command(JobCommandArgs.builder()
 *                 .scriptLocation(String.format("s3://%s/example.scala", aws_s3_bucket.example().bucket()))
 *                 .build())
 *             .defaultArguments(Map.of("--job-language", "scala"))
 *             .build());
 *     }
 * }
 * ```
 * ### Streaming Job
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Job;
 * import com.pulumi.aws.glue.JobArgs;
 * import com.pulumi.aws.glue.inputs.JobCommandArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Job("example", JobArgs.builder()
 *             .roleArn(aws_iam_role.example().arn())
 *             .command(JobCommandArgs.builder()
 *                 .name("gluestreaming")
 *                 .scriptLocation(String.format("s3://%s/example.script", aws_s3_bucket.example().bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Enabling CloudWatch Logs and Metrics
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.glue.Job;
 * import com.pulumi.aws.glue.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup("exampleLogGroup", LogGroupArgs.builder()
 *             .retentionInDays(14)
 *             .build());
 *         var exampleJob = new Job("exampleJob", JobArgs.builder()
 *             .defaultArguments(Map.ofEntries(
 *                 Map.entry("--continuous-log-logGroup", exampleLogGroup.name()),
 *                 Map.entry("--enable-continuous-cloudwatch-log", "true"),
 *                 Map.entry("--enable-continuous-log-filter", "true"),
 *                 Map.entry("--enable-metrics", "")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Jobs using `name`. For example:
 * ```sh
 *  $ pulumi import aws:glue/job:Job MyJob MyJob
 * ```
 * @property command The command of the job. Defined below.
 * @property connections The list of connections used for this job.
 * @property defaultArguments The map of default arguments for this job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes. For information about how to specify and consume your own Job arguments, see the [Calling AWS Glue APIs in Python](http://docs&#46;aws&#46;amazon&#46;com/glue/latest/dg/aws-glue-programming-python-calling&#46;html) topic in the developer guide&#46; For information about the key-value pairs that AWS Glue consumes to set up your job, see the [Special Parameters Used by AWS Glue](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html) topic in the developer guide.
 * @property description Description of the job.
 * @property executionClass Indicates whether the job is run with a standard or flexible execution class. The standard execution class is ideal for time-sensitive workloads that require fast job startup and dedicated resources. Valid value: `FLEX`, `STANDARD`.
 * @property executionProperty Execution property of the job. Defined below.
 * @property glueVersion The version of glue to use, for example "1.0". Ray jobs should set this to 4.0 or greater. For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
 * @property maxCapacity The maximum number of AWS Glue data processing units (DPUs) that can be allocated when this job runs. `Required` when `pythonshell` is set, accept either `0.0625` or `1.0`. Use `number_of_workers` and `worker_type` arguments instead with `glue_version` `2.0` and above.
 * @property maxRetries The maximum number of times to retry this job if it fails.
 * @property name The name you assign to this job. It must be unique in your account.
 * @property nonOverridableArguments Non-overridable arguments for this job, specified as name-value pairs.
 * @property notificationProperty Notification property of the job. Defined below.
 * @property numberOfWorkers The number of workers of a defined workerType that are allocated when a job runs.
 * @property roleArn The ARN of the IAM role associated with this job.
 * @property securityConfiguration The name of the Security Configuration to be associated with the job.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeout The job timeout in minutes. The default is 2880 minutes (48 hours) for `glueetl` and `pythonshell` jobs, and null (unlimited) for `gluestreaming` jobs.
 * @property workerType The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, G.2X, or G.025X for Spark jobs. Accepts the value Z.2X for Ray jobs.
 * * For the Standard worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
 * * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
 * * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
 * * For the G.025X worker type, each worker maps to 0.25 DPU (2 vCPU, 4GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for low volume streaming jobs. Only available for Glue version 3.0.
 * * For the Z.2X worker type, each worker maps to 2 M-DPU (8vCPU, 64 GB of m emory, 128 GB disk), and provides up to 8 Ray workers based on the autoscaler.
 */
public data class JobArgs(
    public val command: Output<JobCommandArgs>? = null,
    public val connections: Output<List<String>>? = null,
    public val defaultArguments: Output<Map<String, String>>? = null,
    public val description: Output<String>? = null,
    public val executionClass: Output<String>? = null,
    public val executionProperty: Output<JobExecutionPropertyArgs>? = null,
    public val glueVersion: Output<String>? = null,
    public val maxCapacity: Output<Double>? = null,
    public val maxRetries: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val nonOverridableArguments: Output<Map<String, String>>? = null,
    public val notificationProperty: Output<JobNotificationPropertyArgs>? = null,
    public val numberOfWorkers: Output<Int>? = null,
    public val roleArn: Output<String>? = null,
    public val securityConfiguration: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeout: Output<Int>? = null,
    public val workerType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.JobArgs> {
    override fun toJava(): com.pulumi.aws.glue.JobArgs = com.pulumi.aws.glue.JobArgs.builder()
        .command(command?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .connections(connections?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .defaultArguments(
            defaultArguments?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        )
        .description(description?.applyValue({ args0 -> args0 }))
        .executionClass(executionClass?.applyValue({ args0 -> args0 }))
        .executionProperty(executionProperty?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .glueVersion(glueVersion?.applyValue({ args0 -> args0 }))
        .maxCapacity(maxCapacity?.applyValue({ args0 -> args0 }))
        .maxRetries(maxRetries?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .nonOverridableArguments(
            nonOverridableArguments?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        )
        .notificationProperty(
            notificationProperty?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .numberOfWorkers(numberOfWorkers?.applyValue({ args0 -> args0 }))
        .roleArn(roleArn?.applyValue({ args0 -> args0 }))
        .securityConfiguration(securityConfiguration?.applyValue({ args0 -> args0 }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .timeout(timeout?.applyValue({ args0 -> args0 }))
        .workerType(workerType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobArgs].
 */
@PulumiTagMarker
public class JobArgsBuilder internal constructor() {
    private var command: Output<JobCommandArgs>? = null

    private var connections: Output<List<String>>? = null

    private var defaultArguments: Output<Map<String, String>>? = null

    private var description: Output<String>? = null

    private var executionClass: Output<String>? = null

    private var executionProperty: Output<JobExecutionPropertyArgs>? = null

    private var glueVersion: Output<String>? = null

    private var maxCapacity: Output<Double>? = null

    private var maxRetries: Output<Int>? = null

    private var name: Output<String>? = null

    private var nonOverridableArguments: Output<Map<String, String>>? = null

    private var notificationProperty: Output<JobNotificationPropertyArgs>? = null

    private var numberOfWorkers: Output<Int>? = null

    private var roleArn: Output<String>? = null

    private var securityConfiguration: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeout: Output<Int>? = null

    private var workerType: Output<String>? = null

    /**
     * @param value The command of the job. Defined below.
     */
    @JvmName("bpufjyenyqjhojpo")
    public suspend fun command(`value`: Output<JobCommandArgs>) {
        this.command = value
    }

    /**
     * @param value The list of connections used for this job.
     */
    @JvmName("ogktrnmchsemxwgl")
    public suspend fun connections(`value`: Output<List<String>>) {
        this.connections = value
    }

    @JvmName("rcalrbnetsdteegy")
    public suspend fun connections(vararg values: Output<String>) {
        this.connections = Output.all(values.asList())
    }

    /**
     * @param values The list of connections used for this job.
     */
    @JvmName("awaoqwuarnvyygmj")
    public suspend fun connections(values: List<Output<String>>) {
        this.connections = Output.all(values)
    }

    /**
     * @param value The map of default arguments for this job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes. For information about how to specify and consume your own Job arguments, see the [Calling AWS Glue APIs in Python](http://docs&#46;aws&#46;amazon&#46;com/glue/latest/dg/aws-glue-programming-python-calling&#46;html) topic in the developer guide&#46; For information about the key-value pairs that AWS Glue consumes to set up your job, see the [Special Parameters Used by AWS Glue](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html) topic in the developer guide.
     */
    @JvmName("kusalkjteqbykxpm")
    public suspend fun defaultArguments(`value`: Output<Map<String, String>>) {
        this.defaultArguments = value
    }

    /**
     * @param value Description of the job.
     */
    @JvmName("dcqwkdgpqeclpgtn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Indicates whether the job is run with a standard or flexible execution class. The standard execution class is ideal for time-sensitive workloads that require fast job startup and dedicated resources. Valid value: `FLEX`, `STANDARD`.
     */
    @JvmName("vmigkjsmwomfgraw")
    public suspend fun executionClass(`value`: Output<String>) {
        this.executionClass = value
    }

    /**
     * @param value Execution property of the job. Defined below.
     */
    @JvmName("lstfifrrwivjwepj")
    public suspend fun executionProperty(`value`: Output<JobExecutionPropertyArgs>) {
        this.executionProperty = value
    }

    /**
     * @param value The version of glue to use, for example "1.0". Ray jobs should set this to 4.0 or greater. For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
     */
    @JvmName("vgpiklvcfioloyiq")
    public suspend fun glueVersion(`value`: Output<String>) {
        this.glueVersion = value
    }

    /**
     * @param value The maximum number of AWS Glue data processing units (DPUs) that can be allocated when this job runs. `Required` when `pythonshell` is set, accept either `0.0625` or `1.0`. Use `number_of_workers` and `worker_type` arguments instead with `glue_version` `2.0` and above.
     */
    @JvmName("ygpfdsjnihtptssl")
    public suspend fun maxCapacity(`value`: Output<Double>) {
        this.maxCapacity = value
    }

    /**
     * @param value The maximum number of times to retry this job if it fails.
     */
    @JvmName("nmjxbqersbxwwrpw")
    public suspend fun maxRetries(`value`: Output<Int>) {
        this.maxRetries = value
    }

    /**
     * @param value The name you assign to this job. It must be unique in your account.
     */
    @JvmName("ihhgyddfugycccka")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Non-overridable arguments for this job, specified as name-value pairs.
     */
    @JvmName("pngvmgslljvunofa")
    public suspend fun nonOverridableArguments(`value`: Output<Map<String, String>>) {
        this.nonOverridableArguments = value
    }

    /**
     * @param value Notification property of the job. Defined below.
     */
    @JvmName("bkticvqwcqqhsvom")
    public suspend fun notificationProperty(`value`: Output<JobNotificationPropertyArgs>) {
        this.notificationProperty = value
    }

    /**
     * @param value The number of workers of a defined workerType that are allocated when a job runs.
     */
    @JvmName("qxfsrpymnhaoqukw")
    public suspend fun numberOfWorkers(`value`: Output<Int>) {
        this.numberOfWorkers = value
    }

    /**
     * @param value The ARN of the IAM role associated with this job.
     */
    @JvmName("gyhcndpbpgdiypbk")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The name of the Security Configuration to be associated with the job.
     */
    @JvmName("cwsuyshgawkleiww")
    public suspend fun securityConfiguration(`value`: Output<String>) {
        this.securityConfiguration = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uhjaslkfrltktihj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The job timeout in minutes. The default is 2880 minutes (48 hours) for `glueetl` and `pythonshell` jobs, and null (unlimited) for `gluestreaming` jobs.
     */
    @JvmName("hgcqfknboewtfvbo")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, G.2X, or G.025X for Spark jobs. Accepts the value Z.2X for Ray jobs.
     * * For the Standard worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
     * * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
     * * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
     * * For the G.025X worker type, each worker maps to 0.25 DPU (2 vCPU, 4GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for low volume streaming jobs. Only available for Glue version 3.0.
     * * For the Z.2X worker type, each worker maps to 2 M-DPU (8vCPU, 64 GB of m emory, 128 GB disk), and provides up to 8 Ray workers based on the autoscaler.
     */
    @JvmName("uutwgopfciptasvi")
    public suspend fun workerType(`value`: Output<String>) {
        this.workerType = value
    }

    /**
     * @param value The command of the job. Defined below.
     */
    @JvmName("kwlxnyfnpalwnrqp")
    public suspend fun command(`value`: JobCommandArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param argument The command of the job. Defined below.
     */
    @JvmName("sdxkrjytvucytysy")
    public suspend fun command(argument: suspend JobCommandArgsBuilder.() -> Unit) {
        val toBeMapped = JobCommandArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.command = mapped
    }

    /**
     * @param value The list of connections used for this job.
     */
    @JvmName("xaovptxxblqlagis")
    public suspend fun connections(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connections = mapped
    }

    /**
     * @param values The list of connections used for this job.
     */
    @JvmName("pdcuobkqecsgdbpd")
    public suspend fun connections(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connections = mapped
    }

    /**
     * @param value The map of default arguments for this job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes. For information about how to specify and consume your own Job arguments, see the [Calling AWS Glue APIs in Python](http://docs&#46;aws&#46;amazon&#46;com/glue/latest/dg/aws-glue-programming-python-calling&#46;html) topic in the developer guide&#46; For information about the key-value pairs that AWS Glue consumes to set up your job, see the [Special Parameters Used by AWS Glue](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html) topic in the developer guide.
     */
    @JvmName("dlipmqchvpwpmkyi")
    public suspend fun defaultArguments(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultArguments = mapped
    }

    /**
     * @param values The map of default arguments for this job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes. For information about how to specify and consume your own Job arguments, see the [Calling AWS Glue APIs in Python](http://docs&#46;aws&#46;amazon&#46;com/glue/latest/dg/aws-glue-programming-python-calling&#46;html) topic in the developer guide&#46; For information about the key-value pairs that AWS Glue consumes to set up your job, see the [Special Parameters Used by AWS Glue](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html) topic in the developer guide.
     */
    @JvmName("rvkvwbforygcvjdo")
    public fun defaultArguments(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultArguments = mapped
    }

    /**
     * @param value Description of the job.
     */
    @JvmName("omdlrkpvehftltpa")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Indicates whether the job is run with a standard or flexible execution class. The standard execution class is ideal for time-sensitive workloads that require fast job startup and dedicated resources. Valid value: `FLEX`, `STANDARD`.
     */
    @JvmName("obhmfvxfqrioxnrk")
    public suspend fun executionClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionClass = mapped
    }

    /**
     * @param value Execution property of the job. Defined below.
     */
    @JvmName("khlxmmtrbqthbvhb")
    public suspend fun executionProperty(`value`: JobExecutionPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionProperty = mapped
    }

    /**
     * @param argument Execution property of the job. Defined below.
     */
    @JvmName("hwgwdalwaevkahpg")
    public suspend
    fun executionProperty(argument: suspend JobExecutionPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = JobExecutionPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.executionProperty = mapped
    }

    /**
     * @param value The version of glue to use, for example "1.0". Ray jobs should set this to 4.0 or greater. For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
     */
    @JvmName("utqruduwchhfpcyj")
    public suspend fun glueVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.glueVersion = mapped
    }

    /**
     * @param value The maximum number of AWS Glue data processing units (DPUs) that can be allocated when this job runs. `Required` when `pythonshell` is set, accept either `0.0625` or `1.0`. Use `number_of_workers` and `worker_type` arguments instead with `glue_version` `2.0` and above.
     */
    @JvmName("efbwvdsdylqxaojo")
    public suspend fun maxCapacity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxCapacity = mapped
    }

    /**
     * @param value The maximum number of times to retry this job if it fails.
     */
    @JvmName("yscerlavusiwlcpg")
    public suspend fun maxRetries(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRetries = mapped
    }

    /**
     * @param value The name you assign to this job. It must be unique in your account.
     */
    @JvmName("krpwjrmolcyldwpl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Non-overridable arguments for this job, specified as name-value pairs.
     */
    @JvmName("bogrrpwblegqqitr")
    public suspend fun nonOverridableArguments(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nonOverridableArguments = mapped
    }

    /**
     * @param values Non-overridable arguments for this job, specified as name-value pairs.
     */
    @JvmName("gvywssbyexfukvff")
    public fun nonOverridableArguments(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nonOverridableArguments = mapped
    }

    /**
     * @param value Notification property of the job. Defined below.
     */
    @JvmName("ohxpjjdwmmakwswj")
    public suspend fun notificationProperty(`value`: JobNotificationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationProperty = mapped
    }

    /**
     * @param argument Notification property of the job. Defined below.
     */
    @JvmName("nbdcciafrmhkoejc")
    public suspend
    fun notificationProperty(argument: suspend JobNotificationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = JobNotificationPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.notificationProperty = mapped
    }

    /**
     * @param value The number of workers of a defined workerType that are allocated when a job runs.
     */
    @JvmName("wkjqbdlpkeatpnlf")
    public suspend fun numberOfWorkers(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfWorkers = mapped
    }

    /**
     * @param value The ARN of the IAM role associated with this job.
     */
    @JvmName("qtxlasgmpjrplxku")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The name of the Security Configuration to be associated with the job.
     */
    @JvmName("fpatwbvkxbodyvds")
    public suspend fun securityConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityConfiguration = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vcbmaeugmxyhcyci")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vwnnvtjabfnysljc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The job timeout in minutes. The default is 2880 minutes (48 hours) for `glueetl` and `pythonshell` jobs, and null (unlimited) for `gluestreaming` jobs.
     */
    @JvmName("jsvptrcyafkmbrqs")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param value The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, G.2X, or G.025X for Spark jobs. Accepts the value Z.2X for Ray jobs.
     * * For the Standard worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
     * * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
     * * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
     * * For the G.025X worker type, each worker maps to 0.25 DPU (2 vCPU, 4GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for low volume streaming jobs. Only available for Glue version 3.0.
     * * For the Z.2X worker type, each worker maps to 2 M-DPU (8vCPU, 64 GB of m emory, 128 GB disk), and provides up to 8 Ray workers based on the autoscaler.
     */
    @JvmName("uqmixtrgclxogsmo")
    public suspend fun workerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerType = mapped
    }

    internal fun build(): JobArgs = JobArgs(
        command = command,
        connections = connections,
        defaultArguments = defaultArguments,
        description = description,
        executionClass = executionClass,
        executionProperty = executionProperty,
        glueVersion = glueVersion,
        maxCapacity = maxCapacity,
        maxRetries = maxRetries,
        name = name,
        nonOverridableArguments = nonOverridableArguments,
        notificationProperty = notificationProperty,
        numberOfWorkers = numberOfWorkers,
        roleArn = roleArn,
        securityConfiguration = securityConfiguration,
        tags = tags,
        timeout = timeout,
        workerType = workerType,
    )
}
