@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.MLTransformArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.MLTransformInputRecordTableArgs
import com.pulumi.aws.glue.kotlin.inputs.MLTransformInputRecordTableArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.MLTransformParametersArgs
import com.pulumi.aws.glue.kotlin.inputs.MLTransformParametersArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Glue ML Transform resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogDatabase;
 * import com.pulumi.aws.glue.CatalogDatabaseArgs;
 * import com.pulumi.aws.glue.CatalogTable;
 * import com.pulumi.aws.glue.CatalogTableArgs;
 * import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorArgs;
 * import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSerDeInfoArgs;
 * import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSkewedInfoArgs;
 * import com.pulumi.aws.glue.inputs.CatalogTablePartitionKeyArgs;
 * import com.pulumi.aws.glue.MLTransform;
 * import com.pulumi.aws.glue.MLTransformArgs;
 * import com.pulumi.aws.glue.inputs.MLTransformInputRecordTableArgs;
 * import com.pulumi.aws.glue.inputs.MLTransformParametersArgs;
 * import com.pulumi.aws.glue.inputs.MLTransformParametersFindMatchesParametersArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCatalogDatabase = new CatalogDatabase("testCatalogDatabase", CatalogDatabaseArgs.builder()
 *             .name("example")
 *             .build());
 *         var testCatalogTable = new CatalogTable("testCatalogTable", CatalogTableArgs.builder()
 *             .name("example")
 *             .databaseName(testCatalogDatabase.name())
 *             .owner("my_owner")
 *             .retention(1)
 *             .tableType("VIRTUAL_VIEW")
 *             .viewExpandedText("view_expanded_text_1")
 *             .viewOriginalText("view_original_text_1")
 *             .storageDescriptor(CatalogTableStorageDescriptorArgs.builder()
 *                 .bucketColumns("bucket_column_1")
 *                 .compressed(false)
 *                 .inputFormat("SequenceFileInputFormat")
 *                 .location("my_location")
 *                 .numberOfBuckets(1)
 *                 .outputFormat("SequenceFileInputFormat")
 *                 .storedAsSubDirectories(false)
 *                 .parameters(Map.of("param1", "param1_val"))
 *                 .columns(
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .name("my_column_1")
 *                         .type("int")
 *                         .comment("my_column1_comment")
 *                         .build(),
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .name("my_column_2")
 *                         .type("string")
 *                         .comment("my_column2_comment")
 *                         .build())
 *                 .serDeInfo(CatalogTableStorageDescriptorSerDeInfoArgs.builder()
 *                     .name("ser_de_name")
 *                     .parameters(Map.of("param1", "param_val_1"))
 *                     .serializationLibrary("org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe")
 *                     .build())
 *                 .sortColumns(CatalogTableStorageDescriptorSortColumnArgs.builder()
 *                     .column("my_column_1")
 *                     .sortOrder(1)
 *                     .build())
 *                 .skewedInfo(CatalogTableStorageDescriptorSkewedInfoArgs.builder()
 *                     .skewedColumnNames("my_column_1")
 *                     .skewedColumnValueLocationMaps(Map.of("my_column_1", "my_column_1_val_loc_map"))
 *                     .skewedColumnValues("skewed_val_1")
 *                     .build())
 *                 .build())
 *             .partitionKeys(
 *                 CatalogTablePartitionKeyArgs.builder()
 *                     .name("my_column_1")
 *                     .type("int")
 *                     .comment("my_column_1_comment")
 *                     .build(),
 *                 CatalogTablePartitionKeyArgs.builder()
 *                     .name("my_column_2")
 *                     .type("string")
 *                     .comment("my_column_2_comment")
 *                     .build())
 *             .parameters(Map.of("param1", "param1_val"))
 *             .build());
 *         var testMLTransform = new MLTransform("testMLTransform", MLTransformArgs.builder()
 *             .roleArn(aws_iam_role.test().arn())
 *             .inputRecordTables(MLTransformInputRecordTableArgs.builder()
 *                 .databaseName(testCatalogTable.databaseName())
 *                 .tableName(testCatalogTable.name())
 *                 .build())
 *             .parameters(MLTransformParametersArgs.builder()
 *                 .transformType("FIND_MATCHES")
 *                 .findMatchesParameters(MLTransformParametersFindMatchesParametersArgs.builder()
 *                     .primaryKeyColumnName("my_column_1")
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_iam_role_policy_attachment.test())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue ML Transforms using `id`. For example:
 * ```sh
 *  $ pulumi import aws:glue/mLTransform:MLTransform example tfm-c2cafbe83b1c575f49eaca9939220e2fcd58e2d5
 * ```
 * @property description Description of the ML Transform.
 * @property glueVersion The version of glue to use, for example "1.0". For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
 * @property inputRecordTables A list of AWS Glue table definitions used by the transform. see Input Record Tables.
 * @property maxCapacity The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from `2` to `100` DPUs; the default is `10`. `max_capacity` is a mutually exclusive option with `number_of_workers` and `worker_type`.
 * @property maxRetries The maximum number of times to retry this ML Transform if it fails.
 * @property name The name you assign to this ML Transform. It must be unique in your account.
 * @property numberOfWorkers The number of workers of a defined `worker_type` that are allocated when an ML Transform runs. Required with `worker_type`.
 * @property parameters The algorithmic parameters that are specific to the transform type used. Conditionally dependent on the transform type. see Parameters.
 * @property roleArn The ARN of the IAM role associated with this ML Transform.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeout The ML Transform timeout in minutes. The default is 2880 minutes (48 hours).
 * @property workerType The type of predefined worker that is allocated when an ML Transform runs. Accepts a value of `Standard`, `G.1X`, or `G.2X`. Required with `number_of_workers`.
 */
public data class MLTransformArgs(
    public val description: Output<String>? = null,
    public val glueVersion: Output<String>? = null,
    public val inputRecordTables: Output<List<MLTransformInputRecordTableArgs>>? = null,
    public val maxCapacity: Output<Double>? = null,
    public val maxRetries: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val numberOfWorkers: Output<Int>? = null,
    public val parameters: Output<MLTransformParametersArgs>? = null,
    public val roleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeout: Output<Int>? = null,
    public val workerType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.MLTransformArgs> {
    override fun toJava(): com.pulumi.aws.glue.MLTransformArgs =
        com.pulumi.aws.glue.MLTransformArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .glueVersion(glueVersion?.applyValue({ args0 -> args0 }))
            .inputRecordTables(
                inputRecordTables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .maxCapacity(maxCapacity?.applyValue({ args0 -> args0 }))
            .maxRetries(maxRetries?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .numberOfWorkers(numberOfWorkers?.applyValue({ args0 -> args0 }))
            .parameters(parameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeout(timeout?.applyValue({ args0 -> args0 }))
            .workerType(workerType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MLTransformArgs].
 */
@PulumiTagMarker
public class MLTransformArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var glueVersion: Output<String>? = null

    private var inputRecordTables: Output<List<MLTransformInputRecordTableArgs>>? = null

    private var maxCapacity: Output<Double>? = null

    private var maxRetries: Output<Int>? = null

    private var name: Output<String>? = null

    private var numberOfWorkers: Output<Int>? = null

    private var parameters: Output<MLTransformParametersArgs>? = null

    private var roleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeout: Output<Int>? = null

    private var workerType: Output<String>? = null

    /**
     * @param value Description of the ML Transform.
     */
    @JvmName("enjeikdiivlwckwj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The version of glue to use, for example "1.0". For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
     */
    @JvmName("eftlvtbronfhyryi")
    public suspend fun glueVersion(`value`: Output<String>) {
        this.glueVersion = value
    }

    /**
     * @param value A list of AWS Glue table definitions used by the transform. see Input Record Tables.
     */
    @JvmName("vshmiedsmauxmgig")
    public suspend fun inputRecordTables(`value`: Output<List<MLTransformInputRecordTableArgs>>) {
        this.inputRecordTables = value
    }

    @JvmName("xmfebkhfcwkqnsdp")
    public suspend fun inputRecordTables(vararg values: Output<MLTransformInputRecordTableArgs>) {
        this.inputRecordTables = Output.all(values.asList())
    }

    /**
     * @param values A list of AWS Glue table definitions used by the transform. see Input Record Tables.
     */
    @JvmName("qlhpssodhldhcjfd")
    public suspend fun inputRecordTables(values: List<Output<MLTransformInputRecordTableArgs>>) {
        this.inputRecordTables = Output.all(values)
    }

    /**
     * @param value The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from `2` to `100` DPUs; the default is `10`. `max_capacity` is a mutually exclusive option with `number_of_workers` and `worker_type`.
     */
    @JvmName("qrkwkqujneswdrjj")
    public suspend fun maxCapacity(`value`: Output<Double>) {
        this.maxCapacity = value
    }

    /**
     * @param value The maximum number of times to retry this ML Transform if it fails.
     */
    @JvmName("jogpjpphiffkrnch")
    public suspend fun maxRetries(`value`: Output<Int>) {
        this.maxRetries = value
    }

    /**
     * @param value The name you assign to this ML Transform. It must be unique in your account.
     */
    @JvmName("yrqwyrtlrgxcqsdg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The number of workers of a defined `worker_type` that are allocated when an ML Transform runs. Required with `worker_type`.
     */
    @JvmName("yjxmgdltchggbugl")
    public suspend fun numberOfWorkers(`value`: Output<Int>) {
        this.numberOfWorkers = value
    }

    /**
     * @param value The algorithmic parameters that are specific to the transform type used. Conditionally dependent on the transform type. see Parameters.
     */
    @JvmName("luglhnfnplcinrnv")
    public suspend fun parameters(`value`: Output<MLTransformParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value The ARN of the IAM role associated with this ML Transform.
     */
    @JvmName("rovavnmukfqurnua")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cqruuwilhrympabj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ML Transform timeout in minutes. The default is 2880 minutes (48 hours).
     */
    @JvmName("pueohqemkjmotfdc")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value The type of predefined worker that is allocated when an ML Transform runs. Accepts a value of `Standard`, `G.1X`, or `G.2X`. Required with `number_of_workers`.
     */
    @JvmName("inhgbkybruklhmwe")
    public suspend fun workerType(`value`: Output<String>) {
        this.workerType = value
    }

    /**
     * @param value Description of the ML Transform.
     */
    @JvmName("wibcjpehliwpuarw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The version of glue to use, for example "1.0". For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
     */
    @JvmName("wvcikihwisvoimgy")
    public suspend fun glueVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.glueVersion = mapped
    }

    /**
     * @param value A list of AWS Glue table definitions used by the transform. see Input Record Tables.
     */
    @JvmName("cogmxiufnxscftug")
    public suspend fun inputRecordTables(`value`: List<MLTransformInputRecordTableArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputRecordTables = mapped
    }

    /**
     * @param argument A list of AWS Glue table definitions used by the transform. see Input Record Tables.
     */
    @JvmName("htacekkhldfoqpxb")
    public suspend
    fun inputRecordTables(argument: List<suspend MLTransformInputRecordTableArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MLTransformInputRecordTableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inputRecordTables = mapped
    }

    /**
     * @param argument A list of AWS Glue table definitions used by the transform. see Input Record Tables.
     */
    @JvmName("xcotwlmvrtsvsxdw")
    public suspend fun inputRecordTables(
        vararg
        argument: suspend MLTransformInputRecordTableArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MLTransformInputRecordTableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inputRecordTables = mapped
    }

    /**
     * @param argument A list of AWS Glue table definitions used by the transform. see Input Record Tables.
     */
    @JvmName("jccuvckafdbccrue")
    public suspend
    fun inputRecordTables(argument: suspend MLTransformInputRecordTableArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MLTransformInputRecordTableArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.inputRecordTables = mapped
    }

    /**
     * @param values A list of AWS Glue table definitions used by the transform. see Input Record Tables.
     */
    @JvmName("brftnpexbetwdfyf")
    public suspend fun inputRecordTables(vararg values: MLTransformInputRecordTableArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputRecordTables = mapped
    }

    /**
     * @param value The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from `2` to `100` DPUs; the default is `10`. `max_capacity` is a mutually exclusive option with `number_of_workers` and `worker_type`.
     */
    @JvmName("maiyfgobgcmcmsnk")
    public suspend fun maxCapacity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxCapacity = mapped
    }

    /**
     * @param value The maximum number of times to retry this ML Transform if it fails.
     */
    @JvmName("ncdsqqjoaypnptcm")
    public suspend fun maxRetries(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRetries = mapped
    }

    /**
     * @param value The name you assign to this ML Transform. It must be unique in your account.
     */
    @JvmName("ijqdvepvrmrpuuws")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The number of workers of a defined `worker_type` that are allocated when an ML Transform runs. Required with `worker_type`.
     */
    @JvmName("pcsretxscmisrhim")
    public suspend fun numberOfWorkers(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfWorkers = mapped
    }

    /**
     * @param value The algorithmic parameters that are specific to the transform type used. Conditionally dependent on the transform type. see Parameters.
     */
    @JvmName("rgnvdokoepnwckuo")
    public suspend fun parameters(`value`: MLTransformParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The algorithmic parameters that are specific to the transform type used. Conditionally dependent on the transform type. see Parameters.
     */
    @JvmName("ewbuiibubykltwyl")
    public suspend fun parameters(argument: suspend MLTransformParametersArgsBuilder.() -> Unit) {
        val toBeMapped = MLTransformParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param value The ARN of the IAM role associated with this ML Transform.
     */
    @JvmName("sanqdumqisqvmfht")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("abccuaujhlrasigs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nehqlhtatwtfejbc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ML Transform timeout in minutes. The default is 2880 minutes (48 hours).
     */
    @JvmName("cflgpdubanghaqgy")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param value The type of predefined worker that is allocated when an ML Transform runs. Accepts a value of `Standard`, `G.1X`, or `G.2X`. Required with `number_of_workers`.
     */
    @JvmName("vdogpfbchkxkxxds")
    public suspend fun workerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerType = mapped
    }

    internal fun build(): MLTransformArgs = MLTransformArgs(
        description = description,
        glueVersion = glueVersion,
        inputRecordTables = inputRecordTables,
        maxCapacity = maxCapacity,
        maxRetries = maxRetries,
        name = name,
        numberOfWorkers = numberOfWorkers,
        parameters = parameters,
        roleArn = roleArn,
        tags = tags,
        timeout = timeout,
        workerType = workerType,
    )
}
