@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.kotlin.outputs.PartitionStorageDescriptor
import com.pulumi.aws.glue.kotlin.outputs.PartitionStorageDescriptor.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Partition].
 */
@PulumiTagMarker
public class PartitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PartitionArgs = PartitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PartitionArgsBuilder.() -> Unit) {
        val builder = PartitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Partition {
        val builtJavaResource = com.pulumi.aws.glue.Partition(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Partition(builtJavaResource)
    }
}

/**
 * Provides a Glue Partition Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Partition;
 * import com.pulumi.aws.glue.PartitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Partition("example", PartitionArgs.builder()
 *             .databaseName("some-database")
 *             .tableName("some-table")
 *             .values("some-value")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Partitions using the catalog ID (usually AWS account ID), database name, table name and partition values. For example:
 * ```sh
 *  $ pulumi import aws:glue/partition:Partition part 123456789012:MyDatabase:MyTable:val1#val2
 * ```
 *
 */
public class Partition internal constructor(
    override val javaResource: com.pulumi.aws.glue.Partition,
) : KotlinCustomResource(javaResource, PartitionMapper) {
    /**
     * ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
     */
    public val catalogId: Output<String>
        get() = javaResource.catalogId().applyValue({ args0 -> args0 })

    /**
     * The time at which the partition was created.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
     */
    public val databaseName: Output<String>
        get() = javaResource.databaseName().applyValue({ args0 -> args0 })

    /**
     * The last time at which the partition was accessed.
     */
    public val lastAccessedTime: Output<String>
        get() = javaResource.lastAccessedTime().applyValue({ args0 -> args0 })

    /**
     * The last time at which column statistics were computed for this partition.
     */
    public val lastAnalyzedTime: Output<String>
        get() = javaResource.lastAnalyzedTime().applyValue({ args0 -> args0 })

    /**
     * Properties associated with this table, as a list of key-value pairs.
     */
    public val parameters: Output<Map<String, String>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The values that define the partition.
     */
    public val partitionValues: Output<List<String>>
        get() = javaResource.partitionValues().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A storage descriptor object containing information about the physical storage of this table. You can refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor) for a full explanation of this object.
     */
    public val storageDescriptor: Output<PartitionStorageDescriptor>?
        get() = javaResource.storageDescriptor().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    public val tableName: Output<String>
        get() = javaResource.tableName().applyValue({ args0 -> args0 })
}

public object PartitionMapper : ResourceMapper<Partition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glue.Partition::class == javaResource::class

    override fun map(javaResource: Resource): Partition = Partition(
        javaResource as
            com.pulumi.aws.glue.Partition,
    )
}

/**
 * @see [Partition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Partition].
 */
public suspend fun partition(name: String, block: suspend PartitionResourceBuilder.() -> Unit):
    Partition {
    val builder = PartitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Partition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun partition(name: String): Partition {
    val builder = PartitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
