@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.kotlin.outputs.PartitionIndexPartitionIndex
import com.pulumi.aws.glue.kotlin.outputs.PartitionIndexPartitionIndex.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PartitionIndex].
 */
@PulumiTagMarker
public class PartitionIndexResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PartitionIndexArgs = PartitionIndexArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PartitionIndexArgsBuilder.() -> Unit) {
        val builder = PartitionIndexArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PartitionIndex {
        val builtJavaResource = com.pulumi.aws.glue.PartitionIndex(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PartitionIndex(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogDatabase;
 * import com.pulumi.aws.glue.CatalogDatabaseArgs;
 * import com.pulumi.aws.glue.CatalogTable;
 * import com.pulumi.aws.glue.CatalogTableArgs;
 * import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorArgs;
 * import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSerDeInfoArgs;
 * import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSkewedInfoArgs;
 * import com.pulumi.aws.glue.inputs.CatalogTablePartitionKeyArgs;
 * import com.pulumi.aws.glue.PartitionIndex;
 * import com.pulumi.aws.glue.PartitionIndexArgs;
 * import com.pulumi.aws.glue.inputs.PartitionIndexPartitionIndexArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCatalogDatabase = new CatalogDatabase("exampleCatalogDatabase", CatalogDatabaseArgs.builder()
 *             .name("example")
 *             .build());
 *         var exampleCatalogTable = new CatalogTable("exampleCatalogTable", CatalogTableArgs.builder()
 *             .name("example")
 *             .databaseName(exampleCatalogDatabase.name())
 *             .owner("my_owner")
 *             .retention(1)
 *             .tableType("VIRTUAL_VIEW")
 *             .viewExpandedText("view_expanded_text_1")
 *             .viewOriginalText("view_original_text_1")
 *             .storageDescriptor(CatalogTableStorageDescriptorArgs.builder()
 *                 .bucketColumns("bucket_column_1")
 *                 .compressed(false)
 *                 .inputFormat("SequenceFileInputFormat")
 *                 .location("my_location")
 *                 .numberOfBuckets(1)
 *                 .outputFormat("SequenceFileInputFormat")
 *                 .storedAsSubDirectories(false)
 *                 .parameters(Map.of("param1", "param1_val"))
 *                 .columns(
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .name("my_column_1")
 *                         .type("int")
 *                         .comment("my_column1_comment")
 *                         .build(),
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .name("my_column_2")
 *                         .type("string")
 *                         .comment("my_column2_comment")
 *                         .build())
 *                 .serDeInfo(CatalogTableStorageDescriptorSerDeInfoArgs.builder()
 *                     .name("ser_de_name")
 *                     .parameters(Map.of("param1", "param_val_1"))
 *                     .serializationLibrary("org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe")
 *                     .build())
 *                 .sortColumns(CatalogTableStorageDescriptorSortColumnArgs.builder()
 *                     .column("my_column_1")
 *                     .sortOrder(1)
 *                     .build())
 *                 .skewedInfo(CatalogTableStorageDescriptorSkewedInfoArgs.builder()
 *                     .skewedColumnNames("my_column_1")
 *                     .skewedColumnValueLocationMaps(Map.of("my_column_1", "my_column_1_val_loc_map"))
 *                     .skewedColumnValues("skewed_val_1")
 *                     .build())
 *                 .build())
 *             .partitionKeys(
 *                 CatalogTablePartitionKeyArgs.builder()
 *                     .name("my_column_1")
 *                     .type("int")
 *                     .comment("my_column_1_comment")
 *                     .build(),
 *                 CatalogTablePartitionKeyArgs.builder()
 *                     .name("my_column_2")
 *                     .type("string")
 *                     .comment("my_column_2_comment")
 *                     .build())
 *             .parameters(Map.of("param1", "param1_val"))
 *             .build());
 *         var examplePartitionIndex = new PartitionIndex("examplePartitionIndex", PartitionIndexArgs.builder()
 *             .databaseName(exampleCatalogDatabase.name())
 *             .tableName(exampleCatalogTable.name())
 *             .partitionIndex(PartitionIndexPartitionIndexArgs.builder()
 *                 .indexName("example")
 *                 .keys(
 *                     "my_column_1",
 *                     "my_column_2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Glue Partition Indexes using the catalog ID (usually AWS account ID), database name, table name, and index name. For example:
 * ```sh
 *  $ pulumi import aws:glue/partitionIndex:PartitionIndex example 123456789012:MyDatabase:MyTable:index-name
 * ```
 *
 */
public class PartitionIndex internal constructor(
    override val javaResource: com.pulumi.aws.glue.PartitionIndex,
) : KotlinCustomResource(javaResource, PartitionIndexMapper) {
    /**
     * The catalog ID where the table resides.
     */
    public val catalogId: Output<String>
        get() = javaResource.catalogId().applyValue({ args0 -> args0 })

    /**
     * Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
     */
    public val databaseName: Output<String>
        get() = javaResource.databaseName().applyValue({ args0 -> args0 })

    /**
     * Configuration block for a partition index. See `partition_index` below.
     */
    public val partitionIndex: Output<PartitionIndexPartitionIndex>
        get() = javaResource.partitionIndex().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Name of the table. For Hive compatibility, this must be entirely lowercase.
     */
    public val tableName: Output<String>
        get() = javaResource.tableName().applyValue({ args0 -> args0 })
}

public object PartitionIndexMapper : ResourceMapper<PartitionIndex> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glue.PartitionIndex::class == javaResource::class

    override fun map(javaResource: Resource): PartitionIndex = PartitionIndex(
        javaResource as
            com.pulumi.aws.glue.PartitionIndex,
    )
}

/**
 * @see [PartitionIndex].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PartitionIndex].
 */
public suspend fun partitionIndex(
    name: String,
    block: suspend PartitionIndexResourceBuilder.() -> Unit,
): PartitionIndex {
    val builder = PartitionIndexResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PartitionIndex].
 * @param name The _unique_ name of the resulting resource.
 */
public fun partitionIndex(name: String): PartitionIndex {
    val builder = PartitionIndexResourceBuilder()
    builder.name(name)
    return builder.build()
}
